/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;

public class CookiesUtils {
    Hashtable mm_listCookies = new Hashtable();

    public CookiesUtils() {
    }

    public CookiesUtils(Cookie[] cookies) {
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                this.mm_listCookies.put(cookie.getName(), cookie);
                ++i;
            }
        }
    }

    public Cookie addCookie(Cookie cookie) {
        Cookie oldCookie = (Cookie)this.mm_listCookies.get(cookie.getName());
        if (oldCookie != null) {
            this.mm_listCookies.remove(cookie.getName());
        }
        this.mm_listCookies.put(cookie.getName(), cookie);
        return oldCookie;
    }

    public Collection getAllCookies() {
        return this.mm_listCookies.values();
    }

    public String getFormattedListCookies() {
        if (this.mm_listCookies.size() == 0) {
            return null;
        }
        StringBuffer buf = null;
        Enumeration iter = this.mm_listCookies.keys();
        while (iter.hasMoreElements()) {
            String element = (String)iter.nextElement();
            Cookie cook = (Cookie)this.mm_listCookies.get(element);
            if (buf == null) {
                buf = new StringBuffer();
            } else {
                buf.append(";");
            }
            buf.append(this.cookieToString(cook));
        }
        return buf.toString();
    }

    private String cookieToString(Cookie cookie) {
        return cookie.getName() + "=" + cookie.getValue();
    }

    public static Cookie extractCookieFromString(String value) {
        Cookie cookie = null;
        if (value != null) {
            int indexEqual;
            int index = (value = value.trim()).indexOf(59);
            if (index != -1) {
                value = value.substring(0, index);
            }
            if ((indexEqual = value.indexOf(61)) != -1) {
                String name = value.substring(0, indexEqual);
                String item = value.substring(indexEqual + 1);
                if (CookiesUtils.isValidKey(name)) {
                    cookie = new Cookie(name, item);
                }
            }
        }
        return cookie;
    }

    public static Cookie[] extractCookiesFromMimeHeaders(MimeHeaders mime) {
        Iterator mimeIt = mime.getAllHeaders();
        Vector listOfCookies = new Vector();
        Cookie[] listresult = null;
        while (mimeIt.hasNext()) {
            MimeHeader element = (MimeHeader)mimeIt.next();
            if (!element.getName().equals("set-cookie") && !element.getName().equals("cookie")) continue;
            CookiesUtils.extractListCookiesFromStringToVestor(element.getValue(), listOfCookies);
        }
        int size = listOfCookies.size();
        if (size != 0) {
            listresult = new Cookie[size];
            int i = 0;
            while (i < size) {
                listresult[i] = (Cookie)listOfCookies.get(i);
                ++i;
            }
        }
        return listresult;
    }

    private static Vector extractListCookiesFromStringToVestor(String cookiesS, Vector listToReturn) {
        StringTokenizer token = new StringTokenizer(cookiesS, ";");
        while (token.hasMoreTokens()) {
            String cookiesToExtract = token.nextToken();
            Cookie cookie = CookiesUtils.extractCookieFromString(cookiesToExtract);
            if (cookie == null) continue;
            listToReturn.add(cookie);
        }
        return listToReturn;
    }

    private static boolean isValidKey(String name) {
        return !name.equalsIgnoreCase("Comment") && !name.equalsIgnoreCase("Discard") && !name.equalsIgnoreCase("Domain") && !name.equalsIgnoreCase("Expires") && !name.equalsIgnoreCase("Max-Age") && !name.equalsIgnoreCase("Path") && !name.equalsIgnoreCase("Secure") && !name.equalsIgnoreCase("Version");
    }
}

