/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.util;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.registry.PortalRegistry;
import com.sapportals.portal.prt.registry.content.StreamSource;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.soap.SOAPServiceManager;
import com.sapportals.portal.prt.service.soap.util.IConfigurationSOAPService;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;

public class ConfigurationSOAPService
implements IConfigurationSOAPService {
    private static ConfigurationSOAPService mm_config = null;
    private File mm_fileprops = null;
    private IServiceContext mm_serviceContext = null;

    private ConfigurationSOAPService(IServiceContext serviceContext) {
        this.mm_serviceContext = serviceContext;
        this.mm_fileprops = new File(this.mm_serviceContext.getPrivateServicePath() + File.separator + "soap.properties");
        this.initPropertiesFromFile();
    }

    /*
     * Loose catch block
     */
    private void initPropertiesFromFile() {
        block23: {
            Properties mm_props;
            Properties proplocal;
            block21: {
                ILogger logger3222;
                FileInputStream in;
                block20: {
                    in = null;
                    proplocal = null;
                    if (!this.mm_fileprops.exists()) break block20;
                    in = new FileInputStream(this.mm_fileprops);
                    proplocal = new Properties();
                    proplocal.load(in);
                }
                Object var6_3 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block21;
                }
                catch (Exception ex2) {
                    logger3222 = PortalRuntime.getLogger((String)"SOAPLogger");
                    if (logger3222 != null && logger3222.isActive()) {
                        logger3222.info((Object)this, (Throwable)ex2, "SOAP Service Configuration Problem");
                    }
                    break block21;
                }
                {
                    catch (Exception ex) {
                        ILogger logger2 = PortalRuntime.getLogger((String)"SOAPLogger");
                        if (logger2 != null && logger2.isActive()) {
                            logger2.info((Object)this, (Throwable)ex, "SOAP Service Configuration Problem");
                        }
                        var6_3 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block21;
                        }
                        catch (Exception ex2) {
                            logger3222 = PortalRuntime.getLogger((String)"SOAPLogger");
                            if (logger3222 != null && logger3222.isActive()) {
                                logger3222.info((Object)this, (Throwable)ex2, "SOAP Service Configuration Problem");
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    block22: {
                        Object var6_4 = null;
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception ex2) {
                            ILogger logger3222 = PortalRuntime.getLogger((String)"SOAPLogger");
                            if (logger3222 == null || !logger3222.isActive()) break block22;
                            logger3222.info((Object)this, (Throwable)ex2, "SOAP Service Configuration Problem");
                        }
                    }
                    throw throwable;
                }
            }
            if ((mm_props = this.getMainSOAPServiceConfiguration()) == null || ((Hashtable)mm_props).isEmpty()) {
                mm_props = proplocal;
            } else {
                Enumeration<?> enumeration = proplocal.propertyNames();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    if (((Hashtable)mm_props).containsKey(key)) continue;
                    mm_props.setProperty((String)key, proplocal.getProperty((String)key));
                }
            }
            Context subcontext = this.getSOAPContextConfiguration();
            if (subcontext != null && mm_props != null) {
                try {
                    subcontext.rebind("configProp", (Object)new StreamSource(mm_props));
                }
                catch (NamingException ex) {
                    ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                    if (logger == null || !logger.isActive()) break block23;
                    logger.info((Object)this, (Throwable)ex, "SOAP Service Configuration Problem: not able to rebind context configProp for " + this.mm_serviceContext.getApplicationName());
                }
            }
        }
    }

    private Context getSOAPContextConfiguration() {
        Context subcontext;
        block10: {
            ILogger logger;
            Context context;
            block9: {
                try {
                    Context ccs = PortalRegistry.getCentralConfigurationContext();
                    context = (Context)ccs.lookup(this.mm_serviceContext.getApplicationName());
                }
                catch (NamingException ex) {
                    ILogger logger2 = PortalRuntime.getLogger((String)"SOAPLogger");
                    if (logger2 != null && logger2.isActive()) {
                        logger2.info((Object)this, (Throwable)ex, "SOAP Service Configuration problem: not able to read subcontext for " + this.mm_serviceContext.getApplicationName());
                    }
                    return null;
                }
                if (context == null) {
                    return null;
                }
                subcontext = null;
                try {
                    subcontext = (Context)context.lookup("config");
                }
                catch (NamingException ex) {
                    logger = PortalRuntime.getLogger((String)"SOAPLogger");
                    if (logger == null || !logger.isActive()) break block9;
                    logger.warning((Object)this, (Throwable)ex, "SOAP Service Configuration problem: not able to read subcontext config for " + this.mm_serviceContext.getApplicationName());
                }
            }
            if (subcontext == null) {
                try {
                    subcontext = context.createSubcontext("config");
                }
                catch (NamingException e) {
                    logger = PortalRuntime.getLogger((String)"SOAPLogger");
                    if (logger == null || !logger.isActive()) break block10;
                    logger.warning((Object)this, (Throwable)e, "SOAP Service Configuration problem: not able to read subcontext config for " + this.mm_serviceContext.getApplicationName());
                }
            }
        }
        return subcontext;
    }

    private Properties getMainSOAPServiceConfiguration() {
        Properties prop = null;
        SOAPServiceManager soapsermanager = SOAPServiceManager.getInstance();
        if (soapsermanager != null) {
            prop = soapsermanager.getMainSOAPServiceInstance();
        }
        return prop;
    }

    public static ConfigurationSOAPService getInstance(IServiceContext serviceContext) {
        if (mm_config == null) {
            mm_config = new ConfigurationSOAPService(serviceContext);
        }
        return mm_config;
    }

    public static ConfigurationSOAPService getInstance() {
        return mm_config;
    }

    public boolean readPropertieBoolean(String propertie) throws Exception {
        String value = this.readPropertie(propertie);
        return value != null && value.equalsIgnoreCase("true");
    }

    public String readPropertie(String propertie) throws Exception {
        Properties props = this.getMainSOAPServiceConfiguration();
        if (props == null) {
            return null;
        }
        String ValuePropertie = null;
        ValuePropertie = props.getProperty(propertie);
        return ValuePropertie;
    }

    public void writePropertieBoolean(String propertie, boolean value) throws Exception {
        if (propertie != null) {
            if (value) {
                this.writePropertie(propertie, "true");
            } else {
                this.writePropertie(propertie, "false");
            }
        }
    }

    public void writePropertie(String propertie, String value) throws Exception {
        Properties prop = null;
        SOAPServiceManager soapsermanager = SOAPServiceManager.getInstance();
        if (soapsermanager != null && (prop = soapsermanager.getMainSOAPServiceInstance()) != null) {
            prop.setProperty(propertie, value);
            soapsermanager.setMainSOAPServiceInstance(prop);
        }
    }

    public static void destroy() {
        mm_config = null;
    }
}

