/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.security;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPSignature;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPSignedInfo;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPSecurityElement;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPSignedInfo;
import com.sapportals.portal.prt.service.soap.types.Base64;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class PRTSOAPSignature
extends PRTSOAPSecurityElement
implements IPRTSOAPSignature {
    private Base64 mm_signatureValue = null;
    private String mm_id = null;
    private PRTSOAPSignedInfo mm_signedInfo = null;

    public PRTSOAPSignature(SOAPElement signature) {
        Iterator iter1 = signature.getChildElements();
        while (iter1.hasNext()) {
            SOAPElement child = (SOAPElement)iter1.next();
            if (child.getElementName().getLocalName().equals("SignatureValue")) {
                String valuesign = new String(new Base64(child.getValue().getBytes()).decode());
                this.mm_signatureValue = new Base64(valuesign.getBytes());
            }
            if (!child.getElementName().getLocalName().equals("SignedInfo")) continue;
            this.mm_signedInfo = new PRTSOAPSignedInfo(child);
        }
    }

    public PRTSOAPSignature(String actor, String mustUnderstand, Base64 signatureValue, Base64 digestValue, String digestMethodAlgorithmNamespace, String id) {
        super(actor, mustUnderstand);
        this.mm_signatureValue = signatureValue;
        this.mm_id = id;
        this.mm_signedInfo = new PRTSOAPSignedInfo(actor, mustUnderstand, digestValue, digestMethodAlgorithmNamespace);
    }

    public void marshall(SOAPElement soapheader, SOAPEnvelope envelope, ISOAPMessageContext context) {
        block2: {
            try {
                SOAPElement signatureNode = soapheader.addChildElement("Signature", "SOAP-SEC", "http://schemas.xmlsoap.org/soap/security/");
                signatureNode.addAttribute(envelope.createName("actor", "SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/"), super.getActor());
                signatureNode.addAttribute(envelope.createName("MustUnderstand", "SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/"), super.getMustUnderstand());
                this.mm_signedInfo.marshall(signatureNode, envelope, context);
                SOAPElement certNode = signatureNode.addChildElement("SignatureValue", null, "http://schemas.xmlsoap.org/soap/security/AttributeCert");
                certNode.addTextNode(new String(this.mm_signatureValue.encode()));
            }
            catch (SOAPException soapex) {
                SOAPLogger logger = SOAPLogger.getInstance();
                if (logger == null) break block2;
                logger.writeInfo(this, "marshall Method failed", (Exception)((Object)soapex));
            }
        }
    }

    public Base64 getSignatureValue() {
        return this.mm_signatureValue;
    }

    public String getId() {
        return this.mm_id;
    }

    public IPRTSOAPSignedInfo getSignedInfo() {
        return this.mm_signedInfo;
    }
}

