/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.security;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSecurity;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPAuthorization;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPEncryptionData;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPSecuredMessage;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPSignature;
import com.sapportals.portal.prt.service.soap.security.ISOAPSecurityManager;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPAuthorization;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPEncryptionData;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPSignature;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

public class PRTSOAPSecuredMessage
implements IPRTSOAPSecuredMessage {
    private SOAPMessage mm_message = null;
    private PRTSOAPAuthorization mm_authElement = null;
    private PRTSOAPEncryptionData mm_encryptElement = null;
    private PRTSOAPSignature mm_signElement = null;

    public PRTSOAPSecuredMessage() {
    }

    public PRTSOAPSecuredMessage(SOAPMessage message, ISOAPSecurityManager soapSecuManager, ISOAPMessageContext context) throws SOAPServiceException {
        this.mm_message = message;
        this.init(soapSecuManager, context);
    }

    private void init(ISOAPSecurityManager soapSecuManager, ISOAPMessageContext context) throws SOAPServiceException {
        try {
            SOAPHeader header = this.mm_message.getSOAPPart().getEnvelope().getHeader();
            SOAPEnvelope envelope = this.mm_message.getSOAPPart().getEnvelope();
            if (soapSecuManager.getEncryptDataEnable()) {
                this.mm_encryptElement = new PRTSOAPEncryptionData();
                this.mm_encryptElement.marshall((SOAPElement)header, envelope, context);
            }
            if (soapSecuManager.getSignatureEnable()) {
                this.mm_signElement = new PRTSOAPSignature("http://prt.webservice.security/soap/actor/signature", soapSecuManager.getMustUnderstand(), soapSecuManager.getDigestValue(), soapSecuManager.getDigestValue(), soapSecuManager.getDigestMethodAlgorithmNamespace(), "PRT Signature");
                this.mm_signElement.marshall((SOAPElement)header, envelope, context);
            }
            if (soapSecuManager.getAuthorizationEnable()) {
                this.mm_authElement = new PRTSOAPAuthorization("http://prt.webservice.security/soap/actor/authorization", soapSecuManager.getMustUnderstand(), soapSecuManager.getCertificate());
                this.mm_authElement.marshall((SOAPElement)header, envelope, context);
            }
        }
        catch (SOAPServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PRTFaultSecurity((Object)this, e);
        }
    }

    public SOAPMessage unmarshall(SOAPMessage soapSecuMsg, ISOAPSecurityManager soapSecuManager) throws SOAPServiceException {
        try {
            SOAPHeader header = soapSecuMsg.getSOAPPart().getEnvelope().getHeader();
            if (header != null) {
                PRTSOAPAuthorization autho;
                Iterator authElements;
                PRTSOAPSignature sign;
                Iterator signElements = header.extractHeaderElements("http://prt.webservice.security/soap/actor/signature");
                if (signElements.hasNext() && !soapSecuManager.verifySign((sign = new PRTSOAPSignature((SOAPElement)signElements.next())).getSignatureValue())) {
                    throw new PRTFaultSecurity("Signature no valid, the SOAP Message is ignored", (Object)this, null);
                }
                Iterator encryptElements = header.extractHeaderElements("http://prt.webservice.security/soap/actor/encryptdata");
                if (encryptElements.hasNext()) {
                    new PRTSOAPEncryptionData((SOAPElement)encryptElements.next());
                }
                if ((authElements = header.extractHeaderElements("http://prt.webservice.security/soap/actor/authorization")).hasNext() && !soapSecuManager.verifyCert((autho = new PRTSOAPAuthorization((SOAPElement)authElements.next())).getCertificate())) {
                    throw new PRTFaultSecurity("Certificat no valid, the SOAP Message is ignored", (Object)this, null);
                }
            }
            return soapSecuMsg;
        }
        catch (SOAPServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PRTFaultSecurity((Object)this, e);
        }
    }

    public SOAPMessage getPRTSOAPSecurisedMessage() {
        return this.mm_message;
    }

    public IPRTSOAPAuthorization getAuthElement() {
        return this.mm_authElement;
    }

    public IPRTSOAPEncryptionData getEncryptElement() {
        return this.mm_encryptElement;
    }

    public IPRTSOAPSignature getSignElement() {
        return this.mm_signElement;
    }
}

