/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.security;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.security.IPRTSOAPAuthorization;
import com.sapportals.portal.prt.service.soap.security.PRTSOAPSecurityElement;
import com.sapportals.portal.prt.service.soap.types.Base64;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class PRTSOAPAuthorization
extends PRTSOAPSecurityElement
implements IPRTSOAPAuthorization {
    private Base64 mm_certificate = null;

    public PRTSOAPAuthorization(SOAPElement autho) {
        Iterator iter1 = autho.getChildElements();
        while (iter1.hasNext()) {
            SOAPElement child = (SOAPElement)iter1.next();
            if (!child.getElementName().getLocalName().equals("AttributeCert")) continue;
            String valueCert = new String(new Base64(autho.getValue().getBytes()).decode());
            this.mm_certificate = new Base64(valueCert.getBytes());
        }
    }

    public PRTSOAPAuthorization(String actor, String mustUnderstand, Base64 certificate) {
        super(actor, mustUnderstand);
        this.mm_certificate = certificate;
    }

    public void marshall(SOAPElement soapheader, SOAPEnvelope envelope, ISOAPMessageContext context) {
        block2: {
            try {
                SOAPElement authorizationNode = soapheader.addChildElement("Authorization", "SOAP-SEC", "http://schemas.xmlsoap.org/soap/security/");
                authorizationNode.addAttribute(envelope.createName("actor", "SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/"), super.getActor());
                authorizationNode.addAttribute(envelope.createName("MustUnderstand", "SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/"), super.getMustUnderstand());
                SOAPElement certNode = authorizationNode.addChildElement("AttributeCert", null, "http://schemas.xmlsoap.org/soap/security/AttributeCert");
                certNode.addTextNode(new String(this.mm_certificate.encode()));
            }
            catch (SOAPException soapex) {
                SOAPLogger logger = SOAPLogger.getInstance();
                if (logger == null) break block2;
                logger.writeInfo(this, "marshall Method failed", (Exception)((Object)soapex));
            }
        }
    }

    public Base64 getCertificate() {
        return this.mm_certificate;
    }

    public void setCertificate(Base64 p_mm_certificate) {
        this.mm_certificate = p_mm_certificate;
    }
}

