/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.processor;

import com.sapportals.portal.prt.service.IService;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.processor.IMethodsAuthorizedProcessor;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class MethodsAuthorizedProcessor
implements IMethodsAuthorizedProcessor {
    private final String THROWS = " throws ";
    private final String SLASH = File.separator;
    private Properties mm_listMethods = null;
    private Vector mm_listAlreadyChecked = new Vector();
    private Vector mm_listMethodsXML = null;
    private boolean initOk = false;

    public MethodsAuthorizedProcessor(IService service, String serviceName) {
        this.initXML(service, serviceName);
        if (!this.initOk) {
            this.init(service);
        }
    }

    private void init(IService service) {
        IServiceContext context = service.getContext();
        String privatePathToService = context.getPrivateServicePath();
        String pathForProps = null;
        if (privatePathToService != null) {
            pathForProps = privatePathToService + this.SLASH + "soap" + this.SLASH + "methodsAuthorized.soap";
            Properties methods = new Properties();
            try {
                FileInputStream is = new FileInputStream(pathForProps);
                if (is != null) {
                    methods.load(is);
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e) {
                methods = null;
            }
            catch (IOException e) {
                methods = null;
            }
            if (methods != null) {
                this.mm_listMethods = methods;
            }
        }
    }

    private void initXML(IService service, String serviceName) {
        IPortalSOAPConfig config = SOAPRegistry.getInstance().getSpecializedRegistry(serviceName).getSOAPConfig();
        if (config != null) {
            IPortalWebService serviceconfig = config.getPortalWebService(serviceName);
            this.mm_listMethodsXML = serviceconfig.getPortalWebServiceMethods();
            this.initOk = true;
        }
    }

    public boolean isMethodAuthorized(String methodToCheck, IService service, String methodName, Class[] portalServiceParamsClass) {
        if (methodToCheck != null && this.mm_listAlreadyChecked.contains(methodToCheck)) {
            return true;
        }
        if (methodName == null) {
            return false;
        }
        if (this.mm_listMethods == null && this.mm_listMethodsXML == null) {
            return false;
        }
        try {
            Class<?>[] listInterface = service.getClass().getInterfaces();
            int i = 0;
            while (i < listInterface.length) {
                Object item;
                Enumeration<Object> enumeration;
                Class<?> interfaceService = listInterface[i];
                Method method = interfaceService.getMethod(methodName, portalServiceParamsClass);
                String methodS = method.toString();
                if (this.mm_listMethodsXML != null) {
                    enumeration = this.mm_listMethodsXML.elements();
                    while (enumeration.hasMoreElements()) {
                        item = (IPortalWebServiceMethod)enumeration.nextElement();
                        String methodBase = item.getJavaSignature();
                        if (!this.compareMethodsWithoutThrows(methodS, methodBase)) continue;
                        this.mm_listAlreadyChecked.add(methodToCheck);
                        return true;
                    }
                } else {
                    enumeration = ((Hashtable)this.mm_listMethods).elements();
                    while (enumeration.hasMoreElements()) {
                        item = (String)enumeration.nextElement();
                        if (!this.compareMethodsWithoutThrows(methodS, (String)item)) continue;
                        this.mm_listAlreadyChecked.add(methodToCheck);
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean compareMethodsWithoutThrows(String methodToCheck, String methodBase) {
        return this.cutsThrows(methodToCheck).equals(this.cutsThrows(methodBase));
    }

    private String cutsThrows(String aMethod) {
        int index = aMethod.indexOf(" throws ");
        if (index > -1) {
            return aMethod.substring(0, index);
        }
        return aMethod;
    }
}

