/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.log;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.soap.log.ISOAPLogger;
import com.sapportals.portal.prt.service.soap.util.ConfigSOAPService;
import com.sapportals.portal.prt.service.soap.util.IConfigurationSOAPService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;

public class SOAPLogger
implements ISOAPLogger {
    private static SOAPLogger mm_logger = null;
    private static IConfigurationSOAPService mm_config = null;
    private static ILogger mm_portallogger = null;
    private String mm_pathFile = null;
    public static final String LOGGERSTATUS = "LoggerStatus";

    private SOAPLogger() {
        mm_config = ConfigSOAPService.getInstance();
        if (mm_config != null) {
            mm_portallogger = PortalRuntime.getLogger((String)"SOAPLogger");
            this._isActive();
        }
    }

    private boolean _isActive() {
        try {
            return mm_config.readPropertieBoolean(LOGGERSTATUS);
        }
        catch (Exception propsex) {
            this.writeInfo((Object)this, "Error for read the value of the propertie LoggerStatus", propsex);
            return false;
        }
    }

    public static void destroy() {
        mm_logger = null;
        mm_config = null;
    }

    public boolean isActive() {
        return this._isActive();
    }

    public void activeLogger(boolean p) {
    }

    public static SOAPLogger getInstance() {
        if (mm_logger != null) {
            return mm_logger;
        }
        mm_logger = new SOAPLogger();
        return mm_logger;
    }

    public void writeInfo(Object actor, String message) {
        if (this._isActive() && mm_portallogger != null && mm_portallogger.isActive()) {
            if (actor != null) {
                mm_portallogger.info(actor, message);
            } else {
                mm_portallogger.info((Object)this, message);
            }
        }
    }

    public void writeInfo(Object actor, String message, Exception ex) {
        if (mm_portallogger != null && mm_portallogger.isActive()) {
            if (actor != null) {
                mm_portallogger.warning(actor, (Throwable)ex, message);
            } else {
                mm_portallogger.warning((Object)this, (Throwable)ex, message);
            }
        }
    }

    public void writeInfo(Object actor, String message, SOAPMessage soapmsg) {
        if (this._isActive() && mm_portallogger != null && mm_portallogger.isActive()) {
            try {
                ByteArrayOutputStream stringStream = new ByteArrayOutputStream();
                stringStream.write(message.getBytes());
                StringBuffer buffer = new StringBuffer();
                buffer.append("SOAP HEADERS:[");
                MimeHeaders headers = soapmsg.getMimeHeaders();
                Iterator iter = headers.getAllHeaders();
                while (iter.hasNext()) {
                    MimeHeader element = (MimeHeader)iter.next();
                    buffer.append(element.getName());
                    buffer.append('=');
                    buffer.append(element.getValue());
                    buffer.append(',');
                }
                buffer.append("]\r\n");
                stringStream.write(buffer.toString().getBytes());
                soapmsg.writeTo((OutputStream)stringStream);
                if (actor != null) {
                    mm_portallogger.info(actor, stringStream.toString());
                } else {
                    mm_portallogger.info((Object)this, stringStream.toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String getContentLog() {
        return "";
    }

    public void close() {
    }

    public String getPathFile() {
        return this.mm_pathFile;
    }
}

