/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.encoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.PRTSOAPElementFactory;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultDataEnconding;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.types.XMLData;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.wsdl.ITypes;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;

public class XMLDataSerializer
implements SOAPSerializer {
    static /* synthetic */ Class class$com$sapportals$portal$prt$service$soap$types$XMLData;

    public void marshall(String inScopeEncStyle, Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context) throws SOAPServiceException {
        if (XMLValueEncoder.testNillableInDocument((Object)objectToSerialize, (ISOAPMessageContext)context, (Class)elementType)) {
            return;
        }
        try {
            QName name = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getElementType(elementType).getQName();
            if (context.isDocumentStyleEncoding()) {
                if (objectToSerialize != null) {
                    if (nameParam.equals("any")) {
                        XMLData data = (XMLData)objectToSerialize;
                        if (data.isXMLHandlingOk()) {
                            data.insertContentInSOAPElement(parentElement, envelope);
                        } else {
                            parentElement.addTextNode(data.getRawContent());
                        }
                    } else {
                        this.encodeRPCStructure(elementType, envelope, parentElement, objectToSerialize, nameParam, context, name);
                    }
                }
            } else {
                this.encodeRPCStructure(elementType, envelope, parentElement, objectToSerialize, nameParam, context, name);
            }
        }
        catch (Exception ex) {
            throw new PRTFaultDataEnconding((Object)this, ex);
        }
    }

    private void encodeRPCStructure(Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context, QName name) throws SOAPServiceException, SOAPException {
        SOAPElement element = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)parentElement, (String)nameParam, (String)"xsi", (String)"type", (String)XMLValueEncoder.constructValueforType((String)name.getNamespaceURI(), (String)name.getLocalPart(), (ISOAPMessageContext)context), (Object)objectToSerialize, (ISOAPMessageContext)context);
        if (objectToSerialize == null) {
            if (XMLValueEncoder.isNullable((Class)elementType)) {
                XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)element, (ISOAPMessageContext)context);
            }
        } else if (PRTSOAPElementFactory.getInstance() != null) {
            SOAPElement content = PRTSOAPElementFactory.getInstance().createSOAPElement("content");
            content.addAttribute(envelope.createName("type", "xsi", "http://www.w3.org/2001/XMLSchema-instance"), "xsd:normalizedString");
            content.addTextNode(((XMLData)objectToSerialize).getContent().getContentNormalized());
            element.addChildElement(content);
        }
    }

    public boolean writeSchema(ITypes type) throws Exception {
        Element complexType = type.createElementNS("", "complexType");
        complexType.setAttribute("name", "XMLData");
        Element seq = type.createElementNS("", "sequence");
        complexType.appendChild(seq);
        Element element = type.createElementNS("", "element");
        element.setAttribute("name", "content");
        element.setAttribute("type", "xsd:normalizedString");
        seq.appendChild(element);
        String prefix = type.getPrefixForNameSpace(ISOAPParamConstants.mapQName.getNamespaceURI());
        prefix = prefix == null ? "" : prefix + ":";
        Element el = type.createElement("XMLData", prefix + "XMLData", XMLValueEncoder.isNullable((Class)(class$com$sapportals$portal$prt$service$soap$types$XMLData == null ? (class$com$sapportals$portal$prt$service$soap$types$XMLData = XMLDataSerializer.class$("com.sapportals.portal.prt.service.soap.types.XMLData")) : class$com$sapportals$portal$prt$service$soap$types$XMLData)), type.getDocFragment());
        type.writeSchemaElement(new QName("http://prt.java.soap/schemas", "XMLData"), el);
        el.getParentNode().appendChild(complexType);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

