/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.encoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultDataEnconding;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLValueEncoder;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceParameter;
import com.sapportals.portal.prt.service.soap.wsdl.ITypes;
import java.lang.reflect.Array;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class ArraySerializer
implements SOAPSerializer {
    private static final String ITEM_NAME = "item";
    private static final int UNRECOGNIZED_ARRAY = -1;
    private static final int ARRAY = 0;
    private static final int MATRIX = 1;
    private boolean isArrayOfArray;

    public void marshall(String inScopeEncStyle, Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context) {
        if (XMLValueEncoder.testNillableInDocument((Object)objectToSerialize, (ISOAPMessageContext)context, (Class)elementType)) {
            return;
        }
        String itemNameOfChildren = ITEM_NAME;
        itemNameOfChildren = this.initializeNameOfArrayItems(nameParam, context);
        ISpecializedRegistry reg = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName());
        if (reg == null) {
            throw new PRTFaultInternalError("The Specialized Registry is null for the service " + context.getServiceDescriptor().getServiceName() + "! ", (Object)this, new Exception("The Specialized Registry is null for the service!"));
        }
        QName nameArray = reg.getElementType(elementType, context.getEncodingStyle());
        if (nameArray == null) {
            nameArray = reg.getElementType(elementType).getQName();
        }
        int type = this.determineArrayType(objectToSerialize);
        Object item = null;
        Object ser = null;
        switch (type) {
            case -1: {
                throw new PRTFaultSerializator("Bad format for the Array to serialize ", (Object)this, new Exception("Bad format for the Array to serialize !"));
            }
            case 0: {
                this.marshallArray(inScopeEncStyle, elementType, envelope, parentElement, objectToSerialize, nameParam, context, reg, nameArray, itemNameOfChildren);
                break;
            }
            case 1: {
                this.marshallMatrix(elementType, envelope, parentElement, objectToSerialize, nameParam, context, nameArray, itemNameOfChildren);
            }
        }
    }

    private String initializeNameOfArrayItems(String nameParam, ISOAPMessageContext context) {
        String arrayNameFromContext = context.getArrayChildsName();
        if (arrayNameFromContext != null) {
            return arrayNameFromContext;
        }
        IPortalWebServiceMethod method = null;
        if (context.getMethodContainer() != null) {
            if (context.getMethodContainer().getWebserviceMethod_config() != null) {
                method = context.getMethodContainer().getWebserviceMethod_config();
            }
        } else if (context.getServiceDescriptor().getContextRequest() != null && context.getServiceDescriptor().getContextRequest().getMethodContainer() != null) {
            method = context.getServiceDescriptor().getContextRequest().getMethodContainer().getWebserviceMethod_config();
        }
        if (method != null) {
            IPortalWebServiceParameter param_config = null;
            if (context.isResponse()) {
                param_config = method.getReturnPortalWebServiceParameter();
                if (param_config.getNameElement() != null && !param_config.getNameElement().equals(nameParam)) {
                    param_config = null;
                }
            } else {
                param_config = method.foundParameter(nameParam);
            }
            if (param_config != null && param_config.getNameOfArrayItems() != null && param_config.getNameOfArrayItems().length() > 0) {
                return param_config.getNameOfArrayItems();
            }
        }
        return ITEM_NAME;
    }

    private void marshallArray(String inScopeEncStyle, Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context, ISpecializedRegistry reg, QName nameArray, String itemNameOfChildren) {
        Class<?> insideType = elementType.getComponentType();
        QName qnameInside = reg.getElementType(insideType).getQName();
        int lengthArray = 0;
        lengthArray = objectToSerialize == null ? 0 : Array.getLength(objectToSerialize);
        try {
            SOAPElement responseElement = context.isDocumentStyleEncoding() && context.isArrayList() ? parentElement : this.getSoapElementForArray(this.isArrayOfArray, envelope, parentElement, nameParam, context, nameArray, qnameInside, lengthArray, objectToSerialize, elementType);
            if (objectToSerialize == null) {
                if (XMLValueEncoder.isNullable((Class)elementType)) {
                    XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)responseElement, (ISOAPMessageContext)context);
                }
                return;
            }
            boolean arrayOfPrimitive = objectToSerialize.getClass().getComponentType().isPrimitive();
            this.marshallArrayParams(inScopeEncStyle, envelope, objectToSerialize, context, reg, insideType, lengthArray, responseElement, arrayOfPrimitive, itemNameOfChildren);
        }
        catch (PRTFault e) {
            throw e;
        }
        catch (SOAPServiceException sse) {
            throw new PRTFaultDataEnconding((Object)this, (Exception)((Object)sse));
        }
        catch (SOAPException se) {
            throw new PRTFaultDataEnconding((Object)this, (Exception)((Object)se));
        }
    }

    private void marshallMatrix(Class elementType, SOAPEnvelope envelope, SOAPElement parentElement, Object objectToSerialize, String nameParam, ISOAPMessageContext context, QName nameArray, String itemNameOfChildren) {
        Class<?> insideType = objectToSerialize.getClass().getComponentType().getComponentType();
        QName qnameInside = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName()).getElementType(insideType).getQName();
        try {
            int columns;
            int rows;
            if (objectToSerialize == null) {
                rows = 0;
                columns = 0;
            } else {
                rows = Array.getLength(objectToSerialize);
                columns = Array.getLength(Array.get(objectToSerialize, 0));
            }
            SOAPElement responseElement = this.getSoapElementForMatrix(envelope, parentElement, nameParam, context, nameArray, qnameInside, rows, columns, objectToSerialize, elementType);
            if (objectToSerialize == null) {
                if (XMLValueEncoder.isNullable((Class)elementType)) {
                    XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)responseElement, (ISOAPMessageContext)context);
                }
                return;
            }
            this.marshallMatrixParams(elementType, envelope, objectToSerialize, context, insideType, responseElement, rows, columns, itemNameOfChildren);
        }
        catch (PRTFault e) {
            throw e;
        }
        catch (SOAPServiceException sse) {
            throw new PRTFaultDataEnconding((Object)this, (Exception)((Object)sse));
        }
        catch (SOAPException se) {
            throw new PRTFaultDataEnconding((Object)this, (Exception)((Object)se));
        }
    }

    private void marshallMatrixParams(Class elementType, SOAPEnvelope envelope, Object objectToSerialize, ISOAPMessageContext context, Class insideType, SOAPElement responseElement, int rows, int columns, String itemNameOfChildren) throws SOAPException {
        ISpecializedRegistry registry = SOAPRegistry.getInstance().getSpecializedRegistry(context.getServiceDescriptor().getServiceName());
        int i = 0;
        while (i < rows) {
            Object subArray = Array.get(objectToSerialize, i);
            int j = 0;
            while (j < columns) {
                Object item = Array.get(subArray, j);
                boolean isItemPrimitive = Array.get(objectToSerialize, 0).getClass().getComponentType().isPrimitive();
                if (item == null) {
                    SOAPElement elementNull = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)responseElement, (String)itemNameOfChildren, (String)"xsi", (String)"type", null, null, (ISOAPMessageContext)context);
                    XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)elementNull, (ISOAPMessageContext)context);
                } else {
                    SOAPSerializer ser;
                    String targetnamespace = null;
                    targetnamespace = isItemPrimitive ? registry.getDefaultNamespace(ToolKit.returnPrimitive(item.getClass())) : registry.getDefaultNamespace(item.getClass());
                    if (!registry.isPrimitive((Class)insideType)) {
                        insideType = item.getClass();
                    }
                    if ((ser = registry.getSerializer(insideType, targetnamespace)) == null) {
                        throw new PRTFaultSerializator("The Serializer for " + insideType + " not found or not supported by the soap service!.", (Object)this, new Exception("The Serializer for " + insideType + " not found or not supported by the soap service!."));
                    }
                    ser.marshall(targetnamespace, insideType, envelope, responseElement, item, itemNameOfChildren, context);
                }
                ++j;
            }
            ++i;
        }
    }

    private void marshallArrayParams(String inScopeEncStyle, SOAPEnvelope envelope, Object objectToSerialize, ISOAPMessageContext context, ISpecializedRegistry reg, Class insideType, int lengthArray, SOAPElement responseElement, boolean arrayOfPrimitive, String itemNameOfChildren) throws SOAPException {
        boolean isArrayListBackup = context.isArrayList();
        String nameChildrenItemBackup = context.getArrayChildsName();
        int i = 0;
        while (i < lengthArray) {
            context.setArrayList(isArrayListBackup);
            context.setArrayChildsName(nameChildrenItemBackup);
            Object item = Array.get(objectToSerialize, i);
            context.setTargetNamespaceMethod(inScopeEncStyle);
            if (item == null) {
                SOAPElement elementNull = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)responseElement, (String)itemNameOfChildren, (String)"xsi", (String)"type", null, null, (ISOAPMessageContext)context);
                XMLValueEncoder.AddNullAttribute((SOAPEnvelope)envelope, (SOAPElement)elementNull, (ISOAPMessageContext)context);
            } else {
                SOAPSerializer ser;
                String targetnamespace = null;
                targetnamespace = arrayOfPrimitive ? reg.getDefaultNamespace(ToolKit.returnPrimitive(item.getClass())) : reg.getDefaultNamespace(item.getClass());
                if (!reg.isPrimitive((Class)insideType)) {
                    insideType = item.getClass();
                }
                if ((ser = reg.getSerializer(insideType, targetnamespace)) == null) {
                    throw new PRTFaultSerializator("The Serializer for " + insideType + " not found or not supported by the soap service!.", (Object)this, new Exception("The Serializer for " + insideType + " not found or not supported by the soap service!."));
                }
                ser.marshall(targetnamespace, insideType, envelope, responseElement, item, itemNameOfChildren, context);
            }
            ++i;
        }
    }

    private SOAPElement getSoapElementForMatrix(SOAPEnvelope envelope, SOAPElement parentElement, String nameParam, ISOAPMessageContext context, QName nameArray, QName qnameInside, int rows, int columns, Object objectToSer, Class elementType) throws SOAPException {
        SOAPElement responseElement = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)parentElement, (String)nameParam, (String)context.getPrefixForNamespace(nameArray.getNamespaceURI()), (String)"arrayType", (String)XMLValueEncoder.contructValueForArray((String)qnameInside.getNamespaceURI(), (String)qnameInside.getLocalPart(), (int)rows, (int)columns, (ISOAPMessageContext)context), null, (ISOAPMessageContext)context);
        if (!context.isLitteralStyleEncoding()) {
            responseElement.addAttribute(envelope.createName("type", context.getPrefixForNamespace(nameArray.getNamespaceURI()), nameArray.getNamespaceURI()), XMLValueEncoder.constructValueforType((String)ISOAPParamConstants.SOAP_ARRAY.getNamespaceURI(), (String)nameArray.getLocalPart(), (ISOAPMessageContext)context));
        }
        return responseElement;
    }

    private SOAPElement getSoapElementForArray(boolean isArrayOfArray, SOAPEnvelope envelope, SOAPElement parentElement, String nameParam, ISOAPMessageContext context, QName nameArray, QName qnameInside, int lengthArray, Object objectToSer, Class elementType) throws SOAPException {
        String valueForArray = null;
        valueForArray = isArrayOfArray ? XMLValueEncoder.constructValueForArrayOfArray((String)qnameInside.getNamespaceURI(), (String)qnameInside.getLocalPart(), (int)lengthArray, (ISOAPMessageContext)context) : XMLValueEncoder.contructValueForArray((String)qnameInside.getNamespaceURI(), (String)qnameInside.getLocalPart(), (int)lengthArray, (ISOAPMessageContext)context);
        SOAPElement res = XMLValueEncoder.addSOAPElement((SOAPEnvelope)envelope, (SOAPElement)parentElement, (String)nameParam, (String)context.getPrefixForNamespace(nameArray.getNamespaceURI()), (String)"arrayType", (String)valueForArray, null, (ISOAPMessageContext)context);
        if (!context.isLitteralStyleEncoding()) {
            res.addAttribute(envelope.createName("type", context.getPrefixForNamespace(nameArray.getNamespaceURI()), nameArray.getNamespaceURI()), XMLValueEncoder.constructValueforType((String)ISOAPParamConstants.SOAP_ARRAY.getNamespaceURI(), (String)nameArray.getLocalPart(), (ISOAPMessageContext)context));
        }
        return res;
    }

    public boolean writeSchema(ITypes type) throws Exception {
        return true;
    }

    private int determineArrayType(Object obj) {
        if (obj == null) {
            this.isArrayOfArray = false;
            return 0;
        }
        if (obj.getClass().getName().startsWith("[[")) {
            return 1;
        }
        if (obj.getClass().getName().startsWith("[")) {
            this.isArrayOfArray = this.determineType(obj);
            return 0;
        }
        return -1;
    }

    private boolean determineType(Object obj) {
        int i = 0;
        boolean elementIsArray = false;
        while (i < Array.getLength(obj)) {
            if (Array.get(obj, i) != null) {
                elementIsArray = Array.get(obj, i).getClass().isArray();
            }
            if (!elementIsArray) break;
            ++i;
        }
        return elementIsArray;
    }
}

