/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.element;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.IServiceDescriptor;
import com.sapportals.portal.prt.service.soap.SOAPMessageContext;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPEnvelope;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPHeader;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPEnvelope;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPHeader;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.util.CookiesUtils;
import com.sapportals.portal.prt.service.soap.util.IMessageDescriptor;
import javax.servlet.http.Cookie;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class PRTSOAPMessage
implements IPRTSOAPMessage {
    SOAPMessage mm_soapMessage = null;
    PRTSOAPEnvelope mm_soapEnvelope = null;
    PRTSOAPHeader mm_soapHeader = null;
    private Cookie[] mm_cookies = null;
    private boolean mm_isResponse = false;
    boolean mm_processed = false;
    SOAPMessageContext mm_context = null;

    public PRTSOAPMessage(SOAPMessage aMessage, IServiceDescriptor descriptor, boolean isResponse, boolean style_document, String datastyle_literal, String soapaction) throws SOAPException {
        this.mm_soapMessage = aMessage;
        this.mm_cookies = CookiesUtils.extractCookiesFromMimeHeaders(this.mm_soapMessage.getMimeHeaders());
        this.mm_isResponse = isResponse;
        this.processSOAPMessage(descriptor, style_document, datastyle_literal, soapaction);
    }

    public PRTSOAPMessage(IMessageDescriptor descriptor, IServiceDescriptor serviceDescriptor) {
        this.mm_soapEnvelope = new PRTSOAPEnvelope(descriptor, serviceDescriptor);
    }

    public IPRTSOAPEnvelope getEnveloppe() {
        return this.mm_soapEnvelope;
    }

    private void processSOAPMessage(IServiceDescriptor descriptor, boolean style_document, String datastyle_literal, String soapaction) throws SOAPException {
        SOAPPart sp = this.mm_soapMessage.getSOAPPart();
        SOAPEnvelope env = sp.getEnvelope();
        this.mm_soapEnvelope = new PRTSOAPEnvelope(env, descriptor, this.mm_isResponse, style_document, datastyle_literal, soapaction);
        this.mm_processed = true;
    }

    public void marshall(SOAPPart soapPart) throws SOAPServiceException {
        try {
            SOAPEnvelope envelope = soapPart.getEnvelope();
            this.mm_soapEnvelope.marshall(envelope);
        }
        catch (SOAPServiceException ex) {
            throw ex;
        }
        catch (SOAPException e) {
            throw new PRTFaultSerializator((Object)this, (Exception)((Object)e));
        }
    }

    public SOAPMessage getSoapMessage() {
        return this.mm_soapMessage;
    }

    public IPRTSOAPHeader getPRTSoapHeader() {
        return this.mm_soapHeader;
    }

    public ISOAPMessageContext getMessageContext() {
        return this.mm_context;
    }

    public void addCookies(Cookie[] cookies) {
        this.mm_cookies = cookies;
    }

    public Cookie[] getCookies() {
        return this.mm_cookies;
    }
}

