/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.element;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.PRTSOAPElementFactory;
import com.sapportals.portal.prt.service.soap.ParamsProcessor;
import com.sapportals.portal.prt.service.soap.SOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPHeaderElement;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import com.sapportals.portal.prt.service.soap.util.XMLAttributeHandler;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.Text;

public class PRTSOAPHeaderElement
implements IPRTSOAPHeaderElement {
    SOAPHeaderElement mm_headerElement = null;
    ISOAPMessageContext mm_context = null;
    ISOAPMessageContext mm_context_params = null;
    String mm_nameElement = null;
    String mm_namespaceURI = null;
    XMLAttributeHandler mm_attributeHandler = null;
    static /* synthetic */ Class class$javax$xml$soap$Text;

    public PRTSOAPHeaderElement(SOAPHeaderElement headerElement, ISOAPMessageContext parentContext) {
        this.mm_headerElement = headerElement;
        this.processHeaderElement(parentContext);
    }

    private void processHeaderElement(ISOAPMessageContext parentContext) {
        this.mm_context = new SOAPMessageContext((SOAPElement)this.mm_headerElement, parentContext);
        Name headerElementName = this.mm_headerElement.getElementName();
        this.mm_nameElement = headerElementName.getLocalName();
        this.mm_namespaceURI = headerElementName.getURI();
        try {
            Iterator itlevel1 = this.mm_headerElement.getChildElements();
            this.mm_context_params = new SOAPMessageContext(this.mm_context);
            int countElement = 0;
            while (itlevel1.hasNext()) {
                Object el = itlevel1.next();
                SOAPElement level1Element = null;
                if ((class$javax$xml$soap$Text == null ? PRTSOAPHeaderElement.class$("javax.xml.soap.Text") : class$javax$xml$soap$Text).isAssignableFrom(el.getClass())) {
                    if (PRTSOAPElementFactory.getInstance() != null) {
                        level1Element = this.convertTextElement((Text)el, "param" + countElement);
                    }
                } else {
                    level1Element = (SOAPElement)el;
                }
                Name namelevel1 = level1Element.getElementName();
                this.processParams(level1Element, namelevel1);
                ++countElement;
            }
        }
        catch (Exception ex) {
            throw new PRTFaultSerializator((Object)this, ex);
        }
    }

    private SOAPElement convertTextElement(Text textElement, String nameParam) {
        SOAPElement element = textElement.getParentElement();
        SOAPElement newElement = null;
        try {
            newElement = PRTSOAPElementFactory.getInstance().createSOAPElement(nameParam);
            Iterator iter = element.getAllAttributes();
            while (iter.hasNext()) {
                Name name = (Name)iter.next();
                if (!name.getLocalName().equals("type")) continue;
                newElement.addAttribute(name, element.getAttributeValue(name));
            }
            newElement.addTextNode(textElement.getValue());
        }
        catch (SOAPException soapex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "convertTextElement Method failed", (Exception)((Object)soapex));
            }
            return null;
        }
        return newElement;
    }

    public String getName() {
        return this.mm_nameElement;
    }

    public String getNamespaceURI() {
        return this.mm_namespaceURI;
    }

    public boolean processParams(SOAPElement element, Name nameElement) {
        this.mm_context_params.addNamespaceElementInContext(element);
        QNameURI qName = XMLValueExtractor.getQNameURIForElement((SOAPElement)element, (ISOAPMessageContext)this.mm_context_params);
        if (qName == null) {
            qName = new QNameURI(ISOAPParamConstants.string2001QName, "http://www.w3.org/2001/XMLSchema");
        }
        SOAPParameter parameter = ParamsProcessor.getInstance().getSOAPParameter(element, qName, this.mm_context_params);
        this.addAttribute(nameElement.getLocalName(), parameter);
        return true;
    }

    public void addAttribute(String attributeName, SOAPParameter param) {
        if (this.mm_attributeHandler == null) {
            this.mm_attributeHandler = new XMLAttributeHandler();
        }
        this.mm_attributeHandler.addAttribute(attributeName, param);
    }

    public XMLAttributeHandler getAttributeHandler() {
        return this.mm_attributeHandler;
    }

    public void setResponse(Object object, Class typeResponse) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

