/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.element;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.IServiceDescriptor;
import com.sapportals.portal.prt.service.soap.SOAPMessageContext;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBody;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPEnvelope;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPHeader;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPBody;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPHeader;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultEnvelopeVersion;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.processor.MethodContainer;
import com.sapportals.portal.prt.service.soap.util.IMessageDescriptor;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;

public class PRTSOAPEnvelope
implements IPRTSOAPEnvelope {
    private SOAPMessageContext mm_context = null;
    private SOAPEnvelope mm_soapEnvelope = null;
    private PRTSOAPBody mm_body = null;
    private PRTSOAPHeader mm_header = null;
    private boolean mm_isResponse = false;
    private String mm_soapaction = null;
    private String mm_specificNamespaceURI = null;
    public static Name xsiType = null;
    public boolean mm_style_document = false;
    public String mm_datastyle_literal = null;

    public PRTSOAPEnvelope(SOAPEnvelope env, IServiceDescriptor descriptor, boolean isResponse) {
        this(env, descriptor, isResponse, false, null, null);
    }

    public PRTSOAPEnvelope(SOAPEnvelope env, IServiceDescriptor descriptor, boolean isResponse, boolean style_document, String datastyle_literal, String soapaction) {
        this.mm_soapEnvelope = env;
        this.mm_isResponse = isResponse;
        this.mm_soapaction = soapaction;
        this.mm_style_document = style_document;
        this.mm_datastyle_literal = datastyle_literal;
        this.init(descriptor);
    }

    public PRTSOAPEnvelope(IMessageDescriptor descriptor, IServiceDescriptor serviceDescriptor) {
        this.mm_context = new SOAPMessageContext(descriptor.getNamespaceURI(), serviceDescriptor);
        serviceDescriptor.setContextRequest((ISOAPMessageContext)this.mm_context);
        MethodContainer container = new MethodContainer();
        container.setWebserviceMethod_config(descriptor.getConfigMethod());
        this.mm_context.setMethodContainer(container);
        PRTFault.initializePRTFaultContextClientSide((ISOAPMessageContext)this.mm_context);
        this.mm_body = new PRTSOAPBody(descriptor, this.mm_context);
    }

    public ISOAPMessageContext getMainContext() {
        return this.mm_context;
    }

    private void init(IServiceDescriptor descriptor) throws SOAPServiceException {
        try {
            this.mm_context = new SOAPMessageContext((SOAPElement)this.mm_soapEnvelope, descriptor);
            this.mm_context.setSOAPAction(this.mm_soapaction);
            this.mm_context.setDocumentStyle(this.mm_style_document);
            this.mm_context.setdataStyleEncodingAsked(this.mm_datastyle_literal);
            if (!this.mm_isResponse) {
                descriptor.setContextRequest((ISOAPMessageContext)this.mm_context);
            }
            this.mm_context.setResponse(this.mm_isResponse);
            PRTFault.initializePRTFaultContextServerSide((ISOAPMessageContext)this.mm_context, (SOAPEnvelope)this.mm_soapEnvelope);
            SOAPHeader header = this.mm_soapEnvelope.getHeader();
            if (header != null) {
                this.mm_header = new PRTSOAPHeader(header, this.mm_context);
            }
            SOAPBody body = this.mm_soapEnvelope.getBody();
            this.mm_body = new PRTSOAPBody(this, body);
        }
        catch (SOAPServiceException e) {
            throw e;
        }
        catch (SOAPException e) {
            throw new PRTFaultEnvelopeVersion((Object)this, (Exception)((Object)e));
        }
    }

    public IPRTSOAPBody getBody() {
        return this.mm_body;
    }

    public IPRTSOAPHeader getHeader() {
        return this.mm_header;
    }

    public String getMainNamespaceURI() {
        return this.mm_specificNamespaceURI;
    }

    public SOAPEnvelope getEnvelope() {
        return this.mm_soapEnvelope;
    }

    public void marshall(SOAPEnvelope envelope) throws SOAPServiceException {
        try {
            this.mm_context.addNamespaceDeclarationInElement((SOAPElement)envelope);
            if (!this.mm_context.isDocumentStyleEncoding() && this.mm_context.getEncodingStyleNotDelegate() != null) {
                envelope.setEncodingStyle(this.mm_context.getEncodingStyleNotDelegate());
            }
            this.mm_body.marshall(envelope);
        }
        catch (SOAPServiceException ex) {
            throw ex;
        }
        catch (SOAPException e) {
            throw new PRTFaultSerializator((Object)this, (Exception)((Object)e));
        }
    }

    public String getSOAPAction() {
        return this.mm_soapaction;
    }
}

