/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.element;

import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.ParamsProcessor;
import com.sapportals.portal.prt.service.soap.SOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBodyElement;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultEnvelopeVersion;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.processor.InvokerProcessor;
import com.sapportals.portal.prt.service.soap.processor.MethodContainer;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLAttributeHandler;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceParameter;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceType;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class PRTSOAPBodyElement
implements IPRTSOAPBodyElement {
    ISOAPMessageContext mm_context = null;
    ISOAPMessageContext mm_context_params = null;
    SOAPBodyElement mm_bodyElement = null;
    String mm_namespaceURI = null;
    String mm_nameElement = null;
    XMLAttributeHandler mm_attributeHandler = null;
    XMLAttributeHandler mm_listParams = new XMLAttributeHandler();
    boolean isResponse = false;

    public PRTSOAPBodyElement(SOAPBodyElement bodyElement, ISOAPMessageContext context) throws SOAPServiceException {
        this.mm_context = new SOAPMessageContext((SOAPElement)bodyElement, context);
        this.mm_bodyElement = bodyElement;
        this.init();
    }

    public PRTSOAPBodyElement(ISOAPMessageContext context, String namespaceURI, String name, XMLAttributeHandler params) {
        this.mm_context = new SOAPMessageContext(namespaceURI, context);
        this.mm_nameElement = name;
        this.mm_namespaceURI = namespaceURI;
        this.mm_listParams = params;
        this.determineSOAPStyleEncoding((SOAPMessageContext)context);
    }

    public PRTSOAPBodyElement(ISOAPMessageContext context) {
        this.mm_context = context;
    }

    private void determineSOAPStyleEncoding(SOAPMessageContext context) {
        if (context != null) {
            try {
                if (context.isDocumentStyleEncoding()) {
                    return;
                }
                String name_service = this.mm_context.getServiceDescriptor().getServiceName();
                MethodContainer webservice_method = InvokerProcessor.getInstance().extractMethodFromXML(name_service, PortalRuntime.getRuntimeResources().getService(name_service), this.mm_nameElement, this.mm_listParams);
                if (webservice_method == null) {
                    context.setDocumentStyle(false);
                }
                if (webservice_method.getWebserviceMethod_config().getStyleEnconding() == 1) {
                    context.setDocumentStyle(true);
                } else {
                    context.setDocumentStyle(false);
                }
            }
            catch (Exception e) {
                context.setDocumentStyle(false);
            }
        }
    }

    private void determineDataStyleEncoding(SOAPMessageContext context, int ID2) {
        if (context != null) {
            try {
                IPortalWebServiceParameter param_config;
                if (context.isLitteralStyleEncodingAsked() != null && context.isLitteralStyleEncodingAsked().equals("true")) {
                    context.setLitteralStyle(true);
                    return;
                }
                if (context.isLitteralStyleEncodingAsked() != null && context.isLitteralStyleEncodingAsked().equals("false")) {
                    context.setLitteralStyle(false);
                    return;
                }
                String name_service = this.mm_context.getServiceDescriptor().getServiceName();
                MethodContainer webservice_method = context.getMethodContainer();
                if (webservice_method == null) {
                    webservice_method = InvokerProcessor.getInstance().extractMethodFromXML(name_service, PortalRuntime.getRuntimeResources().getService(name_service), this.mm_nameElement, this.mm_listParams);
                }
                if (webservice_method == null) {
                    context.setLitteralStyle(false);
                }
                if ((param_config = webservice_method.getWebserviceMethod_config().getPortalWebServiceParameter(ID2)) != null) {
                    if (param_config.getEnconding().equalsIgnoreCase("literal")) {
                        context.setLitteralStyle(true);
                    } else {
                        context.setLitteralStyle(false);
                    }
                } else {
                    context.setLitteralStyle(false);
                }
            }
            catch (Exception e) {
                context.setLitteralStyle(false);
            }
        }
    }

    public String getName() {
        return this.mm_nameElement;
    }

    public String getNamespaceURI() {
        return this.mm_namespaceURI;
    }

    /*
     * Unable to fully structure code
     */
    private void init() throws SOAPServiceException {
        block4: {
            serviceName = this.mm_bodyElement.getElementName();
            this.mm_nameElement = serviceName.getLocalName();
            this.mm_namespaceURI = serviceName.getURI();
            itlevel1 = this.mm_bodyElement.getChildElements();
            this.mm_context_params = new SOAPMessageContext(this.mm_context);
            if (!this.mm_context_params.isDocumentStyleEncoding()) ** GOTO lbl24
            itlevel1 = this.mm_bodyElement.getParentElement().getChildElements();
            while (itlevel1.hasNext()) {
                obj = itlevel1.next();
                if (!(obj instanceof SOAPElement)) continue;
                level1Element = (SOAPElement)obj;
                namelevel1 = level1Element.getElementName();
                this.processParams(level1Element, namelevel1);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                obj = itlevel1.next();
                if (!(obj instanceof SOAPElement)) continue;
                level1Element = (SOAPElement)obj;
                namelevel1 = level1Element.getElementName();
                this.processParams(level1Element, namelevel1);
lbl24:
                // 3 sources

                ** while (itlevel1.hasNext())
            }
lbl25:
            // 1 sources

        }
    }

    public boolean processParams(SOAPElement elementOriginal_, Name nameElement) {
        SOAPElement elementOriginal = null;
        elementOriginal = elementOriginal_;
        SOAPElement element = XMLValueExtractor.getSOAPElementFromRef((SOAPElement)elementOriginal, (ISOAPMessageContext)this.mm_context_params);
        this.mm_context_params.addNamespaceElementInContext(element);
        QNameURI qName = XMLValueExtractor.getQNameURIForElement((SOAPElement)element, (ISOAPMessageContext)this.mm_context_params);
        String serviceName = this.mm_context.getServiceDescriptor().getServiceName();
        IPortalSOAPConfig config = SOAPRegistry.getInstance().getSpecializedRegistry(serviceName).getSOAPConfig();
        IPortalWebServiceMethod method_config = null;
        if (qName == null && this.mm_context_params.isDocumentStyleEncoding()) {
            IPortalWebServiceMethod method;
            block66: {
                IPortalWebService service = config.getPortalWebService(serviceName);
                String soapaction = this.mm_context_params.getSOAPAction();
                if (soapaction == null) {
                    throw new PRTFaultEnvelopeVersion((Object)this, (Exception)new IllegalArgumentException("No SOAP Action include in the soap request."));
                }
                Vector listMethod = service.getPortalWebServiceMethodBySOAPAction(soapaction);
                if (listMethod == null || listMethod.size() == 0) {
                    throw new PRTFaultEnvelopeVersion((Object)this, (Exception)new IllegalArgumentException("The SOAP Action " + soapaction + " include in the soap request not corresponding to the Portal service method."));
                }
                method = null;
                if (listMethod.size() == 1) {
                    method = (IPortalWebServiceMethod)listMethod.get(0);
                } else {
                    if (this.mm_context_params.getServiceDescriptor() != null) {
                        try {
                            if (this.mm_context_params.getServiceDescriptor().getContextRequest().getMethodContainer().getWebserviceMethod_config() != null) {
                                method = this.mm_context_params.getServiceDescriptor().getContextRequest().getMethodContainer().getWebserviceMethod_config();
                            } else {
                                method = ToolKit.findDocumentMethodByParameters(listMethod, nameElement.getLocalName());
                                if (method == null) {
                                    throw new PRTFaultSerializator("Method with name " + this.getName() + " has an ambiguous method signature and its SOAP config is null", (Object)this, (Exception)new NoSuchMethodException());
                                }
                            }
                            break block66;
                        }
                        catch (Exception e1) {
                            method = ToolKit.findDocumentMethodByParameters(listMethod, nameElement.getLocalName());
                            if (method == null) {
                                throw new PRTFaultSerializator("Method with name " + this.getName() + " has an ambiguous method signature", (Object)this, (Exception)new NoSuchMethodException());
                            }
                            break block66;
                        }
                    }
                    method = ToolKit.findDocumentMethodByParameters(listMethod, nameElement.getLocalName());
                    if (method == null) {
                        throw new PRTFaultSerializator("Method with name " + this.getName() + " has an ambiguous method signature and ServiceDescriptor attached to the current context is null", (Object)this, (Exception)new NoSuchMethodException());
                    }
                }
            }
            String nparam = nameElement.getLocalName();
            IPortalWebServiceParameter param_config = null;
            if (this.mm_context_params.isResponse()) {
                param_config = method.getReturnPortalWebServiceParameter();
                if (!param_config.getNameElement().equals(nparam)) {
                    param_config = null;
                }
            } else {
                param_config = method.foundParameter(nparam);
            }
            if (param_config == null) {
                throw new PRTFaultInternalError((Object)this, (Exception)new IllegalArgumentException("The parameter " + nparam + " not found in the soapconfig.xml in Document mode."));
            }
            IPortalWebServiceType type_config = (IPortalWebServiceType)param_config.getPortalWebServiceTypes().next();
            String elementType = type_config.getWSDLType();
            QName nameQ = null;
            try {
                nameQ = XMLValueExtractor.getQNameForAttributeValue((String)elementType, (ISOAPMessageContext)this.mm_context);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            if (nameQ == null) {
                String _localpart = elementType;
                if (_localpart.indexOf(":") != -1) {
                    _localpart = _localpart.substring(_localpart.indexOf(":") + 1, _localpart.length());
                }
                nameQ = new QName(param_config.getTargetNamespace(), _localpart);
            }
            qName = new QNameURI(nameQ, nameQ.getNamespaceURI());
            if (type_config.getJavaType().indexOf("[") != -1) {
                qName = new QNameURI(ISOAPParamConstants.SOAP_ARRAY, "http://schemas.xmlsoap.org/soap/encoding/");
            }
            this.constructSOAPParam(nameElement, element, qName, method);
            return true;
        }
        if (!this.mm_context.isResponse()) {
            if (qName == null) {
                if (config != null) {
                    IPortalWebService service = config.getPortalWebService(serviceName);
                    Vector listMethod = service.getPortalWebServiceMethod(this.getName());
                    if (listMethod == null) {
                        throw new PRTFaultSerializator("Method with name " + this.getName() + " is not defined in wsdl file", (Object)this, (Exception)new NoSuchMethodException("Method with name " + this.getName() + " is not defined in wsdl file"));
                    }
                    Enumeration enumeration = listMethod.elements();
                    while (enumeration.hasMoreElements()) {
                        IPortalWebServiceMethod elem = (IPortalWebServiceMethod)enumeration.nextElement();
                        if (elem.getNumberOfParameters() == 0) {
                            throw new PRTFaultSerializator("Method with name " + this.getName() + " have no input parameters defined in wsdl file", (Object)this, (Exception)new NoSuchMethodException("Method with name " + this.getName() + " have no input parameters defined in wsdl file"));
                        }
                        Enumeration listParam = elem.getPortalWebServiceParameters();
                        while (listParam.hasMoreElements()) {
                            String paramNameForMessage;
                            IPortalWebServiceParameter param = (IPortalWebServiceParameter)listParam.nextElement();
                            String paramName = param.getName();
                            if (!paramName.equals(paramNameForMessage = nameElement.getLocalName())) continue;
                            Iterator iter = param.getPortalWebServiceTypes();
                            while (iter.hasNext()) {
                                IPortalWebServiceType elementS = (IPortalWebServiceType)iter.next();
                                String elementType = elementS.getWSDLType();
                                QName nameQ = null;
                                try {
                                    nameQ = XMLValueExtractor.getQNameForAttributeValue((String)elementType, (ISOAPMessageContext)this.mm_context);
                                }
                                catch (IllegalStateException e) {
                                    // empty catch block
                                }
                                if (nameQ == null) {
                                    nameQ = XMLValueExtractor.getQNameForAttributeValueFromConfig((String)elementType, (String)param.getTargetNamespace());
                                }
                                if (nameQ == null) {
                                    throw new PRTFaultSerializator("Param with name " + paramNameForMessage + " for method " + this.getName() + " is not defined in wsdl file", (Object)this, (Exception)new NoSuchMethodException("Param with name " + paramNameForMessage + " for method " + this.getName() + " is not defined in wsdl file"));
                                }
                                qName = new QNameURI(nameQ, "http://schemas.xmlsoap.org/soap/encoding/");
                                if (elementS.getJavaType().indexOf("[") == -1) continue;
                                qName = new QNameURI(ISOAPParamConstants.SOAP_ARRAY, "http://schemas.xmlsoap.org/soap/encoding/");
                            }
                            break block9;
                        }
                        if (qName == null) continue;
                        method_config = elem;
                        break;
                    }
                } else {
                    qName = new QNameURI(ISOAPParamConstants.string2001QName, "http://www.w3.org/2001/XMLSchema");
                }
            } else if (XMLValueExtractor.isValueNull((SOAPElement)element) && config != null) {
                IPortalWebService service = config.getPortalWebService(serviceName);
                Vector listMethod = service.getPortalWebServiceMethod(this.getName());
                if (listMethod == null) {
                    throw new PRTFaultSerializator("Method with name " + this.getName() + " is not defined in wsdl file", (Object)this, (Exception)new NoSuchMethodException());
                }
                Enumeration enumeration = listMethod.elements();
                block11: while (enumeration.hasMoreElements()) {
                    IPortalWebServiceMethod elem = (IPortalWebServiceMethod)enumeration.nextElement();
                    Enumeration listParam = elem.getPortalWebServiceParameters();
                    while (listParam.hasMoreElements()) {
                        String paramNameForMessage;
                        IPortalWebServiceParameter param = (IPortalWebServiceParameter)listParam.nextElement();
                        String paramName = param.getName();
                        if (!paramName.equals(paramNameForMessage = nameElement.getLocalName())) continue;
                        if (!param.isNillable()) {
                            throw new PRTFaultSerializator("Attributes with name " + paramNameForMessage + " can not be null following wsdl definition", (Object)this, (Exception)new IllegalArgumentException());
                        }
                        method_config = elem;
                        continue block11;
                    }
                }
            }
        } else if (qName == null) {
            if (config != null) {
                IPortalWebService service = config.getPortalWebService(serviceName);
                String trueMethodName = this.getName();
                int lastIndex = trueMethodName.lastIndexOf("Response");
                if (lastIndex > -1) {
                    trueMethodName = trueMethodName.substring(0, lastIndex);
                }
                Vector listMethod = null;
                if (this.mm_context_params.getSOAPAction() != null && this.mm_context_params.getSOAPAction().length() > 0) {
                    listMethod = service.getPortalWebServiceMethodBySOAPAction(this.mm_context_params.getSOAPAction());
                    if (listMethod == null || listMethod.size() == 0) {
                        listMethod = service.getPortalWebServiceMethod(trueMethodName);
                    }
                } else {
                    listMethod = service.getPortalWebServiceMethod(trueMethodName);
                }
                if (listMethod == null) {
                    throw new PRTFaultSerializator("Method with name " + trueMethodName + " is not defined in wsdl file", (Object)this, (Exception)new NoSuchMethodException());
                }
                Enumeration enumeration = listMethod.elements();
                while (enumeration.hasMoreElements()) {
                    String paramNameForMessage;
                    IPortalWebServiceMethod elem = (IPortalWebServiceMethod)enumeration.nextElement();
                    IPortalWebServiceParameter param = elem.getReturnPortalWebServiceParameter();
                    String paramName = param.getName();
                    if (paramName.equals(paramNameForMessage = nameElement.getLocalName())) {
                        Iterator iter = param.getPortalWebServiceTypes();
                        if (iter.hasNext()) {
                            IPortalWebServiceType elementS = (IPortalWebServiceType)iter.next();
                            String elementType = elementS.getWSDLType();
                            QName nameQ = null;
                            try {
                                nameQ = XMLValueExtractor.getQNameForAttributeValue((String)elementType, (ISOAPMessageContext)this.mm_context);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            if (nameQ == null) {
                                nameQ = XMLValueExtractor.getQNameForAttributeValueFromConfig((String)elementType, (String)param.getTargetNamespace());
                            }
                            if (nameQ == null) {
                                throw new PRTFaultSerializator("Param with name " + paramNameForMessage + " for method " + trueMethodName + " is not defined in wsdl file", (Object)this, (Exception)new NoSuchMethodException());
                            }
                            qName = new QNameURI(nameQ, "http://schemas.xmlsoap.org/soap/encoding/");
                            if (elementS.getJavaType().indexOf("[") != -1) {
                                qName = new QNameURI(ISOAPParamConstants.SOAP_ARRAY, "http://schemas.xmlsoap.org/soap/encoding/");
                            }
                            if (qName != null) {
                                method_config = elem;
                            }
                            if (this.mm_context_params.getMethodContainer() == null) {
                                this.mm_context_params.setMethodContainer(this.createMethodContainer(method_config));
                            }
                            SOAPParameter parameter = ParamsProcessor.getInstance().getSOAPParameter(element, qName, this.mm_context_params);
                            this.addAttribute(nameElement.getLocalName(), parameter);
                            return true;
                        }
                    }
                    if (qName == null) continue;
                    method_config = elem;
                    break;
                }
            } else {
                qName = new QNameURI(ISOAPParamConstants.string2001QName, "http://www.w3.org/2001/XMLSchema");
            }
        } else if (XMLValueExtractor.isValueNull((SOAPElement)element) && config != null) {
            Vector listMethod;
            IPortalWebService service = config.getPortalWebService(serviceName);
            String trueMethodName = this.getName();
            int lastIndex = trueMethodName.lastIndexOf("Response");
            if (lastIndex > -1) {
                trueMethodName = trueMethodName.substring(0, lastIndex);
            }
            if ((listMethod = service.getPortalWebServiceMethod(trueMethodName)) == null) {
                throw new PRTFaultSerializator("Method with name " + trueMethodName + " is not defined in wsdl file", (Object)this, (Exception)new NoSuchMethodException());
            }
            Enumeration enumeration = listMethod.elements();
            while (enumeration.hasMoreElements()) {
                String paramNameForMessage;
                IPortalWebServiceMethod elem = (IPortalWebServiceMethod)enumeration.nextElement();
                IPortalWebServiceParameter param = elem.getReturnPortalWebServiceParameter();
                String paramName = param.getName();
                if (!paramName.equals(paramNameForMessage = nameElement.getLocalName())) continue;
                if (elem.getStyleEnconding() != 0 && !param.isNillable()) {
                    throw new PRTFaultSerializator("Attributes with name " + paramNameForMessage + " can not be null following wsdl definition", (Object)this, (Exception)new IllegalArgumentException());
                }
                method_config = elem;
                break;
            }
        }
        this.constructSOAPParam(nameElement, element, qName, method_config);
        return true;
    }

    private void constructSOAPParam(Name nameElement, SOAPElement element, QNameURI qName, IPortalWebServiceMethod method_config) throws PRTFaultInternalError, SOAPServiceException {
        if (qName == null) {
            throw new PRTFaultInternalError((Object)this, (Exception)new IllegalArgumentException("No type found for the parameter " + nameElement.getLocalName()));
        }
        if (this.mm_context_params.getMethodContainer() == null && method_config != null) {
            this.mm_context_params.setMethodContainer(this.createMethodContainer(method_config));
        }
        SOAPParameter parameter = ParamsProcessor.getInstance().getSOAPParameter(element, qName, this.mm_context_params);
        this.addAttribute(nameElement.getLocalName(), parameter);
    }

    private MethodContainer createMethodContainer(IPortalWebServiceMethod method) {
        MethodContainer m = new MethodContainer();
        m.setWebserviceMethod_config(method);
        return m;
    }

    public XMLAttributeHandler getAttributeHandler() {
        return this.mm_attributeHandler;
    }

    public SOAPBodyElement marshall(SOAPEnvelope envelope, SOAPBody body) throws SOAPServiceException {
        try {
            String nameElement = this.mm_nameElement;
            if (this.isResponse) {
                nameElement = nameElement + "Response";
            }
            SOAPBodyElement bodyElement = null;
            if (!this.mm_context.isDocumentStyleEncoding()) {
                bodyElement = this.mm_bodyElement == null ? body.addBodyElement(envelope.createName(nameElement, this.mm_context.getPrefixForNamespace(this.mm_namespaceURI), this.mm_namespaceURI)) : body.addBodyElement(envelope.createName(nameElement, this.mm_bodyElement.getElementName().getPrefix(), this.mm_bodyElement.getElementName().getURI()));
                if (this.mm_context.getEncodingStyleNotDelegate() != null) {
                    bodyElement.setEncodingStyle(this.mm_context.getEncodingStyleNotDelegate());
                }
                this.mm_context.addNamespaceDeclarationInElement((SOAPElement)bodyElement);
            }
            Enumeration enumeration = this.mm_listParams.getKeyOrdered().elements();
            int id = 0;
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                SOAPParameter soapparam = this.mm_listParams.getAttributeValue(key);
                if (this.mm_context.isDocumentStyleEncoding()) {
                    this.determineDataStyleEncoding((SOAPMessageContext)(this.mm_context_params == null ? this.mm_context : this.mm_context_params), id);
                    ParamsProcessor.getInstance().marshall(soapparam.getType(), envelope, (SOAPElement)body, soapparam.getValue(), key, this.mm_context_params == null ? this.mm_context : this.mm_context_params);
                } else {
                    this.determineDataStyleEncoding((SOAPMessageContext)(this.mm_context_params == null ? this.mm_context : this.mm_context_params), id);
                    ParamsProcessor.getInstance().marshall(soapparam.getType(), envelope, (SOAPElement)bodyElement, soapparam.getValue(), key, this.mm_context_params == null ? this.mm_context : this.mm_context_params);
                }
                ++id;
            }
            if (!this.mm_context.isDocumentStyleEncoding()) {
                if (this.mm_context_params != null) {
                    this.mm_context_params.addNamespaceDeclarationInElement((SOAPElement)bodyElement);
                } else {
                    this.mm_context.addNamespaceDeclarationInElement((SOAPElement)bodyElement);
                }
            }
            return bodyElement;
        }
        catch (SOAPServiceException ex) {
            throw ex;
        }
        catch (SOAPException e) {
            throw new PRTFaultSerializator((Object)this, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PRTFaultInternalError((Object)this, e);
        }
    }

    public void setResponse(Object object, Class typeResponse) {
        SOAPParameter param = new SOAPParameter(null, typeResponse, object);
        this.mm_listParams.addAttribute("response", param);
        this.isResponse = true;
    }

    public void addAttribute(String attributeName, SOAPParameter param) {
        if (this.mm_attributeHandler == null) {
            this.mm_attributeHandler = new XMLAttributeHandler();
        }
        this.mm_attributeHandler.addAttribute(attributeName, param);
    }
}

