/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.decoding;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.XMLValueExtractor;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.soap.SOAPElement;

public class DateTimeDeserializer
implements SOAPDeserializer {
    static /* synthetic */ Class class$java$util$Date;

    public SOAPParameter unmarshall(String inScopeEncStyle, QName elementType, SOAPElement element, ISOAPMessageContext context) {
        if (context.isEncodedAsAttribute()) {
            if (context.getValueOfAttribute() != null) {
                String datetime = context.getValueOfAttribute();
                Date javaDate = this.constructDateTimeObject(datetime);
                return new SOAPParameter(elementType, class$java$util$Date == null ? (class$java$util$Date = DateTimeDeserializer.class$("java.util.Date")) : class$java$util$Date, (Object)javaDate);
            }
            if (context.getDefaultValue() != null && context.getDefaultValue().length() > 0) {
                String datetime = context.getValueOfAttribute();
                Date javaDate = this.constructDateTimeObject(datetime);
                return new SOAPParameter(elementType, class$java$util$Date == null ? (class$java$util$Date = DateTimeDeserializer.class$("java.util.Date")) : class$java$util$Date, (Object)javaDate);
            }
            return new SOAPParameter(elementType, class$java$util$Date == null ? (class$java$util$Date = DateTimeDeserializer.class$("java.util.Date")) : class$java$util$Date, null);
        }
        if (XMLValueExtractor.isValueNull((SOAPElement)element)) {
            return new SOAPParameter(elementType, class$java$util$Date == null ? (class$java$util$Date = DateTimeDeserializer.class$("java.util.Date")) : class$java$util$Date, null);
        }
        String datetime = element.getValue();
        Date javaDate = this.constructDateTimeObject(datetime);
        return new SOAPParameter(elementType, class$java$util$Date == null ? (class$java$util$Date = DateTimeDeserializer.class$("java.util.Date")) : class$java$util$Date, (Object)javaDate);
    }

    private Date constructDateTimeObject(String datetime) throws PRTFaultSerializator {
        Date javaDate = null;
        String timezone = null;
        int signOffset = 0;
        try {
            GregorianCalendar calendar;
            StringTokenizer ps = new StringTokenizer(datetime, "T");
            String date = ps.nextToken();
            String timeAndtimezone = ps.nextToken();
            StringTokenizer ptime = null;
            if (timeAndtimezone.indexOf("-") >= 0) {
                ptime = new StringTokenizer(timeAndtimezone, "-");
                signOffset = -1;
            } else if (timeAndtimezone.indexOf("+") >= 0) {
                ptime = new StringTokenizer(timeAndtimezone, "+");
                signOffset = 1;
            }
            String time = null;
            String millisecond = null;
            if (signOffset != 0) {
                time = ptime.nextToken();
                timezone = ptime.nextToken();
            } else {
                time = timeAndtimezone;
                if (time.indexOf("Z") >= 0) {
                    time = time.substring(0, time.indexOf("Z"));
                }
                timezone = null;
            }
            if (time.indexOf(".") >= 0) {
                millisecond = time.substring(time.indexOf("."), time.length());
                time = time.substring(0, time.indexOf("."));
                millisecond = millisecond.substring(1);
            }
            if ((calendar = this.constructDateTime(date, time)) == null) {
                throw new PRTFaultSerializator("Date Type not regonized'" + datetime + "'.", (Object)this, (Exception)new IllegalArgumentException("Date Type not regonized'" + datetime + "'."));
            }
            if (timezone != null) {
                int offset = Integer.parseInt(timezone.substring(0, timezone.indexOf(":")));
                SimpleTimeZone pdt = new SimpleTimeZone(signOffset * offset * 60 * 60 * 1000, "ZZZ");
                ((Calendar)calendar).setTimeZone(pdt);
                TimeZone.getAvailableIDs();
            }
            if (millisecond != null) {
                calendar.set(14, Integer.parseInt(millisecond));
            }
            javaDate = calendar.getTime();
        }
        catch (Exception e) {
            throw new PRTFaultSerializator("Malformed Date Type '" + datetime + "'.", (Object)this, (Exception)new IllegalArgumentException("Malformed Date Type '" + datetime + "'."));
        }
        return javaDate;
    }

    private GregorianCalendar constructDateTime(String date, String time) {
        try {
            StringTokenizer ps = new StringTokenizer(date, "-");
            int year = Integer.parseInt(ps.nextToken());
            int month = Integer.parseInt(ps.nextToken()) - 1;
            int day = Integer.parseInt(ps.nextToken());
            ps = new StringTokenizer(time, ":");
            int hour = Integer.parseInt(ps.nextToken());
            int minute = Integer.parseInt(ps.nextToken());
            int sec = Integer.parseInt(ps.nextToken());
            GregorianCalendar calendar = new GregorianCalendar(year, month, day, hour, minute, sec);
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

