/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.admin;

import com.sap.security.api.IUser;
import com.sapportals.config.fwk.Configuration;
import com.sapportals.config.fwk.IConfigClientContext;
import com.sapportals.config.fwk.IConfigManager;
import com.sapportals.config.fwk.IConfigPlugin;
import com.sapportals.config.fwk.IConfigurationAccess;
import com.sapportals.config.fwk.IMutableConfigurable;
import com.sapportals.portal.prt.component.AbstractPortalComponent;
import com.sapportals.portal.prt.component.IPortalComponentContext;
import com.sapportals.portal.prt.component.IPortalComponentInitContext;
import com.sapportals.portal.prt.component.IPortalComponentProfile;
import com.sapportals.portal.prt.component.IPortalComponentRequest;
import com.sapportals.portal.prt.component.IPortalComponentResponse;
import com.sapportals.portal.prt.component.IPortalComponentURI;
import com.sapportals.portal.prt.component.PortalComponentException;
import com.sapportals.portal.prt.deployment.DeploymentManager;
import com.sapportals.portal.prt.deployment.descriptor.IApplication;
import com.sapportals.portal.prt.deployment.descriptor.IConfiguration;
import com.sapportals.portal.prt.deployment.descriptor.IServiceList;
import com.sapportals.portal.prt.event.IPortalRequestEvent;
import com.sapportals.portal.prt.pom.IComponentNode;
import com.sapportals.portal.prt.pom.INode;
import com.sapportals.portal.prt.pom.IPortalNode;
import com.sapportals.portal.prt.pom.NodeMode;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.IService;
import com.sapportals.portal.prt.service.soap.SOAPServiceManager;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.webserviceconfig.IPortalSOAPConfig;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebService;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceSerializer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class Admin
extends AbstractPortalComponent {
    private final String CONFIG_UI = "com.sap.portal.runtime.config.component.ConfigUI";
    private final String PORTAL_ROOT_FOLDER = "ConfigRootFolder";
    private final String CONFIG_ROOT_ITEM = "RootItem";
    private static final long TIMEOUT = 100000L;
    private static final long WAIT_TIMEOUT = 10000L;
    private static final String CONFIG_PLUGIN = "/portal/com.sapportals.portal.prt.service.soap/config";
    private static final String SERVICES_PLUGIN = "/portal/com.sapportals.portal.prt.service.soap/services";
    private static final String SERVICES_CLASS = "Services";
    private static final String SERVICES_ID = "ID";
    private static final String SERVICES_WEB_ENABLE = "webEnable";
    private static final String SERVICES_WEB_PROXY = "webProxy";
    private static final String SERVICES_RPC_ENCODED = "rpcEncoded";
    private static final String SERVICES_RPC_LITTERAL = "rpcLiteral";
    private static final String SERVICES_DOCUMENT_LITTERAL = "documentLiteral";
    private static final String CUSTOM_PLUGIN = "/portal/com.sapportals.portal.prt.service.soap/custom_types";
    private static final String CUSTOM_CLASS = "CustomTypes";
    private static final String CUSTOM_ID = "ID";
    private static final String CUSTOM_NAME = "name";
    private static final String CUSTOM_TYPE = "type";
    private static final String CUSTOM_LOCALPART = "localpartname";
    private static final String CUSTOM_NAMESPACE = "namespaceuri";
    private static final String CUSTOM_SERIALIZER = "serializer";
    private static final String CUSTOM_SERVICE = "service";
    private static final String PRIMITIVE_PLUGIN = "/portal/com.sapportals.portal.prt.service.soap/primitive_types";
    private static final String PRIMITIVE_CLASS = "PrimitiveTypes";
    private static final String PRIMITIVE_ID = "ID";
    private static final String PRIMITIVE_NAME = "name";
    private static final String PRIMITIVE_LOCALPART = "localpartname";
    private static final String PRIMITIVE_NAMESPACE = "namespaceuri";
    private static final String PRIMITIVE_DESERIALIZER = "deserializer";
    private static final String PRIMITIVE_SERIALIZER = "serializer";
    private IConfigClientContext mm_clientContext = null;

    public void init(IPortalComponentInitContext context) throws PortalComponentException {
        this.mm_clientContext = IConfigClientContext.createContext();
    }

    public void doContent(IPortalComponentRequest request, IPortalComponentResponse response) {
        this.addRefreshComponent(request, response);
        this.addConfigComponent(request, response);
    }

    public void doRefresh(IPortalComponentRequest request, IPortalRequestEvent event) {
        this.updateUser(request);
        this.doRefreshSoapServices();
    }

    public void doDeepInit(IPortalComponentRequest request, IPortalRequestEvent event) {
        this.updateUser(request);
        this.doRefreshSoapServices();
        this.doRefreshCustomTyes();
        this.doRefreshPrimitiveTyes();
    }

    public void doRefreshSoapServices() {
        System.out.print("Refresh plugin: /portal/com.sapportals.portal.prt.service.soap/services ... ");
        long t1 = System.currentTimeMillis();
        this.cleanPlugin(SERVICES_PLUGIN);
        HashMap<String, String> map = null;
        IApplication[] listApplication = DeploymentManager.getInstance().getApplications();
        int i = 0;
        while (i < listApplication.length) {
            IApplication application = listApplication[i];
            IServiceList listService = application.getServices();
            int j = 0;
            while (j < listService.getLength()) {
                com.sapportals.portal.prt.deployment.descriptor.IService iservice = listService.item(j);
                String name = iservice.getName();
                String alias = iservice.getAlias();
                String applicationName = application.getName();
                IConfiguration config = iservice.getConfiguration();
                String value = config.getPropertyValue("WebEnable");
                if (value != null && value.equals("true")) {
                    try {
                        IService service = PortalRuntime.getRuntimeResources().getService(alias);
                        String rpcEnc = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "rpc_enc");
                        String rpcLit = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "rpc_lit");
                        String docLit = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "doc_lit");
                        map = new HashMap<String, String>();
                        map.put("ID", this.checkString(alias));
                        map.put(SERVICES_WEB_ENABLE, this.checkBoolean(value));
                        map.put(SERVICES_WEB_PROXY, this.checkBoolean(config.getPropertyValue("WebProxy")));
                        map.put(SERVICES_RPC_ENCODED, this.checkString(this.checkWsdl(alias, rpcEnc, "rpc_enc")));
                        map.put(SERVICES_RPC_LITTERAL, this.checkString(this.checkWsdl(alias, rpcLit, "rpc_lit")));
                        map.put(SERVICES_DOCUMENT_LITTERAL, this.checkString(this.checkWsdl(alias, docLit, "doc_lit")));
                        this.addConfigurable(SERVICES_PLUGIN, SERVICES_CLASS, map);
                    }
                    catch (Exception ex) {
                        try {
                            IService service = PortalRuntime.getRuntimeResources().getService(applicationName + "." + name);
                            String rpcEnc = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "rpc_enc");
                            String rpcLit = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "rpc_lit");
                            String docLit = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), name, "doc_lit");
                            map = new HashMap();
                            map.put("ID", this.checkString(applicationName + "." + name));
                            map.put(SERVICES_WEB_ENABLE, this.checkBoolean(value));
                            map.put(SERVICES_WEB_PROXY, this.checkBoolean(config.getPropertyValue("WebProxy")));
                            map.put(SERVICES_RPC_ENCODED, this.checkString(this.checkWsdl(alias, rpcEnc, "rpc_enc")));
                            map.put(SERVICES_RPC_LITTERAL, this.checkString(this.checkWsdl(alias, rpcLit, "rpc_lit")));
                            map.put(SERVICES_DOCUMENT_LITTERAL, this.checkString(this.checkWsdl(alias, docLit, "doc_lit")));
                            this.addConfigurable(SERVICES_PLUGIN, SERVICES_CLASS, map);
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Ok (" + (System.currentTimeMillis() - t1) + " ms)");
    }

    public void doRefreshCustomTyes() {
        System.out.print("Refresh plugin: /portal/com.sapportals.portal.prt.service.soap/custom_types ... ");
        long t1 = System.currentTimeMillis();
        this.cleanPlugin(CUSTOM_PLUGIN);
        HashMap<String, String> map = null;
        IApplication[] listApplication = DeploymentManager.getInstance().getApplications();
        int i = 0;
        while (i < listApplication.length) {
            IApplication application = listApplication[i];
            IServiceList listService = application.getServices();
            int j = 0;
            while (j < listService.getLength()) {
                IConfiguration config;
                String value;
                com.sapportals.portal.prt.deployment.descriptor.IService iservice = listService.item(j);
                String nameservice = iservice.getName();
                String alias = iservice.getAlias();
                if (alias != null && (value = (config = iservice.getConfiguration()).getPropertyValue("WebEnable")) != null && value.equals("true")) {
                    IService service = null;
                    ISpecializedRegistry registry = null;
                    try {
                        service = PortalRuntime.getRuntimeResources().getService(iservice.getAlias());
                    }
                    catch (Exception e) {
                        try {
                            service = PortalRuntime.getRuntimeResources().getService(application.getName() + "." + nameservice);
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    try {
                        registry = SOAPServiceManager.getInstance().getSpecializedRegistry(alias, service.getContext());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    registry = SOAPRegistry.getInstance().getSpecializedRegistry(alias);
                    if (registry != null) {
                        IPortalSOAPConfig soapConfig = registry.getSOAPConfig();
                        try {
                            IPortalWebService ws = soapConfig.getPortalWebService(alias);
                            Enumeration enumeration = ws.getAllPortalWebServiceSerializers();
                            while (enumeration.hasMoreElements()) {
                                IPortalWebServiceSerializer key = (IPortalWebServiceSerializer)enumeration.nextElement();
                                map = new HashMap<String, String>();
                                map.put("ID", this.checkString(alias + ":" + key.getLocalpart()));
                                map.put("name", this.checkString(key.getName()));
                                map.put("localpartname", this.checkString(key.getLocalpart()));
                                map.put("namespaceuri", this.checkString(key.getNamespace()));
                                map.put(CUSTOM_TYPE, this.checkString(key.getJavatype()));
                                map.put("serializer", this.checkString(key.getSerializer()));
                                map.put(CUSTOM_SERVICE, this.checkString(alias));
                                this.addConfigurable(CUSTOM_PLUGIN, CUSTOM_CLASS, map);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Ok (" + (System.currentTimeMillis() - t1) + " ms)");
    }

    public void doRefreshPrimitiveTyes() {
        System.out.print("Refresh plugin: /portal/com.sapportals.portal.prt.service.soap/primitive_types ... ");
        long t1 = System.currentTimeMillis();
        this.cleanPlugin(PRIMITIVE_PLUGIN);
        HashMap<String, String> map = null;
        Hashtable listSerializers = SOAPRegistry.getInstance().getListQName();
        Enumeration enumKeys = listSerializers.keys();
        while (enumKeys.hasMoreElements()) {
            String element = (String)enumKeys.nextElement();
            QName qnameKey = (QName)listSerializers.get(element);
            String namespace = qnameKey.getNamespaceURI();
            Class classKey = SOAPRegistry.getInstance().getJavaType(qnameKey, namespace);
            SOAPDeserializer derObject = SOAPRegistry.getInstance().getDeserializer(qnameKey, namespace);
            SOAPSerializer serObject = SOAPRegistry.getInstance().getSerializer(SOAPRegistry.getInstance().getJavaType(qnameKey, namespace), namespace);
            String ser = "";
            if (serObject != null) {
                ser = serObject.getClass().toString();
            }
            String deser = "";
            if (derObject != null) {
                deser = derObject.getClass().toString();
            }
            map = new HashMap<String, String>();
            map.put("ID", this.checkString(this.url2id(namespace) + ":" + qnameKey.getLocalPart()));
            map.put("localpartname", this.checkString(qnameKey.getLocalPart()));
            map.put("namespaceuri", this.checkString(namespace));
            map.put("serializer", this.checkString(ser));
            map.put(PRIMITIVE_DESERIALIZER, this.checkString(deser));
            this.addConfigurable(PRIMITIVE_PLUGIN, PRIMITIVE_CLASS, map);
        }
        System.out.println("Ok (" + (System.currentTimeMillis() - t1) + " ms)");
    }

    private void addRefreshComponent(IPortalComponentRequest request, IPortalComponentResponse response) {
        response.write("<table width=100%>");
        response.write("<tr>");
        response.write("<td class=gsapthead>");
        response.write("<nobr><b>SOAP Administration</b></nobr>");
        response.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        response.write(this.createButton(request, "Refresh", "Refresh"));
        response.write("&nbsp;");
        response.write(this.createButton(request, "Deep init", "DeepInit"));
        response.write("</td>");
        response.write("</tr>");
    }

    private void addConfigComponent(IPortalComponentRequest request, IPortalComponentResponse response) {
        IPortalNode portalNode = request.getNode().getPortalNode();
        IPortalComponentContext configContext = request.getComponentContext("com.sap.portal.runtime.config.component.ConfigUI");
        IPortalComponentProfile configProfile = configContext.getProfile();
        IPortalComponentContext defaultContext = request.getComponentContext(NodeMode.DEFAULT_MODE);
        IPortalComponentProfile defaultProfile = defaultContext.getProfile();
        String rootItem = defaultProfile.getProperty("ConfigRootFolder");
        if (rootItem == null) {
            rootItem = "/portal/" + defaultContext.getApplicationName();
        }
        IComponentNode configNode = portalNode.createComponentNode("config", configContext);
        configNode.putValue("RootItem", (Object)rootItem);
        request.getNode().addChildNode((INode)configNode);
        response.write("<tr>");
        response.write("<td class=urGrpBdyBox>");
        response.include(request, (INode)configNode);
        response.write("</td>");
        response.write("</tr>");
        response.write("</table>");
    }

    private String createButton(IPortalComponentRequest request, String buttonName, String eventName) {
        IPortalComponentURI uri = request.createPortalComponentURI();
        uri.setPortalRequestEvent(request.createRequestEvent(eventName));
        return "<a href=\"" + uri + "\" class=\"urBtnStd\"><nobr>" + buttonName + "</nobr></a>";
    }

    private void updateUser(IPortalComponentRequest request) {
        this.mm_clientContext.updateUser((IUser)request.getUser(), "");
    }

    private void cleanPlugin(String name) {
        try {
            IConfigurationAccess configurationService = Configuration.getInstance();
            IConfigManager configManager = configurationService.getConfigManager(this.mm_clientContext);
            IConfigPlugin plugin = configManager.getConfigPlugin(name);
            IMutableConfigurable[] configurables = plugin.getConfigurables();
            plugin.lock(100000L, 10000L);
            int i = 0;
            while (i < configurables.length) {
                plugin.removeConfigurable(configurables[i]);
                ++i;
            }
            plugin.unlock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addConfigurable(String pluginName, String configCLass, Map map) {
        try {
            IConfigurationAccess configurationService = Configuration.getInstance();
            IConfigManager configManager = configurationService.getConfigManager(this.mm_clientContext);
            IConfigPlugin plugin = configManager.getConfigPlugin(pluginName);
            IMutableConfigurable configurable = plugin.createConfigurable(map, configCLass);
            plugin.addConfigurable(configurable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String checkString(String text) {
        if (text == null || text.equals("")) {
            return "undefined";
        }
        return text;
    }

    private String checkBoolean(String text) {
        if (text == null || text.equals("")) {
            return "false";
        }
        return text;
    }

    private String checkWsdl(String alias, String wsdl, String param) {
        if (wsdl != null) {
            wsdl = alias.indexOf(":") >= 0 ? "/irj/servlet/prt/soap/" + alias.replace(':', '.') + "?" + "style" + "=" + param : "/irj/servlet/prt/soap/" + alias + "?" + "style" + "=" + param;
        }
        return wsdl;
    }

    private String url2id(String url) {
        if (url == null || url.equals("")) {
            return "undefined";
        }
        if (url.indexOf("http://") != -1) {
            url = url.substring(7, url.length());
        }
        url = url.replace('/', '-');
        return url;
    }
}

