/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sapportals.portal.prt.dispatcher.IDispatcherContext;
import com.sapportals.portal.prt.registry.PortalRegistry;
import com.sapportals.portal.prt.registry.content.IStreamSource;
import com.sapportals.portal.prt.registry.content.StreamSource;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.IService;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.IServiceProfile;
import com.sapportals.portal.prt.service.soap.ISOAPService;
import com.sapportals.portal.prt.service.soap.PRTSOAPSerializator;
import com.sapportals.portal.prt.service.soap.ServiceDescriptor;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.exception.SoapFaultHandler;
import com.sapportals.portal.prt.service.soap.listener.ISOAPSerializerListener;
import com.sapportals.portal.prt.service.soap.log.ISOAPLogger;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.mapping.SpecializedRegistry;
import com.sapportals.portal.prt.service.soap.processor.IMethodsAuthorizedProcessor;
import com.sapportals.portal.prt.service.soap.processor.ISOAPServiceProcessor;
import com.sapportals.portal.prt.service.soap.processor.InvokerProcessor;
import com.sapportals.portal.prt.service.soap.processor.MethodsAuthorizedProcessor;
import com.sapportals.portal.prt.service.soap.processor.SOAPPortalServiceProcessor;
import com.sapportals.portal.prt.service.soap.security.ISOAPSecurityManager;
import com.sapportals.portal.prt.service.soap.security.SOAPUser;
import com.sapportals.portal.prt.service.soap.util.CharTypeSolver;
import com.sapportals.portal.prt.session.IUserContext;
import com.sapportals.portal.prt.util.AutoClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;

public class SOAPServiceManager {
    private Hashtable mm_keyProcessor = new Hashtable();
    private static SOAPServiceManager mm_instance = null;
    private Hashtable mm_listOfProcessor = new Hashtable();
    private ISOAPLogger mm_soaplogger = null;
    private String mm_applicationName = "unknown_yet";
    private MessageFactory mm_messageFactory = null;
    static /* synthetic */ Class class$com$sapportals$portal$prt$service$soap$mapping$SpecializedRegistry;

    public static SOAPServiceManager getInstance() {
        if (mm_instance != null) {
            return mm_instance;
        }
        mm_instance = new SOAPServiceManager();
        return mm_instance;
    }

    private SOAPServiceManager() {
        if (this.mm_messageFactory == null) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this.mm_messageFactory = MessageFactory.newInstance();
                }
                catch (Exception ex) {
                    SOAPLogger logger = SOAPLogger.getInstance();
                    if (logger != null) {
                        logger.writeInfo(this, "SOAP Initialization problem : Not able to create Message Factory", ex);
                    }
                    Object var5_3 = null;
                    Thread.currentThread().setContextClassLoader(original);
                }
                Object var5_2 = null;
                Thread.currentThread().setContextClassLoader(original);
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                Thread.currentThread().setContextClassLoader(original);
                throw throwable;
            }
        }
        this.init();
    }

    public IPRTSOAPResponse consumeSOAPMessage(String serviceName, SOAPMessage sendedMessage, IServiceContext serviceContext, IUserContext userCtxt, IDispatcherContext dispatcherContext, boolean style_document, String datastyle_literal, String soapaction) {
        try {
            SOAPUser.setUser((IUserContext)userCtxt);
            long start = System.currentTimeMillis();
            ISOAPSecurityManager securityManager = ((ISOAPService)serviceContext.getService("com.sap.portal.runtime.application.soap.soap")).getSecurityManager();
            this.mm_soaplogger.writeInfo((Object)this, "[SOAP Consumer]: Here's the message receive by the SOAPConsumer", sendedMessage);
            SOAPMessage aMessage = securityManager.getSOAPMessageWithoutSecurity(sendedMessage);
            if (aMessage == null) {
                return null;
            }
            this.mm_soaplogger.writeInfo((Object)this, "Service Called is " + serviceName);
            this.getSpecializedRegistry(serviceName, serviceContext);
            IMethodsAuthorizedProcessor methodsAuthorized = this.getMethodsAuthorized(serviceName, serviceContext);
            ServiceDescriptor descriptor = new ServiceDescriptor(serviceName, SOAPRegistry.getInstance().getSpecializedRegistry(serviceName));
            PRTSOAPMessage prtSoap = new PRTSOAPMessage(aMessage, descriptor, false, style_document, datastyle_literal, soapaction);
            PRTSOAPResponse response = this.invokeMethodOnServices(serviceName, prtSoap, serviceContext, methodsAuthorized, dispatcherContext, style_document);
            SOAPMessage msg = this.constructAnswer(response);
            this.destroyCallOnListener(response);
            long processtime = System.currentTimeMillis() - start;
            this.mm_soaplogger.writeInfo((Object)this, "Ending process SOAP Message in " + processtime / 1000L + "," + processtime % 1000L + " sec", msg);
            SOAPMessage finalResponse = securityManager.createSecuredSOAPMessage(msg, response.getMessage().getMessageContext());
            response.setSOAPMessageResponse(finalResponse);
            return response;
        }
        catch (Exception ex) {
            PRTSOAPResponse response = new PRTSOAPResponse();
            response.setSOAPMessageResponse(SoapFaultHandler.getInstance().consumeSOAPPRTMessageFault((Throwable)ex));
            return response;
        }
        catch (Throwable t) {
            PRTSOAPResponse response = new PRTSOAPResponse();
            response.setSOAPMessageResponse(SoapFaultHandler.getInstance().consumeSOAPPRTMessageFault(t));
            return response;
        }
    }

    private PRTSOAPResponse invokeMethodOnServices(String serviceName, IPRTSOAPMessage message, IServiceContext serviceContext, IMethodsAuthorizedProcessor methodsAuthorized, IDispatcherContext context, boolean style_document) throws SOAPServiceException {
        try {
            PRTSOAPResponse response = null;
            String theNamespaceURI = message.getEnveloppe().getBody().getMainNamespaceURI();
            String processorName = this.decodeKeyProcessor(theNamespaceURI);
            if (processorName == null) {
                try {
                    IService serviceInvoked = PortalRuntime.getRuntimeResources().getService(serviceName);
                    IServiceProfile profile = serviceInvoked.getContext().getServiceProfile();
                    if (profile != null) {
                        String value = profile.getProperty("WebserviceProcessor");
                        if (value != null) {
                            if (this.mm_listOfProcessor.containsKey(value)) {
                                processorName = value;
                            } else {
                                SOAPLogger.getInstance().writeInfo(this, "Error during the search of the processor '" + value + "' specify from the portalapp.xml");
                            }
                        } else {
                            SOAPLogger.getInstance().writeInfo(this, "Error during the check of the property porcessor in the portalapp.xml, property not found");
                        }
                    }
                }
                catch (RuntimeException e) {
                    SOAPLogger.getInstance().writeInfo((Object)this, "Error during the check of the property processor in the portalapp.xml, use the default processor", e);
                }
                if (processorName == null) {
                    processorName = this.decodeKeyProcessor("prt:service:");
                }
            }
            response = this.invokeProcessor(serviceName, message, serviceContext, methodsAuthorized, context, processorName);
            return response;
        }
        catch (SOAPServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PRTFaultInternalError((Object)this, ex);
        }
    }

    private PRTSOAPResponse invokeProcessor(String serviceName, IPRTSOAPMessage message, IServiceContext serviceContext, IMethodsAuthorizedProcessor methodsAuthorized, IDispatcherContext context, String processorName) {
        ISOAPServiceProcessor processor = (ISOAPServiceProcessor)this.mm_listOfProcessor.get(processorName);
        PRTSOAPResponse response = (PRTSOAPResponse)InvokerProcessor.getInstance().invokePortalSOAPProcessor(serviceName, message, serviceContext, methodsAuthorized, context, processor);
        return response;
    }

    private String decodeKeyProcessor(String theNamespaceURI) {
        if (theNamespaceURI == null) {
            return null;
        }
        String decodedKey = (String)this.mm_keyProcessor.get(theNamespaceURI);
        if (decodedKey != null) {
            return decodedKey;
        }
        return null;
    }

    private SOAPMessage constructAnswer(IPRTSOAPResponse response) {
        response.getMessage().getEnveloppe().getMainContext().setResponse(true);
        SOAPMessage msg = PRTSOAPSerializator.getInstance().constructSOAPMessage(this.mm_messageFactory, response);
        return msg;
    }

    private void init() {
        SOAPPortalServiceProcessor processor = new SOAPPortalServiceProcessor();
        this.registerProcessor(processor.getNamespace(), (ISOAPServiceProcessor)processor);
        CharTypeSolver.initCharTypes();
    }

    public ISOAPServiceProcessor registerProcessor(String key, ISOAPServiceProcessor processor) {
        ISOAPServiceProcessor oldprocessor = this.mm_listOfProcessor.put(processor.getName(), processor);
        this.mm_keyProcessor.put(key, processor.getName());
        return oldprocessor;
    }

    public ISOAPServiceProcessor unregisterProcessor(String key) {
        ISOAPServiceProcessor oldprocessor = (ISOAPServiceProcessor)this.mm_listOfProcessor.remove(key);
        this.mm_keyProcessor.remove(key);
        return oldprocessor;
    }

    public String registerKeyMapping(String keyProcessor, String additionalKeys) {
        return this.mm_keyProcessor.put(additionalKeys, keyProcessor);
    }

    public String unregisterKeyMapping(String additionalKeys) {
        return (String)this.mm_keyProcessor.remove(additionalKeys);
    }

    public ISpecializedRegistry getSpecializedRegistry(String serviceName, IServiceContext serviceContext) {
        IService service = serviceContext.getService(serviceName);
        if (service != null) {
            ISpecializedRegistry registry = SOAPRegistry.getInstance().getSpecializedRegistry(serviceName);
            if (registry != null && !this.verifyRegistryValidity(service, registry)) {
                SOAPRegistry.getInstance().removeSpecializedRegistry(serviceName);
                registry = null;
            }
            if (registry == null) {
                try {
                    AutoClassLoader loaderService = (AutoClassLoader)service.getClass().getClassLoader();
                    Class<?> classRegistry = Class.forName((class$com$sapportals$portal$prt$service$soap$mapping$SpecializedRegistry == null ? (class$com$sapportals$portal$prt$service$soap$mapping$SpecializedRegistry = SOAPServiceManager.class$("com.sapportals.portal.prt.service.soap.mapping.SpecializedRegistry")) : class$com$sapportals$portal$prt$service$soap$mapping$SpecializedRegistry).getName(), true, this.getClass().getClassLoader());
                    registry = (SpecializedRegistry)classRegistry.newInstance();
                    registry.initXMLBased(serviceName, service.getContext().getPrivateServicePath(), (ClassLoader)loaderService);
                    SOAPRegistry.getInstance().addSpecializedRegistry(serviceName, registry);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new PRTFaultInternalError((Object)this, ex);
                }
            }
            return SOAPRegistry.getInstance().getSpecializedRegistry(serviceName);
        }
        return null;
    }

    private boolean verifyRegistryValidity(IService service, ISpecializedRegistry registry) {
        ClassLoader registryClassLoader;
        ClassLoader serviceLoader = service.getClass().getClassLoader();
        return serviceLoader.equals(registryClassLoader = registry.getRegistryClassLoader());
    }

    private IMethodsAuthorizedProcessor getMethodsAuthorized(String serviceName, IServiceContext serviceContext) {
        if (serviceName != null) {
            IMethodsAuthorizedProcessor methodsAuthorized = SOAPRegistry.getInstance().getMethodsAuthorizedProcessor(serviceName);
            if (methodsAuthorized == null) {
                IService service = serviceContext.getService(serviceName);
                methodsAuthorized = new MethodsAuthorizedProcessor(service, serviceName);
                SOAPRegistry.getInstance().addMethodsAuthorizedProcessor(serviceName, methodsAuthorized);
            }
            return methodsAuthorized;
        }
        return null;
    }

    public void setMainSOAPServiceInstance(Properties prop) {
        block10: {
            SOAPLogger logger;
            Context subcontext;
            block9: {
                Context context;
                try {
                    Context ccs = PortalRegistry.getCentralConfigurationContext();
                    context = (Context)ccs.lookup(this.mm_applicationName);
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    return;
                }
                subcontext = null;
                try {
                    subcontext = (Context)context.lookup("config");
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
                if (subcontext == null) {
                    try {
                        subcontext = context.createSubcontext("config");
                    }
                    catch (NamingException e) {
                        logger = SOAPLogger.getInstance();
                        if (logger == null) break block9;
                        logger.writeInfo(this, "Operation failed", e);
                    }
                }
            }
            try {
                subcontext.rebind("configProp", (Object)new StreamSource(prop));
            }
            catch (NamingException e) {
                logger = SOAPLogger.getInstance();
                if (logger == null) break block10;
                logger.writeInfo(this, "Operation failed", e);
            }
        }
    }

    public Properties getMainSOAPServiceInstance() {
        Properties prop;
        block11: {
            SOAPLogger logger;
            Context subcontext;
            block10: {
                Context context;
                prop = new Properties();
                try {
                    Context ccs = PortalRegistry.getCentralConfigurationContext();
                    context = (Context)ccs.lookup(this.mm_applicationName);
                }
                catch (NamingException e) {
                    SOAPLogger logger2 = SOAPLogger.getInstance();
                    if (logger2 != null) {
                        logger2.writeInfo(this, "SOAP Configuration problem : Not able to read " + this.mm_applicationName + " context from central config store", e);
                    }
                    return null;
                }
                subcontext = null;
                try {
                    subcontext = (Context)context.lookup("config");
                }
                catch (NamingException e) {
                    logger = SOAPLogger.getInstance();
                    if (logger == null) break block10;
                    logger.writeInfo(this, "SOAP Configuration problem : Not able to read config context in central config store, loading default values", e);
                }
            }
            if (subcontext != null) {
                try {
                    IStreamSource src = (IStreamSource)subcontext.lookup("configProp");
                    InputStream inputStream = src.getInputStream();
                    prop.load(inputStream);
                    return prop;
                }
                catch (NamingException ex) {
                    logger = SOAPLogger.getInstance();
                    if (logger != null) {
                        logger.writeInfo(this, "SOAP Configuration problem : Not able to read config context in central config store, loading default values", ex);
                    }
                }
                catch (IOException ex) {
                    SOAPLogger logger3 = SOAPLogger.getInstance();
                    if (logger3 == null) break block11;
                    logger3.writeInfo(this, "SOAP Configuration problem : Not able to read subcontext in central config store, loading default values from file", ex);
                }
            }
        }
        return prop;
    }

    public void setCentralValueConfig(String name, String value) {
        Properties prop = this.getMainSOAPServiceInstance();
        prop.setProperty(name, value);
        this.setMainSOAPServiceInstance(prop);
    }

    public ISOAPLogger getSoaplogger() {
        if (this.mm_soaplogger != null) {
            return this.mm_soaplogger;
        }
        this.mm_soaplogger = SOAPLogger.getInstance();
        return this.mm_soaplogger;
    }

    public String getPathFileWSDLService(IServiceContext mm_serviceContext, String serviceName, String style) {
        String namefileWSDL = null;
        String prefix = this.determineModeDocument(style);
        namefileWSDL = mm_serviceContext.getServiceConfig().getProperty("WSDL" + prefix);
        if (namefileWSDL == null && prefix == "_RPC_ENC") {
            namefileWSDL = mm_serviceContext.getServiceConfig().getProperty("WSDL");
        }
        String pathService = mm_serviceContext.getPrivateServicePath();
        String pathWsdlFile = null;
        pathWsdlFile = namefileWSDL != null ? pathService + File.separator + namefileWSDL : pathService + File.separator + serviceName + ".wsdl";
        File wsdlfile = new File(pathWsdlFile);
        if (wsdlfile.exists()) {
            return pathWsdlFile;
        }
        return null;
    }

    private String determineModeDocument(String style) {
        String prefix = "_RPC_ENC";
        if (style.equals("doc_lit")) {
            prefix = "_DOC_LIT";
        }
        if (style.equals("rpc_lit")) {
            prefix = "_RPC_LIT";
        }
        return prefix;
    }

    public String getPathWSDLService(IServiceContext mm_serviceContext, String serviceName, String style) {
        String prefix = this.determineModeDocument(style);
        String namefileWSDL = mm_serviceContext.getServiceConfig().getProperty("WSDL" + prefix);
        if (namefileWSDL == null && prefix == "_RPC_ENC") {
            namefileWSDL = mm_serviceContext.getServiceConfig().getProperty("WSDL");
        }
        if (namefileWSDL == null) {
            return null;
        }
        String pathWsdl = null;
        pathWsdl = namefileWSDL.indexOf("/") != -1 ? namefileWSDL.substring(0, namefileWSDL.indexOf("/") + 1) : "";
        String pathService = mm_serviceContext.getPrivateServicePath();
        String pathWsdlFile = null;
        pathWsdlFile = namefileWSDL != null ? pathService + File.separator + pathWsdl : pathService;
        return pathWsdlFile;
    }

    private void destroyCallOnListener(IPRTSOAPResponse response) {
        Object service = response.getServiceInstance();
        if (service instanceof ISOAPSerializerListener) {
            ((ISOAPSerializerListener)service).destroy(response.getObjectResponse());
        }
    }

    public String getApplicationName() {
        return this.mm_applicationName;
    }

    public void setApplicationName(String p_mm_applicationName) {
        this.mm_applicationName = p_mm_applicationName;
    }

    private void destroyLocal() {
        if (mm_instance != null) {
            this.mm_listOfProcessor = null;
            this.mm_soaplogger = null;
            this.mm_messageFactory = null;
        }
    }

    public static void destroy() {
        if (mm_instance != null) {
            mm_instance.destroyLocal();
        }
        mm_instance = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

