/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sap.engine.services.webservices.jaxm.soap.SAPSoapException;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.umap.IUserMappingData;
import com.sapportals.portal.prt.connection.servlet.IServletConnection;
import com.sapportals.portal.prt.registry.PortalRegistry;
import com.sapportals.portal.prt.service.IServiceConfiguration;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.soap.IPRTSOAPCall;
import com.sapportals.portal.prt.service.soap.IPRTSOAPProxy;
import com.sapportals.portal.prt.service.soap.IPRTSOAPSerializator;
import com.sapportals.portal.prt.service.soap.ISOAPConnection;
import com.sapportals.portal.prt.service.soap.ISOAPService;
import com.sapportals.portal.prt.service.soap.IServiceDescriptor;
import com.sapportals.portal.prt.service.soap.PRTSOAPCall;
import com.sapportals.portal.prt.service.soap.PRTSOAPElementFactory;
import com.sapportals.portal.prt.service.soap.PRTSOAPProxy;
import com.sapportals.portal.prt.service.soap.PRTSOAPSerializator;
import com.sapportals.portal.prt.service.soap.ParamsProcessor;
import com.sapportals.portal.prt.service.soap.SOAPConnection;
import com.sapportals.portal.prt.service.soap.SOAPServiceManager;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultFromSOAPMessage;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.exception.SoapFaultHandler;
import com.sapportals.portal.prt.service.soap.log.ISOAPLogger;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.mapping.InitMapping;
import com.sapportals.portal.prt.service.soap.mapping.SOAPRegistry;
import com.sapportals.portal.prt.service.soap.processor.ISOAPServiceProcessor;
import com.sapportals.portal.prt.service.soap.security.ISOAPSecurityManager;
import com.sapportals.portal.prt.service.soap.security.SOAPSecurityManager;
import com.sapportals.portal.prt.service.soap.util.ConfigSOAPService;
import com.sapportals.portal.prt.service.soap.util.CookiesUtils;
import com.sapportals.portal.prt.service.soap.util.IConfigurationSOAPService;
import com.sapportals.portal.prt.service.soap.wsdlImpl.factory.WSDLFactoryImpl;
import com.sapportals.portal.prt.service.usermapping.IUserMappingService;
import com.sapportals.portal.prt.session.IUserContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.servlet.http.Cookie;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;

public class SOAPService
implements ISOAPService {
    private SoapFaultHandler handlerFault = null;
    private ClassLoader mm_originalClassLoader = null;
    private SOAPSecurityManager mm_securityManager = null;
    private IServiceContext mm_serviceContext;
    private ISOAPConnection mm_soapConnection;
    private SOAPFactory mm_elementFactory = null;
    private ISOAPLogger mm_soaplogger = null;
    private javax.xml.soap.SOAPConnection mm_soapConnectionFactory;
    private IConfigurationSOAPService mm_configService = null;
    static /* synthetic */ Class class$com$sapportals$portal$prt$service$soap$mapping$InitMapping;

    public IServletConnection getConnection() {
        return this.mm_soapConnection;
    }

    public IServiceContext getContext() {
        return this.mm_serviceContext;
    }

    public String getDefaultBaseURL_PRToutside() {
        try {
            return this.getConfigurationSOAPService().readPropertie("baseURLprtOuside");
        }
        catch (Exception ex) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "GetDefaultBaseURL_PRToutside Method failed", ex);
            }
            return null;
        }
    }

    public String getKey() {
        return "com.sap.portal.runtime.application.soap.soap";
    }

    public MessageFactory getMsgFactory() {
        return this.mm_soapConnection.getMsgFactory();
    }

    public IPRTSOAPSerializator getSerializator() {
        return PRTSOAPSerializator.getInstance();
    }

    public void afterInit() {
    }

    public IPRTSOAPMessage call(SOAPMessage msg, String url, IServiceDescriptor descriptor, IUserContext user, String systemAlias) throws PRTFault {
        try {
            SOAPMessage reply;
            IUserMappingData usermapping;
            IUserMappingService mappingService;
            javax.xml.soap.SOAPConnection soapCon = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            soapCon = SOAPConnectionFactory.newInstance().createConnection();
            Thread.currentThread().setContextClassLoader(this.mm_originalClassLoader);
            URLEndpoint urlendpoint = new URLEndpoint(url);
            this.mm_soaplogger.writeInfo((Object)this, " Request Message SOAP:", msg);
            if (user != null && (mappingService = (IUserMappingService)this.mm_serviceContext.getService("com.sap.portal.usermapping.user_mapping")) != null && (usermapping = mappingService.getMappingData(systemAlias, (IPrincipal)user)) != null) {
                usermapping.enrich(msg);
            }
            try {
                reply = soapCon.call(msg, (Object)urlendpoint);
            }
            catch (SAPSoapException e) {
                SOAPException soap = null;
                if (e.getCause().toString().indexOf("java.net.") != -1) {
                    soap = new SOAPException("[PROXY Error] " + e.getCause().toString() + " (proxy host: " + System.getProperty("http.proxyHost", null) + ", proxy port: " + System.getProperty("http.proxyPort", "-1") + ", non proxy host: " + System.getProperty("http.nonProxyHosts") + ")");
                }
                soap = e.toString().indexOf("javax.xml.soap") != -1 ? new SOAPException("[PROXY Error] " + e.getCause().toString() + " (proxy host: " + System.getProperty("http.proxyHost", null) + ", proxy port: " + System.getProperty("http.proxyPort", "-1") + ", non proxy host: " + System.getProperty("http.nonProxyHosts") + ")") : new SOAPException("SOAP Response Message was not well formed (" + e.getCause().toString() + ").");
                soap.initCause((Throwable)e);
                throw new PRTFaultInternalError((Object)this, (Exception)((Object)soap));
            }
            Cookie[] listcookies = this.extractCookieFromResponse(reply);
            this.mm_soaplogger.writeInfo((Object)this, "Reply Message SOAP:", reply);
            if (reply.getSOAPPart().getEnvelope().getBody().hasFault()) {
                throw new PRTFaultFromSOAPMessage(reply);
            }
            String[] soapaction = msg.getMimeHeaders() != null ? msg.getMimeHeaders().getHeader("soapaction") : null;
            PRTSOAPMessage resonseMessage = new PRTSOAPMessage(reply, descriptor, true, descriptor.getContextRequest() != null ? descriptor.getContextRequest().isDocumentStyleEncoding() : false, null, soapaction != null ? soapaction[0] : null);
            if (listcookies != null) {
                resonseMessage.addCookies(listcookies);
            }
            return resonseMessage;
        }
        catch (Exception soapEx) {
            SOAPLogger logger = SOAPLogger.getInstance();
            if (logger != null) {
                logger.writeInfo(this, "Call failed", soapEx);
            }
            if (soapEx instanceof PRTFault) {
                throw (PRTFault)((Object)soapEx);
            }
            throw new PRTFaultInternalError((Object)this, soapEx);
        }
    }

    public IPRTSOAPMessage call(SOAPMessage msg, String url, IServiceDescriptor descriptor) throws PRTFault {
        return this.call(msg, url, descriptor, null, null);
    }

    public void configure(IServiceConfiguration configuration) {
    }

    public void destroy() {
        ConfigSOAPService.destroy();
        SOAPServiceManager.destroy();
        SOAPRegistry.destroy();
        InitMapping.destroy();
        ParamsProcessor.destroy();
        PRTSOAPSerializator.destroy();
        PRTFault.releasePRTFaultContextClientSide();
        PRTFault.releasePRTFaultContextServerSide();
        PRTSOAPElementFactory.destroy();
        if (this.mm_soapConnection != null) {
            try {
                PortalRegistry.getInstance().unbind("/runtime/connections/soap");
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            this.mm_soapConnection = null;
        }
        if (this.mm_soaplogger != null) {
            this.mm_soaplogger.close();
        }
        SOAPLogger.destroy();
    }

    public IConfigurationSOAPService getConfigurationSOAPService() {
        return this.mm_configService;
    }

    public void init(IServiceContext serviceContext) {
        this.mm_serviceContext = serviceContext;
        SOAPServiceManager.getInstance().setApplicationName(serviceContext.getApplicationName());
        this.mm_configService = ConfigSOAPService.getInstance();
        this.mm_soaplogger = SOAPServiceManager.getInstance().getSoaplogger();
        this.mm_soaplogger.writeInfo((Object)this, "SOAP Service start...");
        this.handlerFault = SoapFaultHandler.constructInstance((ISOAPService)this);
        this.mm_securityManager = new SOAPSecurityManager(this);
        this.mm_originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.mm_soapConnection = new SOAPConnection(serviceContext);
        try {
            PortalRegistry.getInstance().rebind("/runtime/connections/soap", (Object)this.mm_soapConnection);
            this.mm_soaplogger.writeInfo((Object)this, "Binding the SOAP Connection OK.");
        }
        catch (Throwable e) {
            Thread.currentThread().setContextClassLoader(this.mm_originalClassLoader);
            this.mm_soaplogger.writeInfo((Object)this, "Binding the SOAP Connection Error.", (Exception)e);
            throw new SOAPServiceException(e);
        }
        try {
            this.mm_soapConnectionFactory = SOAPConnectionFactory.newInstance().createConnection();
            this.mm_elementFactory = SOAPFactory.newInstance();
            this.mm_soaplogger.writeInfo((Object)this, "Creation of the SOAP Connection Factory OK.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            Thread.currentThread().setContextClassLoader(this.mm_originalClassLoader);
            this.mm_soaplogger.writeInfo((Object)this, "Creation of the SOAP Connection Factory Error.", (Exception)e);
            throw new SOAPServiceException(e);
        }
        PRTSOAPElementFactory.initialize((SOAPFactory)this.mm_elementFactory);
        Thread.currentThread().setContextClassLoader(this.mm_originalClassLoader);
        InputStream stream = (class$com$sapportals$portal$prt$service$soap$mapping$InitMapping == null ? (class$com$sapportals$portal$prt$service$soap$mapping$InitMapping = SOAPService.class$("com.sapportals.portal.prt.service.soap.mapping.InitMapping")) : class$com$sapportals$portal$prt$service$soap$mapping$InitMapping).getResourceAsStream("/types/soapTypes.xml");
        if (stream == null) {
            throw new IllegalStateException("Error during the loading of soap types.");
        }
        InitMapping.getInstance().initializeAllMappingsForWSDL(stream);
        this.mm_soaplogger.writeInfo((Object)this, "SOAP Service initialized !!");
    }

    public void release() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPropertie(String prop) {
        block12: {
            block11: {
                propertie = null;
                fio = null;
                try {
                    try {
                        fileprops = new File(this.mm_serviceContext.getPrivateServicePath() + File.separator + "soap.properties");
                        if (fileprops.exists()) {
                            props = new Properties();
                            fio = new FileInputStream(fileprops);
                            props.load(fio);
                            propertie = props.getProperty(prop);
                            props.clear();
                            fio.close();
                            var6_9 = propertie;
                            var8_11 = null;
                            break block11;
                        }
                        props = null;
                        break block12;
                    }
                    catch (Exception ex) {
                        logger = SOAPLogger.getInstance();
                        if (logger != null) {
                            logger.writeInfo(this, "readPropertie Method failed", ex);
                        }
                        var6_10 = null;
                        var8_13 = null;
                        try {
                            if (fio != null) return var6_10;
                            fio.close();
                            return var6_10;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return var6_10;
                    }
                }
                catch (Throwable var7_19) {
                    var8_14 = null;
                    try {}
                    catch (IOException e) {
                        throw var7_19;
                    }
                    if (fio != null) throw var7_19;
                    fio.close();
                    throw var7_19;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 156->167)] { 
lbl45:
            // 1 sources

            if (fio != null) return var6_9;
            fio.close();
            return var6_9;
lbl48:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var6_9;
        }
        var8_12 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 156->167)] { 
lbl54:
        // 1 sources

        if (fio != null) return props;
        fio.close();
        return props;
lbl57:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return props;
    }

    public IPRTSOAPProxy getProxyInstance(String url, String serviceName, String namespaceURI) {
        return new PRTSOAPProxy(url, serviceName, namespaceURI, this);
    }

    public IPRTSOAPCall getSOAPCallInstance(String url, String serviceName, String namespaceURI) {
        return new PRTSOAPCall(url, serviceName, namespaceURI, this);
    }

    public IPRTSOAPCall getSOAPCallInstance(HashMap httpheaders, String url, String serviceName, String namespaceURI) {
        return new PRTSOAPCall(httpheaders, url, serviceName, namespaceURI, this);
    }

    public ISOAPSecurityManager getSecurityManager() {
        return this.mm_securityManager;
    }

    public ISOAPLogger getlogger() {
        return SOAPServiceManager.getInstance().getSoaplogger();
    }

    public WSDLReader getWSDLReader() throws WSDLException {
        try {
            WSDLFactoryImpl factory = new WSDLFactoryImpl();
            WSDLReader reader = factory.newWSDLReader();
            return reader;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public WSDLWriter getWSDLWriter() throws WSDLException {
        try {
            WSDLFactoryImpl factory = new WSDLFactoryImpl();
            WSDLWriter writer = factory.newWSDLWriter();
            return writer;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ISOAPServiceProcessor registerSOAPServiceProcessor(String key, ISOAPServiceProcessor processor) {
        return SOAPServiceManager.getInstance().registerProcessor(key, processor);
    }

    public ISOAPServiceProcessor unregisterSOAPServiceProcessor(String key) {
        return SOAPServiceManager.getInstance().unregisterProcessor(key);
    }

    public IPRTSOAPResponse getNewSOAPResponseInstance(IPRTSOAPMessage message) {
        return new PRTSOAPResponse((PRTSOAPMessage)message);
    }

    private Cookie[] extractCookieFromResponse(SOAPMessage message) {
        MimeHeaders mime = message.getMimeHeaders();
        return CookiesUtils.extractCookiesFromMimeHeaders(mime);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

