/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.IServiceDescriptor;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultEnvelopeVersion;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.processor.MethodContainer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;

public class SOAPMessageContext
implements ISOAPMessageContext {
    Hashtable mm_listOfMappingNamespace = new Hashtable();
    Hashtable mm_listOfPrefix = new Hashtable();
    Hashtable mm_listOfIds = new Hashtable();
    String mm_encodingStyle = null;
    ISOAPMessageContext mm_parent = null;
    IServiceDescriptor mm_descriptor = null;
    private boolean mm_isResponse = false;
    private String mm_valueAttribute = null;
    private String mm_defaultValue = null;
    private boolean mm_encodedAsAttributte = false;
    private static String mm_prefixGenerated = "prt";
    private static int mm_nbPrefixGenerated = 0;
    private Object mm_faultObjectInstance = null;
    private String mm_documentStyle = null;
    private String mm_litteralStyle = null;
    private String mm_dataStyleEncodingAsked = null;
    private MethodContainer mm_method = null;
    private String mm_soapAction = null;
    private String mm_tnsMethod = null;
    private String mm_arrayChildsName = null;
    private boolean mm_arrayListType = false;
    private boolean mm_simpleType = false;

    public SOAPMessageContext(String nameSpace, ISOAPMessageContext context) {
        this.mm_encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.addNamespaceDeclaration("wn0", "http://schemas.xmlsoap.org/soap/encoding/");
        this.addNamespaceDeclaration("wn1", "http://www.w3.org/2001/XMLSchema");
        this.addNamespaceDeclaration("wn2", "http://www.w3.org/2000/10/XMLSchema");
        this.addNamespaceDeclaration("wn3", "http://www.w3.org/1999/XMLSchema");
        this.addNamespaceDeclaration("wn4", nameSpace);
        this.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.mm_parent = context;
    }

    public static void resetPrefixGenerated() {
        mm_nbPrefixGenerated = 0;
    }

    public SOAPMessageContext(String nameSpace, IServiceDescriptor descriptor) {
        this.mm_encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.addNamespaceDeclaration("wn0", "http://schemas.xmlsoap.org/soap/encoding/");
        this.addNamespaceDeclaration("wn1", "http://www.w3.org/2001/XMLSchema");
        this.addNamespaceDeclaration("wn2", "http://www.w3.org/2000/10/XMLSchema");
        this.addNamespaceDeclaration("wn3", "http://www.w3.org/1999/XMLSchema");
        this.addNamespaceDeclaration("wn4", nameSpace);
        this.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.mm_descriptor = descriptor;
    }

    public SOAPMessageContext(SOAPElement element, IServiceDescriptor descriptor) {
        this.initNamespace(element);
        this.mm_descriptor = descriptor;
    }

    public SOAPMessageContext(SOAPElement element, ISOAPMessageContext context) {
        this.mm_parent = context;
        this.initNamespace(element);
    }

    public SOAPMessageContext(ISOAPMessageContext context) {
        this.mm_parent = context;
    }

    private void initNamespace(SOAPElement element) {
        if (element.getEncodingStyle() != null && !element.getEncodingStyle().trim().equals("")) {
            this.mm_encodingStyle = element.getEncodingStyle();
        }
        Iterator iter = element.getNamespacePrefixes();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (prefix == null) {
                throw new SOAPServiceException("A prefix of the " + element.getElementName() + " element is null \n" + element);
            }
            String uri = element.getNamespaceURI(prefix);
            this.mm_listOfMappingNamespace.put(prefix, uri);
            this.mm_listOfPrefix.put(uri, prefix);
        }
        Name elementName = element.getElementName();
        if (elementName.getPrefix() != null && !elementName.getPrefix().trim().equals("") && this.mm_listOfPrefix.get(elementName.getPrefix()) == null) {
            this.mm_listOfMappingNamespace.put(elementName.getPrefix(), elementName.getURI());
            this.mm_listOfPrefix.put(elementName.getURI(), elementName.getPrefix());
        }
    }

    public void addMultirefValues(SOAPBodyElement bodyElement) {
        Iterator iterator = bodyElement.getAllAttributes();
        String key = "";
        while (iterator.hasNext()) {
            Name attribute = (Name)iterator.next();
            if (!attribute.getLocalName().equals("id")) continue;
            key = bodyElement.getAttributeValue(attribute);
        }
        this.mm_listOfIds.put(key, bodyElement);
        this.addNamespaceElementInContext((SOAPElement)bodyElement);
    }

    public void addNamespaceElementInContext(SOAPElement element) {
        this.initNamespace(element);
    }

    private String getEncodingStyleDelegate(boolean delegate) {
        String encod = this.mm_encodingStyle;
        if ((encod == null || encod.trim().equals("")) && this.mm_parent != null && delegate) {
            encod = this.mm_parent.getEncodingStyle();
        }
        return encod;
    }

    public String getEncodingStyle() {
        return this.getEncodingStyleDelegate(true);
    }

    public String getEncodingStyleNotDelegate() {
        return this.getEncodingStyleDelegate(false);
    }

    public String getNamespaceFromPrefix(String prefix) {
        String pref = (String)this.mm_listOfMappingNamespace.get(prefix);
        if (pref == null && this.mm_parent != null) {
            pref = this.mm_parent.getNamespaceFromPrefix(prefix);
        }
        return pref;
    }

    public void addNamespaceDeclaration(String prefix, String uri) {
        this.mm_listOfMappingNamespace.put(prefix, uri);
        this.mm_listOfPrefix.put(uri, prefix);
    }

    public String addNamespaceDeclaration(String uri) {
        StringBuffer prefixGenerated = new StringBuffer(mm_prefixGenerated);
        prefixGenerated.append(mm_nbPrefixGenerated);
        while (this.mm_listOfPrefix.containsValue(prefixGenerated.toString())) {
            prefixGenerated.delete(0, prefixGenerated.length());
            prefixGenerated.append(mm_prefixGenerated);
            prefixGenerated.append(++mm_nbPrefixGenerated);
        }
        this.addNamespaceDeclaration(prefixGenerated.toString(), uri);
        return prefixGenerated.toString();
    }

    public void addNamespaceDeclarationInElement(SOAPElement element) throws SOAPServiceException {
        if (this.mm_listOfMappingNamespace != null) {
            Enumeration enumKeys = this.mm_listOfMappingNamespace.keys();
            while (enumKeys.hasMoreElements()) {
                String prefix = (String)enumKeys.nextElement();
                String uri = (String)this.mm_listOfMappingNamespace.get(prefix);
                if (prefix == null || uri == null) continue;
                try {
                    element.addNamespaceDeclaration(prefix, uri);
                }
                catch (Exception e) {
                    throw new PRTFaultEnvelopeVersion((Object)this, e);
                }
            }
        }
    }

    public Enumeration getPrefixes() {
        return this.mm_listOfMappingNamespace.keys();
    }

    public SOAPBodyElement getId(String key) {
        SOAPBodyElement id = (SOAPBodyElement)this.mm_listOfIds.get(key);
        if (id == null && this.mm_parent != null) {
            id = this.mm_parent.getId(key);
        }
        return id;
    }

    public String getPrefixForNamespace(String namespace) {
        return this.getPrefixForNamespace(namespace, false);
    }

    public String getPrefixForNamespace(String namespace, boolean isParent) {
        String namesp = (String)this.mm_listOfPrefix.get(namespace);
        if (namesp == null && this.mm_parent != null) {
            namesp = this.mm_parent.getPrefixForNamespace(namespace, true);
        }
        if (namesp == null && namespace.equals(this.getEncodingStyle())) {
            namesp = "encodingStyle";
            this.mm_listOfMappingNamespace.put("encodingStyle", namespace);
            this.mm_listOfPrefix.put(namespace, "encodingStyle");
        }
        if (namesp == null && !isParent) {
            namesp = this.addNamespaceDeclaration(namespace);
        }
        return namesp;
    }

    public IServiceDescriptor getServiceDescriptor() {
        if (this.mm_descriptor != null) {
            return this.mm_descriptor;
        }
        if (this.mm_parent != null) {
            return this.mm_parent.getServiceDescriptor();
        }
        return null;
    }

    public ISOAPMessageContext getChildSOAPMessageContext(ISOAPMessageContext contextparent, SOAPElement item) {
        return new SOAPMessageContext(item, contextparent);
    }

    public String getValueOfAttribute() {
        return this.mm_valueAttribute;
    }

    public String getDefaultValue() {
        return this.mm_defaultValue;
    }

    public void addValueOfAttribute(String value) {
        this.mm_valueAttribute = value;
    }

    public void addDefaultValue(String value) {
        this.mm_defaultValue = value;
    }

    public boolean isEncodedAsAttribute() {
        return this.mm_encodedAsAttributte;
    }

    public void setEncodedAsAttribute(boolean value) {
        this.mm_encodedAsAttributte = value;
    }

    public boolean isResponse() {
        if (!this.mm_isResponse && this.mm_parent != null) {
            this.mm_isResponse = this.mm_parent.isResponse();
        }
        return this.mm_isResponse;
    }

    public void setResponse(boolean flag) {
        this.mm_isResponse = flag;
    }

    public Object getFaultObjectInstance() {
        if (this.mm_faultObjectInstance == null && this.mm_parent != null && this.mm_parent.getFaultObjectInstance() != null) {
            return this.mm_parent.getFaultObjectInstance();
        }
        return this.mm_faultObjectInstance;
    }

    public void setFaultObjectInstance(Object exception) {
        this.mm_faultObjectInstance = exception;
    }

    public boolean isDocumentStyleEncoding() {
        if (this.mm_documentStyle == null && this.mm_parent != null) {
            return this.mm_parent.isDocumentStyleEncoding();
        }
        return Boolean.valueOf(this.mm_documentStyle);
    }

    public boolean isLitteralStyleEncoding() {
        if (this.mm_litteralStyle == null && this.mm_parent != null) {
            return this.mm_parent.isLitteralStyleEncoding();
        }
        return Boolean.valueOf(this.mm_litteralStyle);
    }

    public String isLitteralStyleEncodingAsked() {
        if (this.mm_dataStyleEncodingAsked == null && this.mm_parent != null) {
            return this.mm_parent.isLitteralStyleEncodingAsked();
        }
        return this.mm_dataStyleEncodingAsked;
    }

    public String getSOAPAction() {
        if (this.mm_soapAction == null && this.mm_parent != null) {
            return this.mm_parent.getSOAPAction();
        }
        return this.mm_soapAction;
    }

    public void setSOAPAction(String value) {
        this.mm_soapAction = value;
    }

    public void setDocumentStyle(boolean value) {
        this.mm_documentStyle = String.valueOf(value);
        if (this.mm_parent != null) {
            ((SOAPMessageContext)this.mm_parent).setDocumentStyle(value);
        }
    }

    public void setLitteralStyle(boolean value) {
        this.mm_litteralStyle = String.valueOf(value);
    }

    public void setdataStyleEncodingAsked(String value) {
        this.mm_dataStyleEncodingAsked = value != null ? String.valueOf(value) : null;
    }

    public MethodContainer getMethodContainer() {
        if (this.mm_method == null && this.mm_parent != null) {
            this.mm_method = this.mm_parent.getMethodContainer();
        }
        return this.mm_method;
    }

    public void setMethodContainer(MethodContainer container) {
        this.mm_method = container;
        if (this.mm_parent != null) {
            ((SOAPMessageContext)this.mm_parent).setMethodContainer(this.mm_method);
        }
    }

    public String getTargetNamespaceMethod() {
        if (this.mm_tnsMethod == null && this.mm_parent != null) {
            return this.mm_parent.getTargetNamespaceMethod();
        }
        return this.mm_tnsMethod;
    }

    public void setTargetNamespaceMethod(String value) {
        this.mm_tnsMethod = value;
        if (this.mm_parent != null) {
            ((SOAPMessageContext)this.mm_parent).setTargetNamespaceMethod(this.mm_tnsMethod);
        }
    }

    public String getArrayChildsName() {
        return this.mm_arrayChildsName;
    }

    public void setArrayChildsName(String name) {
        this.mm_arrayChildsName = name;
    }

    public boolean isArrayList() {
        return this.mm_arrayListType;
    }

    public void setArrayList(boolean value) {
        this.mm_arrayListType = value;
    }

    public boolean isSimpleTypeCurrentProcess() {
        return this.mm_simpleType;
    }

    public void setSimpleTypeCurrentProcess(boolean value) {
        this.mm_simpleType = value;
    }
}

