/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sapportals.portal.prt.connection.UMHandler;
import com.sapportals.portal.prt.dispatcher.IDispatcherContext;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.IService;
import com.sapportals.portal.prt.service.IServiceContext;
import com.sapportals.portal.prt.service.soap.ISOAPConnection;
import com.sapportals.portal.prt.service.soap.ISOAPService;
import com.sapportals.portal.prt.service.soap.SOAPMessageContext;
import com.sapportals.portal.prt.service.soap.SOAPServiceManager;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.exception.SoapFaultHandler;
import com.sapportals.portal.prt.service.soap.log.SOAPLogger;
import com.sapportals.portal.prt.service.soap.security.ISOAPSecurityManager;
import com.sapportals.portal.prt.session.IUserContext;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPConnection
extends UMHandler
implements ISOAPConnection {
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_XML = "text/xml";
    protected MessageFactory msgFactory = null;
    private IServiceContext mm_serviceContext;

    public SOAPConnection() {
        try {
            this.msgFactory = MessageFactory.newInstance();
        }
        catch (Throwable soapexception) {
            throw new SOAPServiceException("Unable to create message factory" + soapexception.getMessage());
        }
    }

    public SOAPConnection(IServiceContext contextService) {
        this.mm_serviceContext = contextService;
        try {
            this.msgFactory = MessageFactory.newInstance();
        }
        catch (Throwable soapexception) {
            throw new SOAPServiceException("Unable to create message factory" + soapexception.getMessage());
        }
    }

    private String getURLProtocol(String URL2) {
        try {
            URL url_ = new URL(URL2);
            return url_.getProtocol();
        }
        catch (MalformedURLException e) {
            return "http";
        }
    }

    public boolean acceptRequest(IDispatcherContext context) {
        return true;
    }

    public void handleRequest(IDispatcherContext context) throws Exception {
        IUserContext userCtxt;
        block15: {
            userCtxt = null;
            try {
                userCtxt = this.handleUM(context);
            }
            catch (Exception ex) {
                SOAPLogger logger = SOAPLogger.getInstance();
                if (logger == null) break block15;
                logger.writeInfo((Object)this, "SOAP Connection Security failed", ex);
            }
        }
        ISOAPSecurityManager securityManager = ((ISOAPService)this.mm_serviceContext.getService("com.sap.portal.runtime.application.soap.soap")).getSecurityManager();
        HttpServletResponse response = context.getServletResponse();
        HttpServletRequest request = context.getServletRequest();
        if (securityManager.isAuthorizedRequest(request)) {
            block16: {
                try {
                    String requestURI = request.getRequestURI();
                    if (request.getMethod().equals("GET")) {
                        String serviceName = this.getServicePortWSDL(context);
                        String valueStyle = request.getParameter("style");
                        if (valueStyle == null || valueStyle.length() <= 1) {
                            valueStyle = "rpc_enc";
                        }
                        IService service = null;
                        try {
                            service = PortalRuntime.getRuntimeResources().getService(serviceName);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        String wsdlfile = null;
                        String extraInfo = this.getExtraInfoWSDL(context);
                        if (extraInfo == null) {
                            wsdlfile = service != null ? SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), serviceName, valueStyle) : SOAPServiceManager.getInstance().getPathFileWSDLService(this.mm_serviceContext, serviceName, valueStyle);
                        } else {
                            int indexServiceName = requestURI.indexOf(serviceName);
                            requestURI = requestURI.substring(0, indexServiceName) + serviceName;
                            wsdlfile = service != null ? service.getContext().getPrivateServicePath() + File.separator + extraInfo : this.mm_serviceContext.getPrivateServicePath() + File.separator + extraInfo;
                        }
                        if (wsdlfile != null) {
                            this.displayWSDLFile(response, request, requestURI, serviceName, valueStyle, service, wsdlfile);
                        } else {
                            response.setStatus(404);
                        }
                        break block16;
                    }
                    this.processSOAPPost(context, userCtxt, securityManager, response, request);
                }
                catch (Exception exception) {
                    response.setStatus(500);
                    this.sendErrorMessage(request, response, exception);
                }
                catch (Throwable e) {
                    response.setStatus(500);
                    this.sendErrorMessage(request, response, e);
                }
            }
            PRTFault.releasePRTFaultContextServerSide();
        } else {
            response.setStatus(403);
        }
        PRTFault.releasePRTFaultContextServerSide();
    }

    private void processSOAPPost(IDispatcherContext context, IUserContext userCtxt, ISOAPSecurityManager securityManager, HttpServletResponse response, HttpServletRequest request) throws IllegalAccessError {
        try {
            MimeHeaders mimeheaders = SOAPConnection.getHeaders(request);
            String serviceName = this.getServicePort(context);
            try {
                if (!securityManager.isAuthorizedUserForService(userCtxt, serviceName)) {
                    throw new IllegalAccessError("The User Authentification is not correct to access to the Portal Service " + serviceName);
                }
            }
            catch (SOAPServiceException exception) {
                throw new IllegalAccessError("The User Authentification is not correct to access to the Portal Service " + serviceName + " or the service was not found.");
            }
            ServletInputStream servletinputstream = request.getInputStream();
            SOAPMessageContext.resetPrefixGenerated();
            SOAPMessage reqSoapMessage = this.msgFactory.createMessage(mimeheaders, (InputStream)servletinputstream);
            SOAPMessage resSoapMessage = null;
            IPRTSOAPResponse prtResSoapMessage = null;
            SOAPServiceManager myConsumer = SOAPServiceManager.getInstance();
            String style = request.getParameter("style");
            String soapaction = null;
            boolean style_encoding_document = false;
            String data_encoding_literal = null;
            if (style != null) {
                if (style.equals("doc_lit")) {
                    style_encoding_document = true;
                    soapaction = request.getHeader("soapaction");
                    if (soapaction.charAt(0) == '\"' && soapaction.charAt(soapaction.length() - 1) == '\"') {
                        soapaction = soapaction.substring(1, soapaction.length() - 1);
                    }
                    data_encoding_literal = "true";
                }
                if (style.equals("rpc_lit")) {
                    style_encoding_document = false;
                    data_encoding_literal = "true";
                }
                if (style.equals("rpc_enc")) {
                    style_encoding_document = false;
                    data_encoding_literal = "false";
                }
            }
            if ((prtResSoapMessage = myConsumer.consumeSOAPMessage(serviceName, reqSoapMessage, this.mm_serviceContext, userCtxt, context, style_encoding_document, data_encoding_literal, soapaction)) != null) {
                resSoapMessage = prtResSoapMessage.getSOAPMessageResponse();
                securityManager.securedResponse(response);
                if (resSoapMessage.saveRequired()) {
                    resSoapMessage.saveChanges();
                }
                response.setStatus(200);
                Enumeration cookies = prtResSoapMessage.getCookies();
                while (cookies.hasMoreElements()) {
                    Cookie element = (Cookie)cookies.nextElement();
                    response.addCookie(element);
                }
                response.setContentType(CONTENT_TYPE_XML);
                ServletOutputStream servletoutputstream = response.getOutputStream();
                resSoapMessage.writeTo((OutputStream)servletoutputstream);
                servletoutputstream.flush();
            } else {
                response.setStatus(204);
            }
        }
        catch (Exception ex) {
            response.setStatus(500);
            this.sendErrorMessage(request, response, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void displayWSDLFile(HttpServletResponse response, HttpServletRequest request, String requestURI, String serviceName, String valueStyle, IService service, String wsdlfile) throws IOException, FileNotFoundException {
        wsdlfile = new File(wsdlfile).getCanonicalPath();
        response.setStatus(200);
        response.setContentType(CONTENT_TYPE_XML);
        ServletOutputStream servletoutputstream = response.getOutputStream();
        ByteArrayOutputStream wsdlContentStream = new ByteArrayOutputStream(wsdlfile.length());
        PrintStream wsdlStream = new PrintStream(wsdlContentStream, true);
        BufferedReader inWsdl = new BufferedReader(new FileReader(wsdlfile));
        try {
            try {
                RecyclableStringBuffer data_buffer = new RecyclableStringBuffer();
                String data_temp = "";
                boolean endline = false;
                while (true) {
                    if (data_temp == null) {
                        servletoutputstream.println(wsdlContentStream.toString());
                        break;
                    }
                    data_temp = inWsdl.readLine();
                    if (data_temp != null && data_temp.indexOf(">") != -1) {
                        endline = true;
                        data_buffer.getBuffer().append(data_temp);
                    } else if (data_temp != null) {
                        data_buffer.getBuffer().append(data_temp);
                    } else {
                        data_temp = null;
                    }
                    if (!endline) continue;
                    String data = data_buffer.getBuffer().toString();
                    if (data.indexOf(":address") != -1 || data.indexOf("<address") != -1) {
                        try {
                            int start = data.indexOf("location=\"") + 10;
                            int end = data.indexOf("\"", start);
                            String urls = data.substring(start, end);
                            URL url = new URL(urls);
                            urls = this.getURLProtocol(request.getRequestURL().toString()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getRequestURI() + "?" + this.addURLParameterInResponse(url.getQuery(), "style", valueStyle);
                            wsdlStream.print(data.substring(0, data.indexOf(":address")));
                            wsdlStream.print(":address location=\"" + urls + "\"/>");
                        }
                        catch (Exception e1) {
                            String url = this.getURLProtocol(request.getRequestURL().toString()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getRequestURI();
                            wsdlStream.print(data.substring(0, data.indexOf(":address")));
                            wsdlStream.print(":address location=\"" + url + "?style=rpc_enc\"/>");
                        }
                    } else if (data.indexOf(":import") != -1 || data.indexOf("<import") != -1) {
                        String keyLocation = data.indexOf("schemaLocation") != -1 ? "schemaLocation" : "location";
                        int startIndexData = data.lastIndexOf(keyLocation + "=\"");
                        int starturl = data.indexOf("\"", startIndexData + 1);
                        int endurl = data.indexOf("\"", starturl + 1);
                        String urlData = data.substring(starturl + 1, endurl);
                        String beforeUrl = data.substring(0, starturl + 1);
                        String afterUrl = data.substring(endurl);
                        String newUrl = null;
                        if (urlData.indexOf("http") >= 0 || urlData.indexOf("HTTP") >= 0 || urlData.indexOf("https") >= 0 || urlData.indexOf("HTTPS") >= 0) {
                            newUrl = urlData;
                        } else {
                            String rootWsdl;
                            String pathRootWSDL = null;
                            if (service != null) {
                                rootWsdl = null;
                                rootWsdl = SOAPServiceManager.getInstance().getPathFileWSDLService(service.getContext(), serviceName, valueStyle);
                                pathRootWSDL = new File(rootWsdl).getParent();
                                pathRootWSDL = !pathRootWSDL.equals(service.getContext().getPrivateServicePath()) ? pathRootWSDL.substring(pathRootWSDL.lastIndexOf(File.separator), pathRootWSDL.length()) : "-1";
                            } else {
                                rootWsdl = null;
                                rootWsdl = SOAPServiceManager.getInstance().getPathFileWSDLService(this.mm_serviceContext, serviceName, valueStyle);
                                pathRootWSDL = new File(rootWsdl).getParent();
                                pathRootWSDL = !pathRootWSDL.equals(service.getContext().getPrivateServicePath()) ? pathRootWSDL.substring(pathRootWSDL.lastIndexOf(File.separator), pathRootWSDL.length()) : "-1";
                            }
                            if (urlData.charAt(0) == '/' || urlData.charAt(0) == '\\') {
                                String realPath = "." + pathRootWSDL + File.separator + urlData;
                                realPath = this.normalizePath(realPath);
                                newUrl = this.getURLProtocol(urlData) + "://" + request.getServerName() + ":" + request.getServerPort() + requestURI + "?wsdl=" + realPath;
                            } else {
                                String urlOld;
                                File root = new File(wsdlfile);
                                String path = root.getParent();
                                path = path.substring(path.lastIndexOf(File.separator), path.length());
                                String realPath = "";
                                if (!pathRootWSDL.equals("-1")) {
                                    realPath = "." + wsdlfile.substring(wsdlfile.indexOf(pathRootWSDL), wsdlfile.indexOf(path));
                                    realPath = realPath + path + File.separator + urlData;
                                } else {
                                    realPath = realPath + urlData;
                                }
                                realPath = this.normalizePath(realPath);
                                newUrl = urlOld = this.getURLProtocol(urlData) + "://" + request.getServerName() + ":" + request.getServerPort() + requestURI + "?wsdl=" + realPath;
                            }
                        }
                        wsdlStream.print(beforeUrl + newUrl + afterUrl);
                    } else {
                        wsdlStream.print(data);
                    }
                    endline = false;
                    data_buffer.realloc(8000);
                }
            }
            catch (Exception error) {
                SOAPLogger logger = SOAPLogger.getInstance();
                if (logger != null) {
                    logger.writeInfo((Object)this, "Operation failed", error);
                }
                Object var30_37 = null;
                servletoutputstream.flush();
                response.flushBuffer();
                inWsdl.close();
                wsdlStream.close();
                return;
            }
            Object var30_36 = null;
        }
        catch (Throwable throwable) {
            Object var30_38 = null;
            servletoutputstream.flush();
            response.flushBuffer();
            inWsdl.close();
            wsdlStream.close();
            throw throwable;
        }
        servletoutputstream.flush();
        response.flushBuffer();
        inWsdl.close();
        wsdlStream.close();
    }

    private String addURLParameterInResponse(String query, String key, String value) {
        String queryReturn = "";
        if (query == null || query.length() == 0) {
            queryReturn = key + "=" + value;
            return queryReturn;
        }
        if (query.indexOf(key) != -1) {
            int ind = query.indexOf(key) + key.length() + 1;
            queryReturn = query.substring(0, ind);
            queryReturn = queryReturn + value;
            if (query.indexOf("&", ind) != -1) {
                queryReturn = queryReturn + query.substring(query.indexOf("&", ind), query.length());
            }
        } else {
            queryReturn = query;
            queryReturn = queryReturn + "&" + key + "=" + value;
        }
        return queryReturn;
    }

    private String normalizePath(String realPath) throws IOException {
        String path = new File("/" + realPath).getCanonicalPath();
        path = path.substring(path.indexOf(File.separator) + 1, path.length());
        return path;
    }

    private void sendErrorMessage(HttpServletRequest request, HttpServletResponse response, Throwable ex) {
        try {
            if (request.getContentType() == null || request.getContentType().equals(CONTENT_TYPE_HTML)) {
                response.setContentType(CONTENT_TYPE_HTML);
                ServletOutputStream servletoutputstream = response.getOutputStream();
                this.displayHtmlErrorMessage(ex, (OutputStream)servletoutputstream);
                servletoutputstream.flush();
            } else {
                response.setContentType(CONTENT_TYPE_XML);
                ServletOutputStream servletoutputstream = response.getOutputStream();
                SOAPMessage fault = null;
                fault = ex instanceof PRTFault ? ((PRTFault)ex).getMsgFault() : SoapFaultHandler.getInstance().consumeSOAPPRTMessageFault(ex);
                fault.writeTo((OutputStream)servletoutputstream);
                servletoutputstream.flush();
            }
        }
        catch (IOException ioex) {
        }
        catch (SOAPException soapex) {
            // empty catch block
        }
    }

    private void sendErrorMessage(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        try {
            if (request.getContentType() == null || request.getContentType().equals(CONTENT_TYPE_HTML)) {
                response.setContentType(CONTENT_TYPE_HTML);
                ServletOutputStream servletoutputstream = response.getOutputStream();
                this.displayHtmlErrorMessage(ex, (OutputStream)servletoutputstream);
                servletoutputstream.flush();
            } else {
                response.setContentType(CONTENT_TYPE_XML);
                ServletOutputStream servletoutputstream = response.getOutputStream();
                SOAPMessage fault = null;
                fault = ex instanceof PRTFault ? ((PRTFault)((Object)ex)).getMsgFault() : SoapFaultHandler.getInstance().consumeSOAPPRTMessageFault((Throwable)ex);
                if (fault != null) {
                    fault.writeTo((OutputStream)servletoutputstream);
                }
                servletoutputstream.flush();
            }
        }
        catch (IOException ioex) {
        }
        catch (SOAPException soapex) {
            // empty catch block
        }
    }

    private void displayHtmlErrorMessage(Exception ex, OutputStream out) {
        try {
            StringBuffer content = new StringBuffer("<html><head><title ></title><meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">");
            content.append("<table  style='border: 1px solid black;' border=\"1\" cellpadding=\"5\" cellspacing=\"0\" bordercolor=\"#333333\">");
            content.append("<tr><td ><h2><font color=\"#003399\">Portal Runtime Error</font></h2>");
            content.append("An exception occurred while processing a request for :<br>iView : N/A<br>");
            content.append("Component name : SOAP Application<br> <br>");
            content.append("Component Error: com.sapportals.portal.prt.service.soap.SOAPConnection<br><br>");
            content.append("</td></tr><tr><td bgcolor=\"#CCCCCC\"> Short description: " + ex.toString());
            content.append("</td></tr><tr><td><br> &copy; Copyright 2002 SAP AG. All rights reserved.</td>");
            content.append("</tr></table><pre style='display:none;'>");
            out.write(content.toString().getBytes());
            ex.printStackTrace(new PrintStream(out));
            out.write("</pre></body></html>".getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void displayHtmlErrorMessage(Throwable ex, OutputStream out) {
        try {
            StringBuffer content = new StringBuffer("<html><head><title ></title><meta HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=ISO-8859-1\">");
            content.append("<table  style='border: 1px solid black;' border=\"1\" cellpadding=\"5\" cellspacing=\"0\" bordercolor=\"#333333\">");
            content.append("<tr><td ><h2><font color=\"#003399\">Portal Runtime Error</font></h2>");
            content.append("An exception occurred while processing a request for :<br>iView : N/A<br>");
            content.append("Component name : SOAP Application<br> <br>");
            content.append("Component Error: com.sapportals.portal.prt.service.soap.SOAPConnection<br><br>");
            content.append("</td></tr><tr><td bgcolor=\"#CCCCCC\"> Short description: " + ex.toString());
            content.append("</td></tr><tr><td><br> &copy; Copyright 2002 SAP AG. All rights reserved.</td>");
            content.append("</tr></table><pre style='display:none;'>");
            out.write(content.toString().getBytes());
            ex.printStackTrace(new PrintStream(out));
            out.write("</pre></body></html>".getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static MimeHeaders getHeaders(HttpServletRequest httpservletrequest) {
        Enumeration enumeration = httpservletrequest.getHeaderNames();
        MimeHeaders mimeheaders = new MimeHeaders();
        String s = null;
        String s1 = null;
        while (enumeration.hasMoreElements()) {
            s = (String)enumeration.nextElement();
            s1 = httpservletrequest.getHeader(s);
            try {
                if (s == null || s1 == null || s.length() < 1 || s1.length() < 1) continue;
                mimeheaders.addHeader(s, s1);
            }
            catch (IllegalArgumentException e) {
                SOAPLogger logger = SOAPLogger.getInstance();
                if (logger == null) continue;
                logger.writeInfo(null, e.toString(), e);
            }
        }
        return mimeheaders;
    }

    protected static void putHeaders(MimeHeaders mimeheaders, HttpServletResponse httpservletresponse) {
        MimeHeader mimeheader = null;
        Iterator iterator = mimeheaders.getAllHeaders();
        while (iterator.hasNext()) {
            mimeheader = (MimeHeader)iterator.next();
            httpservletresponse.setHeader(mimeheader.getName(), mimeheader.getValue());
        }
    }

    public String getConnectionName() {
        return "soap";
    }

    public MessageFactory getMsgFactory() {
        return this.msgFactory;
    }

    private String getServicePort(IDispatcherContext context) {
        String servicePort = context.getConnectionPathInfo().substring(1);
        if (servicePort.indexOf("/") != -1) {
            throw new SOAPServiceException("mal formed port service");
        }
        return servicePort;
    }

    private String getServicePortWSDL(IDispatcherContext context) {
        String servicePort = context.getConnectionPathInfo().substring(1);
        if (servicePort.indexOf("/") != -1) {
            return servicePort.substring(0, servicePort.indexOf("/"));
        }
        return servicePort;
    }

    private String getExtraInfoWSDL(IDispatcherContext context) {
        String wsdl = context.getServletRequest().getParameter("wsdl");
        return wsdl;
    }
}

