/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sapportals.portal.prt.service.soap.IPRTSOAPSerializator;
import com.sapportals.portal.prt.service.soap.IServiceDescriptor;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPResponse;
import com.sapportals.portal.prt.service.soap.element.PRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.SOAPServiceException;
import com.sapportals.portal.prt.service.soap.util.IMessageDescriptor;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class PRTSOAPSerializator
implements IPRTSOAPSerializator {
    private static PRTSOAPSerializator mm_instance = null;

    static PRTSOAPSerializator getInstance() {
        if (mm_instance != null) {
            return mm_instance;
        }
        mm_instance = new PRTSOAPSerializator();
        return mm_instance;
    }

    public static void destroy() {
        mm_instance = null;
    }

    public SOAPMessage constructSOAPMessage(MessageFactory messageFactory, IPRTSOAPResponse response) {
        return this.constructSOAPMessage(messageFactory, response, null, response.getMessage().getEnveloppe().getMainContext().getServiceDescriptor());
    }

    public SOAPMessage constructSOAPMessage(MessageFactory messageFactory, IMessageDescriptor descriptor, IServiceDescriptor sDescriptor) {
        return this.constructSOAPMessage(messageFactory, null, descriptor, sDescriptor);
    }

    private SOAPMessage constructSOAPMessage(MessageFactory messageFactory, IPRTSOAPResponse response, IMessageDescriptor descriptor, IServiceDescriptor serviceDescriptor) throws SOAPServiceException {
        try {
            SOAPMessage msg = messageFactory.createMessage();
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            header.detachNode();
            SOAPPart sp = msg.getSOAPPart();
            Object prtMessage = null;
            prtMessage = response != null ? response.getMessage() : new PRTSOAPMessage(descriptor, serviceDescriptor);
            prtMessage.marshall(sp);
            return msg;
        }
        catch (SOAPServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PRTFaultInternalError((Object)this, e);
        }
    }
}

