/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.soap.IPRTSOAPCall;
import com.sapportals.portal.prt.service.soap.IPRTSOAPSerializator;
import com.sapportals.portal.prt.service.soap.ISOAPService;
import com.sapportals.portal.prt.service.soap.IServiceDescriptor;
import com.sapportals.portal.prt.service.soap.SOAPParameter;
import com.sapportals.portal.prt.service.soap.SOAPServiceManager;
import com.sapportals.portal.prt.service.soap.ServiceDescriptor;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBody;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPBodyElement;
import com.sapportals.portal.prt.service.soap.element.IPRTSOAPMessage;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.processor.MethodContainer;
import com.sapportals.portal.prt.service.soap.util.CookiesUtils;
import com.sapportals.portal.prt.service.soap.util.IMessageDescriptor;
import com.sapportals.portal.prt.service.soap.util.MessageDescriptor;
import com.sapportals.portal.prt.service.soap.util.ToolKit;
import com.sapportals.portal.prt.service.soap.util.XMLAttributeHandler;
import com.sapportals.portal.prt.service.soap.webserviceconfig.description.IPortalWebServiceMethod;
import com.sapportals.portal.prt.session.IUserContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;

public class PRTSOAPCall
implements IPRTSOAPCall {
    private String mm_url = null;
    private String mm_tnsURI = null;
    private String mm_nameService = null;
    private CookiesUtils mm_cookiesHandler = null;
    private ISOAPService mm_service = null;
    private MimeHeaders mm_headersResponse = null;
    private HashMap mm_httpheaders = null;
    private IPRTSOAPSerializator mm_serializator = null;
    private IPRTSOAPMessage mm_response = null;
    private Object[] mm_cookiesExtractedFromLastSOAPRequest = null;

    public PRTSOAPCall(String url, String serviceName, String tns_nameSpaceURI, ISOAPService soapService) {
        this.mm_service = soapService;
        this.mm_url = url;
        this.mm_nameService = serviceName;
        this.mm_tnsURI = tns_nameSpaceURI;
        this.mm_serializator = this.mm_service.getSerializator();
    }

    public PRTSOAPCall(HashMap httpheaders, String url, String serviceName, String tns_nameSpaceURI, ISOAPService soapService) {
        this.mm_httpheaders = httpheaders;
        this.mm_service = soapService;
        this.mm_url = url;
        this.mm_nameService = serviceName;
        this.mm_tnsURI = tns_nameSpaceURI;
        this.mm_serializator = this.mm_service.getSerializator();
    }

    public Object invokeMethod(String methodName, XMLAttributeHandler params, String namespaceURI) throws PRTFault {
        return this.invokeMethod(methodName, params, namespaceURI, null, null);
    }

    private SOAPMessage generateMessage(IMessageDescriptor descriptor, IServiceDescriptor serviceDescriptor) {
        SOAPMessage message = this.mm_serializator.constructSOAPMessage(this.mm_service.getMsgFactory(), descriptor, serviceDescriptor);
        return message;
    }

    private Object translate(IPRTSOAPMessage msg, String namemethod, String returnParamName) {
        try {
            SOAPParameter response;
            IPRTSOAPBody bdy = msg.getEnveloppe().getBody();
            Hashtable listBody = bdy.getListOfBodyElements();
            IPRTSOAPBodyElement bdyElement = null;
            XMLAttributeHandler xmlhandler = null;
            bdyElement = (IPRTSOAPBodyElement)listBody.get(namemethod + "Response");
            if (bdyElement != null && (xmlhandler = bdyElement.getAttributeHandler()) != null) {
                response = xmlhandler.getAttributeValue("response");
                if (response != null) {
                    return response.getValue();
                }
                response = xmlhandler.getAttributeValue("return");
                if (response != null) {
                    return response.getValue();
                }
                if (xmlhandler.getAttributesName().hasMoreElements()) {
                    String name = (String)xmlhandler.getAttributesName().nextElement();
                    response = xmlhandler.getAttributeValue(name);
                    return response.getValue();
                }
            }
            if (returnParamName != null && listBody.get(returnParamName) != null) {
                bdyElement = (IPRTSOAPBodyElement)listBody.get(returnParamName);
                xmlhandler = bdyElement.getAttributeHandler();
                response = xmlhandler.getAttributeValue(returnParamName);
                return response.getValue();
            }
        }
        catch (Exception ex) {
            ILogger logger = PortalRuntime.getLogger();
            if (logger != null && logger.isActive()) {
                logger.warning((Throwable)ex, this.getClass().getName() + " ERROR : Translate failed");
            }
            return null;
        }
        return null;
    }

    public void addCookie(Object cookie) {
        if (cookie != null) {
            if (this.mm_cookiesHandler == null) {
                this.mm_cookiesHandler = new CookiesUtils();
            }
            this.mm_cookiesHandler.addCookie((Cookie)cookie);
        }
    }

    private HashMap addCookieSignature(HashMap httpheaders) {
        if (this.mm_cookiesHandler != null) {
            httpheaders.put("cookie", this.mm_cookiesHandler.getFormattedListCookies());
        }
        return httpheaders;
    }

    public IPRTSOAPMessage getMessageResponse() {
        return this.mm_response;
    }

    public Object invokeMethod(String methodName, XMLAttributeHandler params, String namespaceURI, IUserContext user, String systemAlias) {
        Object result = null;
        try {
            MessageDescriptor descriptor = new MessageDescriptor(methodName, params, namespaceURI == null ? this.mm_tnsURI : namespaceURI);
            ServiceDescriptor serviceDescriptor = new ServiceDescriptor(this.mm_nameService, SOAPServiceManager.getInstance().getSpecializedRegistry(this.mm_nameService, this.mm_service.getContext()));
            this.addCookieSignature(this.mm_httpheaders);
            IPortalWebServiceMethod method = ToolKit.getportalWebServicemethod(this.mm_nameService, methodName, params);
            if (method == null) {
                throw new IllegalStateException("Error in soapconfig.xml: The method " + methodName + " of " + this.mm_nameService + " portal service is not found.");
            }
            descriptor.setConfigMethod(method);
            SOAPMessage message = this.generateMessage(descriptor, serviceDescriptor);
            if (this.mm_httpheaders != null && !this.mm_httpheaders.isEmpty()) {
                Iterator iter = this.mm_httpheaders.keySet().iterator();
                while (iter.hasNext()) {
                    Object item = iter.next();
                    Object value = this.mm_httpheaders.get(item);
                    message.getMimeHeaders().addHeader((String)item, (String)value);
                }
            }
            message.getSOAPPart().getEnvelope().addNamespaceDeclaration("tns", this.mm_tnsURI);
            IPRTSOAPMessage prtMessage = this.mm_service.call(message, this.mm_url, (IServiceDescriptor)serviceDescriptor, user, systemAlias);
            MethodContainer mc = new MethodContainer();
            mc.setWebserviceMethod_config(method);
            serviceDescriptor.getContextRequest().setMethodContainer(mc);
            this.mm_cookiesExtractedFromLastSOAPRequest = prtMessage.getCookies();
            this.mm_response = prtMessage;
            String return_nameparam = null;
            return_nameparam = method.getStyleEnconding() == 1 ? (method.getReturnPortalWebServiceParameter() != null ? method.getReturnPortalWebServiceParameter().getNameElement() : null) : (method.getReturnPortalWebServiceParameter() != null ? method.getReturnPortalWebServiceParameter().getName() : null);
            result = this.translate(prtMessage, methodName, return_nameparam);
        }
        catch (Exception ex) {
            if (ex instanceof PRTFault) {
                throw (PRTFault)((Object)ex);
            }
            throw new PRTFaultInternalError((Object)this, ex);
        }
        return result;
    }

    public Object[] getCookiesContainInResponse() {
        return this.mm_cookiesExtractedFromLastSOAPRequest;
    }

    public void clearCookies() {
        this.mm_cookiesHandler = null;
    }

    public Object[] getCookiesContainInRequest() {
        if (this.mm_cookiesHandler == null) {
            return null;
        }
        Collection col = this.mm_cookiesHandler.getAllCookies();
        Object[] array = new Cookie[col.size()];
        Iterator iter = col.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Cookie element = (Cookie)iter.next();
            array[count++] = element;
        }
        return array;
    }
}

