/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.logging.Logger;

public class SplitOutputStream
extends OutputStream {
    private int BUFSIZE = 0x100000;
    private long LIMIT = 0x80000000L;
    private byte[] buffer = new byte[this.BUFSIZE];
    private int used = 0;
    private int seqNr = 0;
    private String baseName;
    private String fileName;
    private RandomAccessFile fout = null;
    private String mode = "rw";
    private long written = 0L;
    private long size = 0L;
    private byte[] intb = new byte[1];
    private static Logger logger = Logger.getLogger("com.sap.inst.jload.io");

    public SplitOutputStream(String baseName) throws FileNotFoundException {
        this(baseName, "rw");
    }

    public SplitOutputStream(String baseName, String mode) throws FileNotFoundException {
        this.baseName = baseName;
        this.mode = mode;
        this.fileName = this.getNextFileName();
        this.fout = new RandomAccessFile(this.fileName, mode);
    }

    public SplitOutputStream(String baseName, int seqNr, long offset) throws IOException {
        this.baseName = baseName;
        this.mode = "rw";
        this.seqNr = seqNr - 1;
        this.written = offset;
        this.fileName = this.getNextFileName();
        this.fout = new RandomAccessFile(this.fileName, this.mode);
        this.fout.seek(offset);
    }

    private String getNextFileName() {
        logger.entering("com.sap.inst.jload.io.SplitOutputStream", "getNextFileName");
        DecimalFormat f = new DecimalFormat("000");
        ++this.seqNr;
        this.fileName = this.baseName + "." + f.format(this.seqNr);
        logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "getNextFileName");
        return this.fileName;
    }

    private void switchFile() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitOutputStream", "switchFile");
        this.fout.close();
        this.fileName = this.getNextFileName();
        this.fout = new RandomAccessFile(this.fileName, this.mode);
        this.written = 0L;
        logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "switchFile");
    }

    public void setMaxFileSize(int megaBytes) {
        this.LIMIT = (long)(megaBytes * 1024) * 1024L;
    }

    public long size() {
        long temp = this.size;
        this.size = 0L;
        return temp;
    }

    public MappedByteBuffer requestMappedByteBuffer(int length) throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitOutputStream", "requestMappedByteBuffer");
        this.flush();
        if ((long)length > this.LIMIT - this.written) {
            this.switchFile();
        }
        FileChannel channel = this.fout.getChannel();
        channel.force(false);
        long offset = channel.position();
        MappedByteBuffer mb = channel.map(FileChannel.MapMode.READ_WRITE, offset, length);
        channel.position(offset + (long)length);
        this.written += (long)length;
        logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "requestMappedByteBuffer");
        return mb;
    }

    public void close() throws IOException {
        this.flush();
    }

    public void finish() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitOutputStream", "finish");
        this.flush();
        this.fout.close();
        this.fout = null;
        logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "finish");
    }

    public void flush() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitOutputStream", "flush");
        if (this.used == 0) {
            logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "flush");
            return;
        }
        if (this.written + (long)this.used < this.LIMIT) {
            this.fout.write(this.buffer, 0, this.used);
            this.written += (long)this.used;
        } else {
            int first = (int)(this.LIMIT - this.written);
            int second = this.used - first;
            if (first != 0) {
                this.fout.write(this.buffer, 0, first);
            }
            this.switchFile();
            if (second != 0) {
                this.fout.write(this.buffer, first, second);
            }
            this.written = second;
        }
        this.used = 0;
        logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "flush");
    }

    public void write(int b) throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitOutputStream", "write(int)");
        this.intb[0] = (byte)b;
        this.write(this.intb, 0, 1);
        logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "write(int)");
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitOutputStream", "write(byte[])");
        this.size += (long)len;
        if (len < this.BUFSIZE - this.used) {
            System.arraycopy(b, off, this.buffer, this.used, len);
            this.used += len;
        } else {
            if (this.used < this.BUFSIZE) {
                System.arraycopy(b, off, this.buffer, this.used, this.BUFSIZE - this.used);
            }
            int from = off + this.BUFSIZE - this.used;
            int rest = len - (this.BUFSIZE - this.used);
            this.used = this.BUFSIZE;
            this.flush();
            while (rest > 0) {
                if (rest > this.BUFSIZE) {
                    System.arraycopy(b, from, this.buffer, 0, this.BUFSIZE);
                    this.used = this.BUFSIZE;
                    from += this.BUFSIZE;
                    rest -= this.BUFSIZE;
                    this.flush();
                    continue;
                }
                System.arraycopy(b, from, this.buffer, 0, rest);
                this.used = rest;
                rest = 0;
            }
        }
        logger.exiting("com.sap.inst.jload.io.SplitOutputStream", "write(byte[])");
    }
}

