/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.logging.Logger;

public class SplitInputStream
extends InputStream {
    private int BUFSIZE = 0x100000;
    private byte[] buffer = new byte[this.BUFSIZE];
    private int limit = 0;
    private int next = 0;
    private int seqNr = 0;
    private boolean noMoreFiles = false;
    private String baseName;
    private String fileName;
    private FileInputStream fin = null;
    private long size;
    private long read = 0L;
    private long streamLength = -1L;
    private static Logger logger = Logger.getLogger("com.sap.inst.jload.io");

    public SplitInputStream(String baseName) throws IOException {
        this.baseName = baseName;
        this.fileName = this.getNextFileName();
        this.fin = new FileInputStream(this.fileName);
        this.getFileSize();
        if (this.size == 0L) {
            throw new IOException("File " + this.fileName + " is empty");
        }
        this.read = 0L;
    }

    private String getNextFileName() {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "getNextFileName");
        DecimalFormat f = new DecimalFormat("000");
        ++this.seqNr;
        this.fileName = this.baseName + "." + f.format(this.seqNr);
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "getNextFileName");
        return this.fileName;
    }

    private long getFileSize() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "getFileSize");
        FileChannel fc = this.fin.getChannel();
        this.size = fc.size();
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "getFileSize");
        return this.size;
    }

    private void switchFile() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "switchFile");
        this.fin.close();
        this.read = 0L;
        this.size = 0L;
        this.fileName = this.getNextFileName();
        try {
            this.fin = new FileInputStream(this.fileName);
            this.getFileSize();
        }
        catch (FileNotFoundException e) {
            this.noMoreFiles = true;
        }
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "switchFile");
    }

    private int fillBuffer() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "fillBuffer");
        if (this.noMoreFiles) {
            logger.exiting("com.sap.inst.jload.io.SplitInputStream", "fillBuffer");
            return -1;
        }
        this.next = 0;
        if (this.read == this.size) {
            this.switchFile();
            if (this.noMoreFiles) {
                this.limit = 0;
                logger.exiting("com.sap.inst.jload.io.SplitInputStream", "fillBuffer");
                return -1;
            }
        }
        this.limit = this.fin.read(this.buffer);
        if (this.limit == -1) {
            throw new IOException("Unexpected end of file " + this.fileName);
        }
        this.read += (long)this.limit;
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "fillBuffer");
        return this.limit;
    }

    public int getSeqNr() {
        return this.seqNr;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFilePosition() {
        return this.read - (long)this.limit + (long)this.next;
    }

    public void setStreamLength(long streamLength) {
        this.streamLength = streamLength;
    }

    public int available() {
        int avl = this.limit - this.next;
        if (avl < 0) {
            avl = 0;
        }
        if (this.streamLength < 0L) {
            return avl;
        }
        return (long)avl > this.streamLength ? (int)this.streamLength : avl;
    }

    public void close() throws IOException {
        if (this.streamLength > 0L) {
            this.skip(this.streamLength);
        }
        this.streamLength = -1L;
    }

    public void finish() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "finish");
        this.fin.close();
        this.fin = null;
        this.size = 0L;
        this.streamLength = -1L;
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "finish");
    }

    public int read() throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "read()");
        if (this.next >= this.limit) {
            this.fillBuffer();
            if (this.noMoreFiles) {
                logger.exiting("com.sap.inst.jload.io.SplitInputStream", "read()");
                return -1;
            }
        }
        if (this.streamLength == 0L) {
            logger.exiting("com.sap.inst.jload.io.SplitInputStream", "read()");
            return -1;
        }
        if (this.streamLength > 0L) {
            --this.streamLength;
        }
        int i = this.buffer[this.next++] & 0xFF;
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "read()");
        return i;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int req) throws IOException {
        return this.read(b, 0, req);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "read(byte[], int, int)");
        if (off + len > b.length) {
            throw new IOException("buffer too small");
        }
        int avl = this.available();
        if (this.streamLength == 0L) {
            logger.exiting("com.sap.inst.jload.io.SplitInputStream", "read(byte[], int, int)");
            return -1;
        }
        if (this.streamLength > 0L && (long)len > this.streamLength) {
            len = (int)this.streamLength;
        }
        if (avl == 0) {
            this.fillBuffer();
            if (this.noMoreFiles) {
                logger.exiting("com.sap.inst.jload.io.SplitInputStream", "read(byte[], int, int)");
                return -1;
            }
            avl = this.available();
        }
        int copied = 0;
        while (len > 0) {
            if (len <= avl) {
                System.arraycopy(this.buffer, this.next, b, off, len);
                this.next += len;
                off += len;
                copied += len;
                this.streamLength -= (long)len;
                len = 0;
                continue;
            }
            System.arraycopy(this.buffer, this.next, b, off, avl);
            len -= avl;
            off += avl;
            copied += avl;
            this.streamLength -= (long)avl;
            this.fillBuffer();
            if (this.noMoreFiles) {
                logger.exiting("com.sap.inst.jload.io.SplitInputStream", "read(byte[], int, int)");
                return copied;
            }
            avl = this.available();
        }
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "read(byte[], int, int)");
        return copied;
    }

    public long skip(long n) throws IOException {
        logger.entering("com.sap.inst.jload.io.SplitInputStream", "skip");
        long skipped = 0L;
        if (n <= (long)this.available()) {
            this.next = (int)((long)this.next + n);
            logger.exiting("com.sap.inst.jload.io.SplitInputStream", "skip");
            return n;
        }
        skipped = this.available();
        this.limit = 0;
        this.next = 0;
        while (skipped < n) {
            if (this.size - this.read < n - skipped) {
                skipped += this.size - this.read;
                this.switchFile();
                if (!this.noMoreFiles) continue;
                throw new IOException("Not enough files, skip(" + n + ") failed ");
            }
            long s = this.fin.skip(n - skipped);
            skipped += s;
            this.read += s;
        }
        logger.exiting("com.sap.inst.jload.io.SplitInputStream", "skip");
        return skipped;
    }
}

