/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class DataFileEntry {
    private String name = null;
    private String comment = null;
    private long rowCount = 0L;
    private long dataLen = 0L;
    private long checkSum = 0L;
    private static Logger logger = Logger.getLogger("com.sap.inst.jload.io");

    public DataFileEntry() {
    }

    public DataFileEntry(ByteBuffer bb) throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFileEntry", "DataFileEntry(ByteBuffer)");
        int nameLen = bb.getInt();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < nameLen; ++i) {
            b.append(bb.getChar());
        }
        this.name = b.toString();
        int commentLen = bb.getInt();
        if (commentLen != 0) {
            b.setLength(0);
            for (int i = 0; i < commentLen; ++i) {
                b.append(bb.getChar());
            }
            this.comment = b.toString();
        }
        this.rowCount = bb.getLong();
        this.dataLen = bb.getLong();
        this.checkSum = bb.getLong();
        logger.exiting("com.sap.inst.jload.io.DataFileEntry", "DataFileEntry(ByteBuffer)");
    }

    public DataFileEntry(String name, String comment) {
        this.name = name;
        this.comment = comment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public String[] getColumns() throws IOException {
        String[] columns;
        if (!this.name.endsWith(":DATA")) {
            return null;
        }
        if (this.comment == null) {
            throw new IOException("Invalid DataFileEntry: " + this.name);
        }
        int end = this.comment.indexOf(" [");
        if (end == -1) {
            end = this.comment.length();
        }
        if ((columns = this.comment.substring(0, end).split(" ")).length < 3 || columns.length % 2 != 0) {
            throw new IOException("Invalid DataFileEntry: " + this.name);
        }
        int numberOfColumns = Integer.parseInt(columns[1]);
        if (columns.length != 2 * numberOfColumns + 2) {
            throw new IOException("Invalid DataFileEntry: " + this.name);
        }
        String[] tabColumns = new String[2 * numberOfColumns];
        for (int i = 0; i < 2 * numberOfColumns; ++i) {
            tabColumns[i] = columns[i + 2];
        }
        return tabColumns;
    }

    public String getWhereClause() throws IOException {
        if (!this.name.endsWith(":DATA")) {
            return null;
        }
        if (this.comment == null) {
            throw new IOException("Invalid DataFileEntry: " + this.name);
        }
        int begin = this.comment.indexOf(" [");
        if (begin == -1) {
            return null;
        }
        int end = this.comment.lastIndexOf(93);
        if (end == -1) {
            throw new IOException("Invalid DataFileEntry: " + this.name);
        }
        String where = this.comment.substring(begin + 2, end);
        return where;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setDataLen(long dataLen) {
        this.dataLen = dataLen;
    }

    public long getDataLen() {
        return this.dataLen;
    }

    public void setChecksum(long checkSum) {
        this.checkSum = checkSum;
    }

    public long getChecksum() {
        return this.checkSum;
    }
}

