/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.io;

import com.sap.inst.jload.DBJob;
import com.sap.inst.jload.io.DataFileEntry;
import com.sap.inst.jload.io.SplitInputStream;
import com.sap.inst.jload.io.SplitOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DataFile {
    private String baseName;
    private String mode;
    private int dataFileSize = 0;
    private SplitInputStream sin = null;
    private SplitOutputStream sout = null;
    private DataInputStream din = null;
    private DataOutputStream dout = null;
    private MappedByteBuffer mb = null;
    private CRC32 crc = new CRC32();
    private long dataln;
    private static final int SIZE = 16384;
    private byte[] sizeBuffer = new byte[4];
    private byte[] entryBuffer = new byte[16384];
    private StringBuffer comment = new StringBuffer(256);
    private static Logger logger = Logger.getLogger("com.sap.inst.jload.io");

    public DataFile(String baseName) {
        this.baseName = baseName;
    }

    public DataFile(String baseName, int dataFileSize) {
        this.baseName = baseName;
        this.dataFileSize = dataFileSize;
    }

    public void open(String mode) throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "open");
        this.mode = mode;
        if (mode.equals("out")) {
            this.sout = new SplitOutputStream(this.baseName);
            if (this.dataFileSize != 0) {
                this.sout.setMaxFileSize(this.dataFileSize);
            }
        } else if (mode.equals("in")) {
            this.sin = new SplitInputStream(this.baseName);
        }
        logger.exiting("com.sap.inst.jload.io.DataFile", "open");
    }

    public void close() throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "close");
        if (this.sin != null) {
            this.sin.finish();
        }
        if (this.sout != null) {
            this.sout.finish();
        }
        this.sin = null;
        this.sout = null;
        logger.exiting("com.sap.inst.jload.io.DataFile", "close");
    }

    public void reopen() throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "reopen");
        int seqNr = this.sin.getSeqNr();
        long offset = this.sin.getFilePosition();
        this.close();
        this.sout = new SplitOutputStream(this.baseName, seqNr, offset);
        logger.exiting("com.sap.inst.jload.io.DataFile", "reopen");
    }

    public DataInputStream getDataInputStream(long streamLength) throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "getDataInputStream");
        if (this.sin == null) {
            logger.exiting("com.sap.inst.jload.io.DataFile", "getDataInputStream");
            return null;
        }
        this.sin.setStreamLength(streamLength);
        if (this.din != null) {
            this.din.close();
        }
        this.din = new DataInputStream(new GZIPInputStream(this.sin));
        logger.exiting("com.sap.inst.jload.io.DataFile", "getDataInputStream");
        return this.din;
    }

    public void closeDataInputStream() throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "closeDataInputStream");
        this.din.close();
        logger.exiting("com.sap.inst.jload.io.DataFile", "closeDataInputStream");
    }

    public DataOutputStream getDataOutputStream() throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "getDataOutputStream");
        if (this.sout == null) {
            logger.exiting("com.sap.inst.jload.io.DataFile", "getDataOutputStream");
            return null;
        }
        if (this.dout != null) {
            this.dout.close();
        }
        this.dout = new DataOutputStream(new GZIPOutputStream(this.sout));
        logger.exiting("com.sap.inst.jload.io.DataFile", "getDataOutputStream");
        return this.dout;
    }

    public void closeDataOutputStream() throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "closeDataOutputStream");
        this.dout.close();
        this.dataln = this.sout.size();
        logger.exiting("com.sap.inst.jload.io.DataFile", "closeDataOutputStream");
    }

    public DataFileEntry newMetaDataEntry(DBJob job, int length) {
        logger.entering("com.sap.inst.jload.io.DataFile", "newMetaDataEntry");
        this.comment.setLength(0);
        this.comment.append("Length: ").append(length);
        DataFileEntry dfe = new DataFileEntry(job.getId(), this.comment.toString());
        logger.exiting("com.sap.inst.jload.io.DataFile", "newMetaDataEntry");
        return dfe;
    }

    public DataFileEntry newDataEntry(DBJob job, ResultSetMetaData rsmd) throws SQLException {
        logger.entering("com.sap.inst.jload.io.DataFile", "newDataEntry");
        int numberOfColumns = rsmd.getColumnCount();
        this.comment.setLength(0);
        this.comment.append(job.getName()).append(" ").append(numberOfColumns);
        job.resetFields();
        for (int i = 1; i <= numberOfColumns; ++i) {
            int jdbcType = rsmd.getColumnType(i);
            String name = rsmd.getColumnName(i);
            this.comment.append(" ").append(name).append(" ").append(jdbcType);
            job.addField(name, jdbcType);
        }
        String where = job.getWhereCond();
        if (where != null) {
            this.comment.append(" [").append(where).append(']');
        }
        DataFileEntry dfe = new DataFileEntry(job.getId(), this.comment.toString());
        logger.exiting("com.sap.inst.jload.io.DataFile", "newDataEntry");
        return dfe;
    }

    public void putEntry(DataFileEntry dfe) throws IOException {
        int i;
        logger.entering("com.sap.inst.jload.io.DataFile", "putEntry");
        String entryName = dfe.getName();
        int nameLen = entryName.length();
        String entryComment = dfe.getComment();
        int commentLen = entryComment.length();
        int entrySize = 8 + 2 * nameLen + 4 + 2 * commentLen + 24;
        this.mb = this.sout.requestMappedByteBuffer(entrySize);
        this.mb.putInt(entrySize);
        this.mb.putInt(nameLen);
        for (i = 0; i < nameLen; ++i) {
            this.mb.putChar(entryName.charAt(i));
        }
        this.mb.putInt(commentLen);
        if (commentLen != 0) {
            for (i = 0; i < commentLen; ++i) {
                this.mb.putChar(entryComment.charAt(i));
            }
        }
        this.mb.putLong(dfe.getRowCount());
        this.mb.putLong(dfe.getDataLen());
        this.mb.putLong(dfe.getChecksum());
        this.mb.force();
        logger.exiting("com.sap.inst.jload.io.DataFile", "putEntry");
    }

    public void closeEntry(DataFileEntry dfe) {
        logger.entering("com.sap.inst.jload.io.DataFile", "closeEntry");
        dfe.setDataLen(this.dataln);
        int index = 8 + 2 * dfe.getName().length() + 4 + 2 * dfe.getComment().length();
        this.mb.putLong(index, dfe.getRowCount());
        this.mb.putLong(index + 8, dfe.getDataLen());
        this.crc.reset();
        for (int i = 0; i < index + 16; ++i) {
            this.crc.update(this.mb.get(i));
        }
        dfe.setChecksum(this.crc.getValue());
        this.mb.putLong(index + 16, dfe.getChecksum());
        this.mb.force();
        logger.exiting("com.sap.inst.jload.io.DataFile", "closeEntry");
    }

    public DataFileEntry getNextEntry() throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "getNextEntry");
        if (this.sin.read(this.sizeBuffer) == -1) {
            throw new EOFException("Unexpected end of file (" + this.sin.getFileName() + ")");
        }
        int size = ByteBuffer.wrap(this.sizeBuffer).asIntBuffer().get();
        if (this.entryBuffer.length < size - 4) {
            try {
                this.entryBuffer = new byte[size - 4];
            }
            catch (OutOfMemoryError e) {
                if (size > 65536) {
                    logger.severe("Unable to allocate " + size + " byte. Your dump file may be damaged");
                }
                throw e;
            }
        }
        this.sin.read(this.entryBuffer, size - 4);
        ByteBuffer bb = ByteBuffer.wrap(this.entryBuffer);
        DataFileEntry dfe = new DataFileEntry(bb);
        this.crc.reset();
        this.crc.update(this.sizeBuffer);
        this.crc.update(this.entryBuffer, 0, size - 12);
        if (this.crc.getValue() != dfe.getChecksum()) {
            logger.severe("Header for entry " + dfe.getName() + " seems to be damaged");
            throw new IOException("Invalid checksum");
        }
        logger.exiting("com.sap.inst.jload.io.DataFile", "getNextEntry");
        return dfe;
    }

    public void skipData(DataFileEntry dfe) throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "skipData");
        this.sin.skip(dfe.getDataLen());
        logger.exiting("com.sap.inst.jload.io.DataFile", "skipData");
    }

    public DataFileEntry findDataEntry(DBJob job) throws IOException {
        logger.entering("com.sap.inst.jload.io.DataFile", "findDataEntry");
        DataFileEntry dfe = null;
        try {
            dfe = this.getNextEntry();
            String where = dfe.getWhereClause();
            while (!dfe.getName().equals(job.getId()) || where != null && !where.equals(job.getWhereCond())) {
                this.sin.skip(dfe.getDataLen());
                dfe = this.getNextEntry();
                where = dfe.getWhereClause();
            }
        }
        catch (EOFException e) {
            this.close();
            this.open(this.mode);
            dfe = this.getNextEntry();
            while (dfe.getName() != job.getId()) {
                this.sin.skip(dfe.getDataLen());
                dfe = this.getNextEntry();
            }
        }
        if (dfe != null && job.getId().endsWith(":DATA")) {
            String[] columns = dfe.getColumns();
            job.resetFields();
            for (int i = 0; i < columns.length; i += 2) {
                job.addField(columns[i], Integer.parseInt(columns[i + 1]));
            }
        }
        logger.exiting("com.sap.inst.jload.io.DataFile", "findDataEntry");
        return dfe;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java DataFile <dump file[ dump file]*>");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            DataFile df = new DataFile(args[i]);
            try {
                df.open("in");
            }
            catch (IOException e) {
                logger.severe("Unable to open dump file " + args[i]);
                continue;
            }
            try {
                while (true) {
                    DataFileEntry dfe = df.getNextEntry();
                    System.out.println("[" + df.sin.getFileName() + "]");
                    System.out.println("\tentry name: " + dfe.getName());
                    System.out.println("\tcomment:    " + dfe.getComment());
                    System.out.println("\tdata len:   " + dfe.getDataLen());
                    System.out.println("\trow count:  " + dfe.getRowCount());
                    System.out.println("\tchecksum:   " + dfe.getChecksum());
                    df.skipData(dfe);
                }
            }
            catch (IOException e) {
                try {
                    df.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.exit(0);
    }
}

