/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class TinyIntHandler
extends FieldHandler {
    TinyIntHandler(String name, int columnNumber) {
        super(name, columnNumber, -6);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.TinyIntHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.TinyIntHandler", "setValue");
            return;
        }
        stmt.setByte(this.columnNumber, data.readByte());
        logger.exiting("com.sap.inst.jload.db.TinyIntHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.TinyIntHandler", "writeValue");
        byte b = rs.getByte(this.name);
        if (b == 0 && rs.wasNull()) {
            data.writeBoolean(true);
        } else {
            data.writeBoolean(false);
            data.writeByte(b);
        }
        logger.exiting("com.sap.inst.jload.db.TinyIntHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.TinyIntHandler", "printValue");
        byte b = rs.getByte(this.name);
        if (b == 0 && rs.wasNull()) {
            pw.println(this.name + " = (null)");
        } else {
            pw.println(this.name + " = " + b);
        }
        logger.exiting("com.sap.inst.jload.db.TinyIntHandler", "printValue");
    }
}

