/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

class TimestampHandler
extends FieldHandler {
    TimestampHandler(String name, int columnNumber) {
        super(name, columnNumber, 93);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.TimestampHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.TimestampHandler", "setValue");
            return;
        }
        stmt.setTimestamp(this.columnNumber, new Timestamp(data.readLong()));
        logger.exiting("com.sap.inst.jload.db.TimestampHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.TimestampHandler", "writeValue");
        Timestamp t = rs.getTimestamp(this.name);
        if (t == null) {
            data.writeBoolean(true);
        } else {
            data.writeBoolean(false);
            data.writeLong(t.getTime());
        }
        logger.exiting("com.sap.inst.jload.db.TimestampHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.TimestampHandler", "printValue");
        Timestamp t = rs.getTimestamp(this.name);
        if (t == null) {
            pw.println(this.name + " = (null)");
        } else {
            pw.println(this.name + " = " + t);
        }
        logger.exiting("com.sap.inst.jload.db.TimestampHandler", "printValue");
    }
}

