/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;

class TimeHandler
extends FieldHandler {
    TimeHandler(String name, int columnNumber) {
        super(name, columnNumber, 92);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.TimeHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.TimeHandler", "setValue");
            return;
        }
        stmt.setTime(this.columnNumber, new Time(data.readLong()));
        logger.exiting("com.sap.inst.jload.db.TimeHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.TimeHandler", "writeValue");
        Time t = rs.getTime(this.name);
        if (t == null) {
            data.writeBoolean(true);
        } else {
            data.writeBoolean(false);
            data.writeLong(t.getTime());
        }
        logger.exiting("com.sap.inst.jload.db.TimeHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.TimeHandler", "printValue");
        Time t = rs.getTime(this.name);
        if (t == null) {
            pw.println(this.name + " = (null)");
        } else {
            pw.println(this.name + " = " + t);
        }
        logger.exiting("com.sap.inst.jload.db.TimeHandler", "printValue");
    }
}

