/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class RealHandler
extends FieldHandler {
    RealHandler(String name, int columnNumber) {
        super(name, columnNumber, 7);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.RealHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.RealHandler", "setValue");
            return;
        }
        stmt.setFloat(this.columnNumber, data.readFloat());
        logger.exiting("com.sap.inst.jload.db.RealHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.RealHandler", "writeValue");
        float f = rs.getFloat(this.name);
        if (f == 0.0f && rs.wasNull()) {
            data.writeBoolean(true);
        } else {
            if (f < -3.4E38f || f > 3.4E38f || f > -1.175E-37f && f < 1.175E-37f && f != 0.0f) {
                throw new SQLException("Range overflow in column " + this.name + ", value " + f);
            }
            data.writeBoolean(false);
            data.writeFloat(f);
        }
        logger.exiting("com.sap.inst.jload.db.RealHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.RealHandler", "printValue");
        float f = rs.getFloat(this.name);
        if (f == 0.0f && rs.wasNull()) {
            pw.println(this.name + " = (null");
        } else {
            pw.println(this.name + " = " + f);
        }
        logger.exiting("com.sap.inst.jload.db.RealHandler", "printValue");
    }
}

