/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class NumericHandler
extends FieldHandler {
    NumericHandler(String name, int columnName) {
        super(name, columnName, 2);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.NumericHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.NumericHandler", "setValue");
            return;
        }
        int len = data.readInt();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buf.append(data.readChar());
        }
        stmt.setBigDecimal(this.columnNumber, new BigDecimal(buf.toString()));
        logger.exiting("com.sap.inst.jload.db.NumericHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.NumericHandler", "writeValue");
        BigDecimal d = rs.getBigDecimal(this.name);
        if (d == null) {
            data.writeBoolean(true);
        } else {
            data.writeBoolean(false);
            String s = d.toString();
            data.writeInt(s.length());
            data.writeChars(s);
        }
        logger.exiting("com.sap.inst.jload.db.NumericHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.NumericHandler", "printValue");
        BigDecimal d = rs.getBigDecimal(this.name);
        if (d == null) {
            pw.println(this.name + " = (null)");
        } else {
            pw.println(this.name + " = " + d);
        }
        logger.exiting("com.sap.inst.jload.db.NumericHandler", "printValue");
    }
}

