/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class IntegerHandler
extends FieldHandler {
    IntegerHandler(String name, int columnNumber) {
        super(name, columnNumber, 4);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.IntegerHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.IntegerHandler", "setValue");
            return;
        }
        stmt.setInt(this.columnNumber, data.readInt());
        logger.exiting("com.sap.inst.jload.db.IntegerHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.IntegerHandler", "writeValue");
        int i = rs.getInt(this.name);
        if (i == 0 && rs.wasNull()) {
            data.writeBoolean(true);
        } else {
            data.writeBoolean(false);
            data.writeInt(i);
        }
        logger.exiting("com.sap.inst.jload.db.IntegerHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.IntegerHandler", "printValue");
        int i = rs.getInt(this.name);
        if (i == 0 && rs.wasNull()) {
            pw.println(this.name + " = (null)");
        } else {
            pw.println(this.name + " = " + i);
        }
        logger.exiting("com.sap.inst.jload.db.IntegerHandler", "printValue");
    }
}

