/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.DBJob;
import com.sap.inst.jload.db.ArrayHandler;
import com.sap.inst.jload.db.BigIntHandler;
import com.sap.inst.jload.db.BinaryHandler;
import com.sap.inst.jload.db.BitHandler;
import com.sap.inst.jload.db.BlobHandler;
import com.sap.inst.jload.db.CharHandler;
import com.sap.inst.jload.db.ClobHandler;
import com.sap.inst.jload.db.DateHandler;
import com.sap.inst.jload.db.DecimalHandler;
import com.sap.inst.jload.db.DoubleHandler;
import com.sap.inst.jload.db.FloatHandler;
import com.sap.inst.jload.db.IllegalValueException;
import com.sap.inst.jload.db.IntegerHandler;
import com.sap.inst.jload.db.JavaObjectHandler;
import com.sap.inst.jload.db.LongvarbinaryHandler;
import com.sap.inst.jload.db.LongvarcharHandler;
import com.sap.inst.jload.db.NumericHandler;
import com.sap.inst.jload.db.RealHandler;
import com.sap.inst.jload.db.SmallIntHandler;
import com.sap.inst.jload.db.StructHandler;
import com.sap.inst.jload.db.TimeHandler;
import com.sap.inst.jload.db.TimestampHandler;
import com.sap.inst.jload.db.TinyIntHandler;
import com.sap.inst.jload.db.VarbinaryHandler;
import com.sap.inst.jload.db.VarcharHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

abstract class FieldHandler {
    protected String name;
    protected int columnNumber;
    protected int type;
    protected static Logger logger = Logger.getLogger("com.sap.inst.jload.db");

    FieldHandler(String name, int columnNumber, int type) {
        this.name = name;
        this.columnNumber = columnNumber;
        this.type = type;
    }

    void init(String name, int columnNumber) {
        this.name = name;
        this.columnNumber = columnNumber;
    }

    int getType() {
        return this.type;
    }

    boolean checkAndSetNullValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.FieldHandler", "checkAndSetNullValue");
        boolean isNull = data.readBoolean();
        if (isNull) {
            stmt.setNull(this.columnNumber, this.type);
        }
        logger.exiting("com.sap.inst.jload.db.FieldHandler", "checkAndSetNullValue");
        return isNull;
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.FieldHandler", "printValue");
        pw.println(this.name + " = ?");
        logger.exiting("com.sap.inst.jload.db.FieldHandler", "printValue");
    }

    abstract void setValue(PreparedStatement var1, DataInputStream var2) throws IOException, SQLException;

    abstract void writeValue(ResultSet var1, DataOutputStream var2) throws IOException, SQLException, IllegalValueException;

    static FieldHandler[] setFieldHandler(DBJob job) throws SQLException {
        logger.entering("com.sap.inst.jload.db.FieldHandler", "setFieldHandler");
        FieldHandler[] FieldList = new FieldHandler[job.getFieldCount() + 1];
        block26: for (int i = 1; i <= job.getFieldCount(); ++i) {
            switch (job.getFieldType(i)) {
                case 1: {
                    FieldList[i] = new CharHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 12: {
                    FieldList[i] = new VarcharHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case -1: {
                    FieldList[i] = new LongvarcharHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case -6: {
                    FieldList[i] = new TinyIntHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 5: {
                    FieldList[i] = new SmallIntHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 4: {
                    FieldList[i] = new IntegerHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case -5: {
                    FieldList[i] = new BigIntHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 7: {
                    FieldList[i] = new RealHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 6: {
                    FieldList[i] = new FloatHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 8: {
                    FieldList[i] = new DoubleHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 3: {
                    FieldList[i] = new DecimalHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 2: {
                    FieldList[i] = new NumericHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case -7: {
                    FieldList[i] = new BitHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case -2: {
                    FieldList[i] = new BinaryHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case -3: {
                    FieldList[i] = new VarbinaryHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case -4: {
                    FieldList[i] = new LongvarbinaryHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 91: {
                    FieldList[i] = new DateHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 92: {
                    FieldList[i] = new TimeHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 93: {
                    FieldList[i] = new TimestampHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 2004: {
                    FieldList[i] = new BlobHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 2005: {
                    FieldList[i] = new ClobHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 2003: {
                    FieldList[i] = new ArrayHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 2002: {
                    FieldList[i] = new StructHandler(job.getFieldName(i), i);
                    continue block26;
                }
                case 2000: {
                    FieldList[i] = new JavaObjectHandler(job.getFieldName(i), i);
                    continue block26;
                }
                default: {
                    throw new SQLException("SQL type " + job.getFieldType(i) + " not supported\n" + "(table " + job.getName() + ", column " + job.getFieldName(i) + ")");
                }
            }
        }
        logger.exiting("com.sap.inst.jload.db.FieldHandler", "setFieldHandler");
        return FieldList;
    }
}

