/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import com.sap.inst.jload.db.IllegalValueException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class DoubleHandler
extends FieldHandler {
    DoubleHandler(String name, int columnNumber) {
        super(name, columnNumber, 8);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.DoubleHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.DoubleHandler", "setValue");
            return;
        }
        stmt.setDouble(this.columnNumber, data.readDouble());
        logger.exiting("com.sap.inst.jload.db.DoubleHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException, IllegalValueException {
        logger.entering("com.sap.inst.jload.db.DoubleHandler", "writeValue");
        double d = rs.getDouble(this.name);
        if (d == 0.0 && rs.wasNull()) {
            data.writeBoolean(true);
        } else {
            if (d < -9.9E62 || d > 9.9E62 || d > -1.0E-64 && d < 1.0E-64 && d != 0.0) {
                throw new IllegalValueException("Range overflow in column " + this.name + ", value " + d);
            }
            data.writeBoolean(false);
            data.writeDouble(d);
        }
        logger.exiting("com.sap.inst.jload.db.DoubleHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.DoubleHandler", "printValue");
        double d = rs.getDouble(this.name);
        if (d == 0.0 && rs.wasNull()) {
            pw.println(this.name + " = (null");
        } else {
            pw.println(this.name + " = " + d);
        }
        logger.exiting("com.sap.inst.jload.db.DoubleHandler", "printValue");
    }
}

