/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class DateHandler
extends FieldHandler {
    DateHandler(String name, int columnNumber) {
        super(name, columnNumber, 91);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.DateHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.DateHandler", "setValue");
            return;
        }
        stmt.setDate(this.columnNumber, new Date(data.readLong()));
        logger.exiting("com.sap.inst.jload.db.DateHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.DateHandler", "writeValue");
        Date d = rs.getDate(this.name);
        if (d == null) {
            data.writeBoolean(true);
        } else {
            data.writeBoolean(false);
            data.writeLong(d.getTime());
        }
        logger.exiting("com.sap.inst.jload.db.DateHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.DateHandler", "printValue");
        Date d = rs.getDate(this.name);
        if (d == null) {
            pw.println(this.name + " = (null)");
        } else {
            pw.println(this.name + " = " + d);
        }
        logger.exiting("com.sap.inst.jload.db.DateHandler", "printValue");
    }
}

