/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.DBJob;
import com.sap.inst.jload.io.DataFile;
import com.sap.inst.jload.io.DataFileEntry;
import com.sap.sql.services.OpenSQLServices;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Logger;

public class DDICReader {
    private static final int SIZE = 16384;
    private Connection con = null;
    private PreparedStatement ps = null;
    private boolean prepared = false;
    private StringBuffer xml = new StringBuffer(16384);
    private char[] cbuf = new char[16384];
    private static Logger logger = Logger.getLogger("com.sap.inst.jload.db");

    public DDICReader(Connection con) {
        this.con = con;
    }

    private void init() throws SQLException {
        logger.entering("com.sap.inst.jload.db.DDICReader", "init");
        String stmt = "SELECT XMLVALUE FROM BC_DDDBTABLERT WHERE NAME = ? AND \"TYPE\" = ?";
        this.ps = OpenSQLServices.prepareNativeStatement((Connection)this.con, (String)stmt);
        this.prepared = true;
        logger.exiting("com.sap.inst.jload.db.DDICReader", "init");
    }

    public void getObjectDescription(DBJob job, DataFile df) throws SQLException, IOException {
        logger.entering("com.sap.inst.jload.db.DDICReader", "getObjectDescription");
        if (!this.prepared) {
            this.init();
        }
        this.ps.setString(1, job.getName());
        this.ps.setString(2, new Character(job.getType()).toString());
        ResultSet rs = this.ps.executeQuery();
        long xmlLength = 0L;
        this.xml.setLength(0);
        while (rs.next()) {
            int len;
            Reader r = rs.getCharacterStream("XMLVALUE");
            if (r == null || rs.wasNull()) {
                throw new SQLException("No XMLVALUE for " + job.getName());
            }
            BufferedReader br = new BufferedReader(r);
            while ((len = br.read(this.cbuf, 0, 16384)) != -1) {
                xmlLength += (long)len;
                this.xml.append(this.cbuf, 0, len);
            }
            if (xmlLength <= Integer.MAX_VALUE) continue;
            throw new IOException("Length " + xmlLength + " too large (column XMLVALUE)");
        }
        rs.close();
        DataFileEntry dfe = df.newMetaDataEntry(job, this.xml.length());
        df.putEntry(dfe);
        DataOutputStream data = df.getDataOutputStream();
        data.writeChars(this.xml.toString());
        df.closeDataOutputStream();
        df.closeEntry(dfe);
        logger.exiting("com.sap.inst.jload.db.DDICReader", "getObjectDescription");
    }

    public HashMap getDBObjects() throws SQLException {
        logger.entering("com.sap.inst.jload.db.DDICReader", "getDBObjects");
        HashMap<String, String> objects = new HashMap<String, String>();
        Statement stmt = OpenSQLServices.createNativeStatement((Connection)this.con);
        ResultSet rs = stmt.executeQuery("SELECT NAME, TYPE FROM BC_DDDBTABLERT");
        while (rs.next()) {
            objects.put(rs.getString(1), rs.getString(2));
        }
        rs.close();
        stmt.close();
        logger.exiting("com.sap.inst.jload.db.DDICReader", "getDBObjects");
        return objects;
    }
}

