/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.opentools.DbTableOpenTools;
import com.sap.inst.jload.DBJob;
import com.sap.inst.jload.db.DBObject;
import com.sap.inst.jload.db.DDICReader;
import com.sap.inst.jload.db.FieldHandler;
import com.sap.inst.jload.db.IllegalValueException;
import com.sap.inst.jload.io.DataFile;
import com.sap.inst.jload.io.DataFileEntry;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.logging.Logger;

public class DBTable
implements DBObject {
    private static Logger logger = Logger.getLogger("com.sap.inst.jload.db");
    private static final int BUFFERSIZE = 16384;
    private static final int DEFAULT_COMMIT_COUNT = 100;
    private Connection con = null;
    private DbTableOpenTools ddic = null;
    private DDICReader ddicReader = null;
    private int commitCount = 100;
    private StringBuffer stmtText = new StringBuffer(16384);

    public DBTable(Connection con) {
        this.con = con;
    }

    public void describe(DBJob job, DataFile df) throws JddException, SQLException, IOException {
        logger.entering("com.sap.inst.jload.db.DBTable", "describe");
        if (this.ddicReader == null) {
            this.ddicReader = new DDICReader(this.con);
        }
        this.ddicReader.getObjectDescription(job, df);
        logger.exiting("com.sap.inst.jload.db.DBTable", "describe");
    }

    public void create(DBJob job, DataFile df) throws IOException, FileNotFoundException, JddException {
        logger.entering("com.sap.inst.jload.db.DBTable", "create");
        DataFileEntry dfe = df.findDataEntry(job);
        String[] comment = dfe.getComment().split(" ");
        int length = Integer.parseInt(comment[1]);
        this.stmtText.setLength(0);
        DataInputStream din = df.getDataInputStream(dfe.getDataLen());
        int charCount = 0;
        try {
            while (true) {
                this.stmtText.append(din.readChar());
                ++charCount;
            }
        }
        catch (EOFException e) {
            if (length != charCount) {
                throw e;
            }
            df.closeDataInputStream();
            ByteArrayInputStream bin = new ByteArrayInputStream(this.stmtText.toString().getBytes());
            if (this.ddic == null) {
                this.ddic = new DbTableOpenTools(this.con);
            }
            if (!this.ddic.createTable(job.getName(), (InputStream)bin)) {
                throw new JddException("CREATE TABLE " + job.getName() + " failed");
            }
            logger.exiting("com.sap.inst.jload.db.DBTable", "create");
            return;
        }
    }

    public void drop(DBJob job) throws SQLException, JddException {
        logger.entering("com.sap.inst.jload.db.DBTable", "drop");
        if (this.ddic == null) {
            this.ddic = new DbTableOpenTools(this.con);
        }
        if (!this.ddic.dropTable(job.getName())) {
            throw new JddException("DROP TABLE " + job.getName() + " failed");
        }
        logger.exiting("com.sap.inst.jload.db.DBTable", "drop");
    }

    private PreparedStatement buildSelectStatement(DBJob job) throws SQLException {
        logger.entering("com.sap.inst.jload.db.DBTable", "buildSelectStatement");
        this.stmtText.setLength(0);
        this.stmtText.append("SELECT ");
        for (int i = 1; i < job.getFieldCount(); ++i) {
            this.stmtText.append(job.getFieldName(i)).append(" ,  ");
        }
        this.stmtText.append(job.getFieldName(job.getFieldCount())).append(" FROM ").append(job.getName());
        String where = job.getWhereCond();
        if (where != null) {
            this.stmtText.append(" WHERE ").append(where);
        }
        PreparedStatement ps = this.con.prepareStatement(this.stmtText.toString());
        logger.exiting("com.sap.inst.jload.db.DBTable", "buildSelectStatement");
        return ps;
    }

    private PreparedStatement buildInsertStatement(DBJob job) throws SQLException {
        int i;
        logger.entering("com.sap.inst.jload.db.DBTable", "buildInsertStatement");
        this.stmtText.setLength(0);
        this.stmtText.append("INSERT INTO ").append(job.getName()).append("( ");
        for (i = 1; i < job.getFieldCount(); ++i) {
            this.stmtText.append(job.getFieldName(i)).append(" ,  ");
        }
        this.stmtText.append(job.getFieldName(job.getFieldCount())).append(" ) VALUES (");
        for (i = 0; i < job.getFieldCount() - 1; ++i) {
            this.stmtText.append(" ? ,");
        }
        this.stmtText.append(" ? )");
        PreparedStatement ps = this.con.prepareStatement(this.stmtText.toString());
        logger.exiting("com.sap.inst.jload.db.DBTable", "buildInsertStatement");
        return ps;
    }

    private PreparedStatement buildDeleteStatement(DBJob job) throws SQLException {
        logger.entering("com.sap.inst.jload.db.DBTable", "buildDeleteStatement");
        this.stmtText.setLength(0);
        this.stmtText.append("DELETE FROM ").append(job.getName());
        String where = job.getWhereCond();
        if (where != null) {
            this.stmtText.append(" WHERE ").append(where);
        }
        PreparedStatement ps = this.con.prepareStatement(this.stmtText.toString());
        logger.exiting("com.sap.inst.jload.db.DBTable", "buildDeleteStatement");
        return ps;
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public long unload(DBJob job, DataFile df) throws Exception {
        logger.entering("com.sap.inst.jload.db.DBTable", "unload");
        PreparedStatement stmt = this.buildSelectStatement(job);
        ResultSet rs = stmt.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        DataFileEntry dfe = df.newDataEntry(job, rsmd);
        df.putEntry(dfe);
        DataOutputStream data = df.getDataOutputStream();
        FieldHandler[] fieldList = FieldHandler.setFieldHandler(job);
        int numberOfColumns = rsmd.getColumnCount();
        long rowCount = 0L;
        while (rs.next()) {
            ++rowCount;
            for (int i = 1; i <= numberOfColumns; ++i) {
                try {
                    fieldList[i].writeValue(rs, data);
                    continue;
                }
                catch (IllegalValueException e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println(e.getMessage());
                    for (int j = 1; j <= numberOfColumns; ++j) {
                        fieldList[j].printValue(rs, pw);
                    }
                    pw.close();
                    if (job.getName().startsWith("J2EE_CONFIG")) {
                        logger.warning(sw.toString());
                        continue;
                    }
                    throw new IllegalValueException(sw.toString());
                }
            }
        }
        rs.close();
        stmt.close();
        dfe.setRowCount(rowCount);
        df.closeDataOutputStream();
        df.closeEntry(dfe);
        logger.exiting("com.sap.inst.jload.db.DBTable", "unload");
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long load(DBJob job, DataFile df) throws IOException, SQLException {
        DBTable.logger.entering("com.sap.inst.jload.db.DBTable", "load");
        dfe = df.findDataEntry(job);
        if (0L == dfe.getRowCount()) {
            df.skipData(dfe);
            DBTable.logger.exiting("com.sap.inst.jload.db.DBTable", "load");
            return 0L;
        }
        data = df.getDataInputStream(dfe.getDataLen());
        stmt = this.buildInsertStatement(job);
        fieldList = FieldHandler.setFieldHandler(job);
        hasLob = false;
        for (i = 1; i <= job.getFieldCount(); ++i) {
            type = fieldList[i].getType();
            if (type != 2004 && type != 2005) continue;
            hasLob = true;
            break;
        }
        rowCount = 0L;
        insertCount = 0;
        try {
            try {
                while (true) {
                    for (i = 1; i <= job.getFieldCount(); ++i) {
                        fieldList[i].setValue(stmt, data);
                    }
                    if (hasLob) {
                        stmt.executeUpdate();
                    } else {
                        stmt.addBatch();
                    }
                    ++rowCount;
                    if (++insertCount % this.commitCount != 0) ** continue;
                    if (!hasLob) {
                        stmt.executeBatch();
                    }
                    insertCount = 0;
                    this.con.commit();
                }
            }
            catch (EOFException e) {
                if (!hasLob && insertCount != 0) {
                    stmt.executeBatch();
                }
                this.con.commit();
                stmt.close();
                df.closeDataInputStream();
            }
        }
        catch (Throwable var12_14) {
            stmt.close();
            df.closeDataInputStream();
            throw var12_14;
        }
        if (rowCount != dfe.getRowCount()) {
            throw new SQLException("ERROR: wrong row count (exp " + dfe.getRowCount() + "/imp " + rowCount + ")");
        }
        DBTable.logger.exiting("com.sap.inst.jload.db.DBTable", "load");
        return rowCount;
    }

    public void delete(DBJob job) throws SQLException {
        logger.entering("com.sap.inst.jload.db.DBTable", "delete");
        PreparedStatement stmt = this.buildDeleteStatement(job);
        stmt.executeUpdate();
        this.con.commit();
        logger.exiting("com.sap.inst.jload.db.DBTable", "delete");
    }
}

