/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.security.core.server.secstorefs.FileIOException;
import com.sap.security.core.server.secstorefs.FileInvalidException;
import com.sap.security.core.server.secstorefs.InvalidStateException;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import com.sap.sql.connect.OpenSQLDataSource;
import com.sap.sql.connect.OpenSQLProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;

public class DBConnection {
    private Connection con = null;
    private OpenSQLDataSource ds = null;
    private String sid = null;
    private String ssProp;
    private String ssKey;
    private String ssKeyPhrase = null;
    private String dataSourceName;
    private String driver;
    private String url;
    private String user;
    private String passwd;
    private static Logger logger = Logger.getLogger("com.sap.inst.jload.db");

    public DBConnection(String sid, String dataSourceName, String ssKeyPhrase) {
        this.sid = sid;
        this.dataSourceName = dataSourceName;
        this.ssProp = "/usr/sap/" + sid.toUpperCase() + "/SYS/global/security/data/SecStore.properties";
        this.ssKey = "/usr/sap/" + sid.toUpperCase() + "/SYS/global/security/data/SecStore.key";
        this.ssKeyPhrase = ssKeyPhrase;
    }

    public DBConnection(String sid, String dataSourceName, String ssProp, String ssKey, String ssKeyPhrase) {
        this.sid = sid;
        this.dataSourceName = dataSourceName;
        this.ssProp = ssProp != null ? ssProp : "/usr/sap/" + sid.toUpperCase() + "/SYS/global/security/data/SecStore.properties";
        this.ssKey = ssKey != null ? ssKey : "/usr/sap/" + sid.toUpperCase() + "/SYS/global/security/data/SecStore.key";
        this.ssKeyPhrase = ssKeyPhrase;
    }

    public DBConnection(String driver, String url, String user, String passwd) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
    }

    private void setOpenSQLProperties() {
        OpenSQLProperties p = this.ds.getOpenSQLProperties();
        p.setSyncReader(false);
        p.setSyncWriter(false);
        p.setTableBuffer(false);
    }

    private Connection connectViaSecureStore() throws SQLException, ClassNotFoundException, InvalidStateException, FileIOException, FileInvalidException {
        logger.entering("com.sap.inst.jload.db.DBConnection", "connectViaSecureStore");
        try {
            SecStoreFS.setSID((String)this.sid.toUpperCase());
            SecStoreFS.setDefaultFilenames((String)this.ssProp, (String)this.ssKey);
            if (SecStoreFS.isKeyDialogRequired()) {
                if (this.ssKeyPhrase == null) {
                    logger.severe("no key phrase");
                    logger.exiting("com.sap.inst.jload.db.DBConnection", "connectViaSecureStore");
                    System.exit(1);
                } else {
                    SecStoreFS.setDefaultKeyPhrase((String)this.ssKeyPhrase);
                }
            }
            this.ds.setDataSourceName(this.dataSourceName);
            this.setOpenSQLProperties();
            this.con = this.ds.getConnection();
            this.con.setAutoCommit(false);
        }
        catch (SQLException e) {
            if (this.con != null) {
                this.con.close();
            }
            throw e;
        }
        logger.info("connected to " + this.sid + " on " + this.dataSourceName);
        logger.exiting("com.sap.inst.jload.db.DBConnection", "connectViaSecureStore");
        return this.con;
    }

    private Connection connectViaURL() throws SQLException, ClassNotFoundException, InvalidStateException, FileIOException, FileInvalidException {
        logger.entering("com.sap.inst.jload.db.DBConnection", "connectViaURL");
        try {
            this.ds.setDriverProperties(this.driver, this.url, this.user, this.passwd);
            this.setOpenSQLProperties();
            this.con = this.ds.getConnection();
            this.con.setAutoCommit(false);
        }
        catch (SQLException e) {
            if (this.con != null) {
                this.con.close();
            }
            throw e;
        }
        logger.info("connected to " + this.url);
        logger.exiting("com.sap.inst.jload.db.DBConnection", "connectViaURL");
        return this.con;
    }

    public Connection connect() throws SQLException, ClassNotFoundException, InvalidStateException, FileIOException, FileInvalidException {
        this.ds = OpenSQLDataSource.newInstance();
        if (this.sid != null) {
            return this.connectViaSecureStore();
        }
        return this.connectViaURL();
    }

    public void disconnect() throws SQLException {
        logger.entering("com.sap.inst.jload.db.DBConnection", "disconnect");
        if (this.con != null) {
            this.con.close();
        }
        logger.info("disconnected");
        logger.exiting("com.sap.inst.jload.db.DBConnection", "disconnect");
    }
}

