/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import com.sap.inst.jload.db.IllegalValueException;
import java.io.CharArrayReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class ClobHandler
extends FieldHandler {
    ClobHandler(String name, int columnNumber) {
        super(name, columnNumber, 2005);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.ClobHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.ClobHandler", "setValue");
            return;
        }
        long len = data.readLong();
        char[] buffer = new char[(int)len];
        int i = 0;
        while ((long)i < len) {
            buffer[i] = data.readChar();
            ++i;
        }
        stmt.setCharacterStream(this.columnNumber, (Reader)new CharArrayReader(buffer), buffer.length);
        logger.exiting("com.sap.inst.jload.db.ClobHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException, IllegalValueException {
        logger.entering("com.sap.inst.jload.db.ClobHandler", "writeValue");
        Clob clob = rs.getClob(this.name);
        if (clob == null) {
            data.writeBoolean(true);
        } else {
            long len = clob.length();
            if (len == 0L) {
                data.writeBoolean(true);
                throw new IllegalValueException("Empty string in column " + this.name);
            }
            if (len > Integer.MAX_VALUE) {
                throw new IOException("Length " + len + " too large, field " + this.name);
            }
            String buffer = clob.getSubString(1L, (int)len);
            data.writeBoolean(false);
            data.writeLong(clob.length());
            data.writeChars(buffer);
        }
        logger.exiting("com.sap.inst.jload.db.ClobHandler", "writeValue");
    }
}

