/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import com.sap.inst.jload.db.IllegalValueException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class CharHandler
extends FieldHandler {
    private static final int BUFFERSIZE = 16384;
    private StringBuffer buf = new StringBuffer(16384);

    CharHandler(String name, int columnNumber) {
        super(name, columnNumber, 1);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.CharHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.CharHandler", "setValue");
            return;
        }
        this.buf.setLength(0);
        int len = data.readInt();
        for (int i = 0; i < len; ++i) {
            this.buf.append(data.readChar());
        }
        stmt.setString(this.columnNumber, this.buf.toString());
        logger.exiting("com.sap.inst.jload.db.CharHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException, IllegalValueException {
        logger.entering("com.sap.inst.jload.db.CharHandler", "writeValue");
        String s = rs.getString(this.name);
        if (s == null) {
            data.writeBoolean(true);
        } else {
            if (s.equals("")) {
                data.writeBoolean(true);
                throw new IllegalValueException("Empty string in column " + this.name);
            }
            if (s.endsWith(" ") && !s.equals(" ")) {
                s = this.trimEnd(s);
                data.writeBoolean(false);
                data.writeInt(s.length());
                data.writeChars(s);
                throw new IllegalValueException("Trailing blanks in column " + this.name);
            }
            data.writeBoolean(false);
            data.writeInt(s.length());
            data.writeChars(s);
        }
        logger.exiting("com.sap.inst.jload.db.CharHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.CharHandler", "printValue");
        String s = rs.getString(this.name);
        if (s == null) {
            pw.println(this.name + "= (null)");
        } else {
            pw.println(this.name + " = " + s);
        }
        logger.exiting("com.sap.inst.jload.db.CharHandler", "printValue");
    }

    String trimEnd(String s) {
        int index = s.length() - 1;
        while (s.charAt(index) == ' ') {
            --index;
        }
        return s.substring(0, index + 1);
    }
}

