/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import com.sap.inst.jload.db.IllegalValueException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class BlobHandler
extends FieldHandler {
    BlobHandler(String name, int columnNumber) {
        super(name, columnNumber, 2004);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.BlobHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.BlobHandler", "setValue");
            return;
        }
        long len = data.readLong();
        byte[] buffer = new byte[(int)len];
        int read = data.read(buffer);
        while ((long)read < len) {
            read += data.read(buffer, read, (int)(len - (long)read));
        }
        stmt.setBinaryStream(this.columnNumber, (InputStream)new ByteArrayInputStream(buffer), buffer.length);
        logger.exiting("com.sap.inst.jload.db.BlobHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException, IllegalValueException {
        logger.entering("com.sap.inst.jload.db.BlobHandler", "writeValue");
        Blob blob = rs.getBlob(this.name);
        if (blob == null) {
            data.writeBoolean(true);
        } else {
            long len = blob.length();
            if (len == 0L) {
                data.writeBoolean(true);
                throw new IllegalValueException("Empty binary string in column " + this.name);
            }
            if (len > Integer.MAX_VALUE) {
                throw new IOException("Length " + len + " too large, column " + this.name);
            }
            byte[] buffer = blob.getBytes(1L, (int)len);
            if (len != (long)buffer.length) {
                throw new IOException("BLOB length is " + buffer.length + ", should be " + len + ", column " + this.name);
            }
            data.writeBoolean(false);
            data.writeLong(len);
            data.write(buffer);
        }
        logger.exiting("com.sap.inst.jload.db.BlobHandler", "writeValue");
    }
}

