/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import com.sap.inst.jload.db.IllegalValueException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class BinaryHandler
extends FieldHandler {
    BinaryHandler(String name, int columnNumber) {
        super(name, columnNumber, -2);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.BinaryHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.BinaryHandler", "setValue");
            return;
        }
        int length = data.readInt();
        byte[] bytes = new byte[length];
        for (int read = data.read(bytes); read < length; read += data.read(bytes, read, length - read)) {
        }
        stmt.setBytes(this.columnNumber, bytes);
        logger.exiting("com.sap.inst.jload.db.BinaryHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException, IllegalValueException {
        logger.entering("com.sap.inst.jload.db.BinaryHandler", "writeValue");
        byte[] bytes = rs.getBytes(this.name);
        if (bytes == null) {
            data.writeBoolean(true);
        } else {
            if (bytes.length == 0) {
                data.writeBoolean(true);
                throw new IllegalValueException("Empty binary string in column " + this.name);
            }
            data.writeBoolean(false);
            data.writeInt(bytes.length);
            data.write(bytes);
        }
        logger.exiting("com.sap.inst.jload.db.BinaryHandler", "writeValue");
    }
}

