/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload.db;

import com.sap.inst.jload.db.FieldHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class BigIntHandler
extends FieldHandler {
    BigIntHandler(String name, int columnNumber) {
        super(name, columnNumber, -5);
    }

    void setValue(PreparedStatement stmt, DataInputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.BigIntHandler", "setValue");
        if (this.checkAndSetNullValue(stmt, data)) {
            logger.exiting("com.sap.inst.jload.db.BigIntHandler", "setValue");
            return;
        }
        stmt.setLong(this.columnNumber, data.readLong());
        logger.exiting("com.sap.inst.jload.db.BigIntHandler", "setValue");
    }

    void writeValue(ResultSet rs, DataOutputStream data) throws IOException, SQLException {
        logger.entering("com.sap.inst.jload.db.BigIntHandler", "writeValue");
        long l = rs.getLong(this.name);
        if (l == 0L && rs.wasNull()) {
            data.writeBoolean(true);
        } else {
            data.writeBoolean(false);
            data.writeLong(l);
        }
        logger.exiting("com.sap.inst.jload.db.BigIntHandler", "writeValue");
    }

    void printValue(ResultSet rs, PrintWriter pw) throws SQLException {
        logger.entering("com.sap.inst.jload.db.BigIntHandler", "printValue");
        long l = rs.getLong(this.name);
        if (l == 0L && rs.wasNull()) {
            pw.println(this.name + " = (null)");
        } else {
            pw.println(this.name + " = " + l);
        }
        logger.exiting("com.sap.inst.jload.db.BigIntHandler", "printValue");
    }
}

