/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final int BUFFERSIZE = 1024;
    private static final String format = "{0,date,short} {0,time,short}";
    private static final String lineSeparator = System.getProperty("line.separator");
    private StringBuffer text = new StringBuffer(1024);
    private Date date = new Date();
    private Object[] args = new Object[1];
    private MessageFormat formatter = new MessageFormat("{0,date,short} {0,time,short}", Locale.GERMANY);

    public String format(LogRecord record) {
        this.text.setLength(0);
        this.date.setTime(record.getMillis());
        this.args[0] = this.date;
        this.formatter.format(this.args, this.text, (FieldPosition)null);
        this.text.append(" ");
        if (record.getSourceClassName() != null) {
            this.text.append(record.getSourceClassName());
        } else {
            this.text.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            this.text.append(" ").append(record.getSourceMethodName());
        }
        this.text.append(lineSeparator);
        String message = this.formatMessage(record);
        this.text.append(record.getLevel().getName());
        this.text.append(": ");
        this.text.append(message);
        this.text.append(lineSeparator).append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                this.text.append(sw.toString());
                this.text.append(lineSeparator).append(lineSeparator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.text.toString();
    }
}

