/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload;

import com.sap.inst.jload.DBJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobStatus {
    public static final int NEW = 0;
    public static final int OK = 1;
    public static final int ERR = 2;
    public static final int UNK = 3;
    private static Logger logger = Logger.getLogger("com.sap.inst.jload");
    private static final String format = "{0,date,short} {0,time,short}";
    private Date date = new Date();
    private Object[] args = new Object[1];
    private MessageFormat formatter = new MessageFormat("{0,date,short} {0,time,short}", Locale.GERMANY);
    private StringBuffer sb = new StringBuffer();
    private String statusFileName = null;
    private PrintWriter out = null;
    private HashMap status = null;

    public JobStatus(String jobFileName) {
        logger.entering("com.sap.inst.jload.JobStatus", "JobStatus");
        this.statusFileName = new File(jobFileName).getName();
        int suffix = this.statusFileName.lastIndexOf(".xml");
        if (suffix == -1) {
            suffix = this.statusFileName.lastIndexOf(".XML");
        }
        if (suffix == -1) {
            suffix = this.statusFileName.length();
        }
        this.statusFileName = this.statusFileName.substring(0, suffix) + ".sta";
        logger.exiting("com.sap.inst.jload.JobStatus", "JobStatus");
    }

    public boolean isRestart() {
        return this.status != null;
    }

    private String[] getStatus(DBJob job) {
        if (this.status == null) {
            return null;
        }
        String where_hash = job.getHashCode();
        this.sb.setLength(0);
        this.sb.append(job.getId()).append(" ").append(job.getActionName());
        if (where_hash != null) {
            this.sb.append(" ").append(where_hash);
        }
        return (String[])this.status.get(this.sb.toString());
    }

    public int status(DBJob job) {
        String[] s = this.getStatus(job);
        if (s == null) {
            return 0;
        }
        if (s[0].equalsIgnoreCase("OK")) {
            return 1;
        }
        if (s[0].equalsIgnoreCase("ERR")) {
            return 2;
        }
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    public void readStatus() throws IOException {
        void var1_1;
        String line;
        logger.entering("com.sap.inst.jload.JobStatus", "readStatus");
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.statusFileName));
        }
        catch (FileNotFoundException e) {
            logger.info("status file " + this.statusFileName + " doesn't exist - no restart");
            logger.exiting("com.sap.inst.jload.JobStatus", "readStatus");
            return;
        }
        while ((line = var1_1.readLine()) != null) {
            if (this.status == null) {
                this.status = new HashMap();
            }
            if ((line = line.trim()).equals("")) continue;
            String[] s = line.split("\\s+");
            if (s.length == 5) {
                this.status.put(s[0] + " " + s[1], new String[]{s[2], s[3], s[4]});
                continue;
            }
            if (s.length == 6) {
                this.status.put(s[0] + " " + s[1] + " " + s[2], new String[]{s[3], s[4], s[5]});
                continue;
            }
            IOException e = new IOException("Invalid entry in status file: " + line);
            logger.log(Level.SEVERE, "Fatal Exception", e);
            throw e;
        }
        if (this.status != null) {
            logger.info("commencing restart");
        }
        var1_1.close();
        logger.exiting("com.sap.inst.jload.JobStatus", "readStatus");
    }

    public void writeStatus(DBJob job, String status) throws IOException {
        String[] s;
        logger.entering("com.sap.inst.jload.JobStatus", "writeStatus");
        if (this.out == null) {
            File old = new File(this.statusFileName);
            old.renameTo(new File(this.statusFileName + ".bck"));
            this.out = new PrintWriter(new FileWriter(this.statusFileName));
        }
        this.sb.setLength(0);
        this.sb.append(job.getId()).append(" ").append(job.getActionName());
        String where_hash = job.getHashCode();
        if (where_hash != null) {
            this.sb.append(" ").append(where_hash);
        }
        if ((s = this.getStatus(job)) != null && s[0].equals("OK")) {
            this.sb.append(" ").append(s[0]).append("\t\t").append(s[1]).append(" ").append(s[2]);
        } else {
            this.sb.append(" ").append(status).append("\t\t");
            this.date.setTime(System.currentTimeMillis());
            this.args[0] = this.date;
            this.formatter.format(this.args, this.sb, (FieldPosition)null);
        }
        this.out.println(this.sb.toString());
        this.out.flush();
        logger.exiting("com.sap.inst.jload.JobStatus", "writeStatus");
    }

    public void close() throws IOException {
        this.out.close();
        this.out = null;
    }
}

