/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload;

import com.sap.inst.jload.DBJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JobReader {
    private static Logger logger = Logger.getLogger("com.sap.inst.jload");
    private static String pathSeparator = System.getProperty("file.separator");
    private String jobFileName;
    private String jobType;
    private ArrayList jobList;
    private String dataDir;
    private String dataFileName;
    private String dataFileSize = null;
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    private static final String FILE = "file";
    private static final String SIZE = "size";
    private static final String OBJECT = "object";
    private static final String WHERE = "where";
    private static final String COND = "cond";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String ACTION = "action";
    private static final String FIELD = "field";

    public JobReader(String jobFileName, String dataDir) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        logger.entering("com.sap.inst.jload.JobReader", "JobReader");
        this.jobFileName = jobFileName;
        this.dataDir = dataDir;
        this.jobList = new ArrayList();
        DocumentBuilder docB = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docB.parse(new File(jobFileName));
        Element root = doc.getDocumentElement();
        this.jobType = root.getTagName();
        this.dataFileName = root.getAttribute(FILE);
        this.dataFileSize = root.getAttribute(SIZE);
        NodeList nl = root.getElementsByTagName(OBJECT);
        for (int i = 0; i < nl.getLength(); ++i) {
            String action;
            Element element = (Element)nl.item(i);
            String name = element.getAttribute(NAME);
            String type_attr = element.getAttribute(TYPE);
            char type = 'T';
            if (type_attr != null && !type_attr.equals("")) {
                type = type_attr.charAt(0);
            }
            if ((action = element.getAttribute(ACTION)) == null || action.equals("")) {
                action = this.jobType.equals(EXPORT) ? "select" : "insert";
            }
            String cond = null;
            NodeList cl = element.getElementsByTagName(WHERE);
            if (cl != null && cl.getLength() != 0) {
                Element where = (Element)cl.item(0);
                cond = where.getAttribute(COND);
            }
            DBJob job = new DBJob(name, type, action, cond);
            cl = element.getElementsByTagName(FIELD);
            if (cl == null || cl.getLength() == 0) {
                job.addField("*");
            } else {
                for (int j = 0; j < cl.getLength(); ++j) {
                    Element field = (Element)cl.item(j);
                    job.addField(field.getAttribute(NAME));
                }
            }
            this.jobList.add(job);
        }
        logger.exiting("com.sap.inst.jload.JobReader", "JobReader");
    }

    public JobReader(HashMap objects, boolean generateXMLFiles, String dataDir) throws IOException {
        logger.entering("com.sap.inst.jload.JobReader", "JobReader");
        this.dataDir = dataDir;
        this.jobType = EXPORT;
        this.jobFileName = "EXPORT.XML";
        this.dataFileName = "EXPDUMP";
        TreeSet s = new TreeSet(objects.keySet());
        Iterator it = s.iterator();
        this.jobList = new ArrayList();
        PrintWriter exp = null;
        PrintWriter imp = null;
        if (generateXMLFiles) {
            exp = new PrintWriter(new BufferedWriter(new FileWriter(new File(dataDir, "EXPORT.XML"))));
            imp = new PrintWriter(new BufferedWriter(new FileWriter(new File(dataDir, "IMPORT.XML"))));
            exp.println("<export file=\"" + this.dataFileName + "\">");
            imp.println("<import file=\"" + this.dataFileName + "\">");
        }
        while (it.hasNext()) {
            String name = (String)it.next();
            String type = (String)objects.get(name);
            DBJob job = new DBJob(name, type.charAt(0), "describe", null);
            job.addField("*");
            this.jobList.add(job);
            if (generateXMLFiles) {
                imp.println("   <object name=\"" + name + "\" type=\"" + type + "\" action=\"create\"/>");
                exp.println("   <object name=\"" + name + "\" type=\"" + type + "\" action=\"describe\"/>");
            }
            if (!type.equals("T")) continue;
            job = new DBJob(name, type.charAt(0), "select", null);
            job.addField("*");
            this.jobList.add(job);
            if (!generateXMLFiles) continue;
            imp.println("   <object name=\"" + name + "\" action=\"insert\"/>");
            exp.println("   <object name=\"" + name + "\" action=\"select\"/>");
        }
        if (generateXMLFiles) {
            exp.println("</export>");
            imp.println("</import>");
            exp.close();
            imp.close();
        }
        logger.exiting("com.sap.inst.jload.JobReader", "JobReader");
    }

    public String getJobFileName() throws IOException {
        File f = new File(this.jobFileName);
        return f.getCanonicalPath();
    }

    public String getJobType() {
        return this.jobType;
    }

    public ArrayList getJobList() {
        return this.jobList;
    }

    public String getDataFileName() throws IOException {
        File f = new File(this.dataDir, this.dataFileName);
        return f.getCanonicalPath();
    }

    public int getDataFileSize() throws NumberFormatException {
        String sz;
        if (this.dataFileSize == null || this.dataFileSize.equals("")) {
            return 0;
        }
        float factor = 1.0f;
        if (this.dataFileSize.endsWith("kB")) {
            factor = 9.765625E-4f;
            sz = this.dataFileSize.substring(0, this.dataFileSize.length() - 2);
        } else if (this.dataFileSize.endsWith("MB")) {
            sz = this.dataFileSize.substring(0, this.dataFileSize.length() - 2);
        } else if (this.dataFileSize.endsWith("GB")) {
            factor = 1024.0f;
            sz = this.dataFileSize.substring(0, this.dataFileSize.length() - 2);
        } else {
            factor = 9.536743E-7f;
            sz = this.dataFileSize;
        }
        float fs = Float.valueOf(sz).floatValue() * factor;
        return Math.round(fs);
    }
}

