/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload;

import com.sap.inst.jload.DBJob;
import com.sap.inst.jload.JobReader;
import com.sap.inst.jload.JobStatus;
import com.sap.inst.jload.LogFormatter;
import com.sap.inst.jload.db.DBConnection;
import com.sap.inst.jload.db.DBTable;
import com.sap.inst.jload.db.DDICReader;
import com.sap.inst.jload.io.DataFile;
import com.sap.inst.jload.io.DataFileEntry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class Jload {
    private static Logger logger;
    private static Handler[] handler;
    private static HashMap LogLevel;

    private Jload() {
    }

    private static void openLogFile(String logFileName) throws SecurityException, IOException {
        logger = Logger.getLogger("");
        String level = System.getProperty(".level");
        logger.setLevel((Level)LogLevel.get(level));
        handler = logger.getHandlers();
        for (int i = 0; i < handler.length; ++i) {
            logger.removeHandler(handler[i]);
        }
        StreamHandler hdlr = new FileHandler(logFileName, true);
        hdlr.setFormatter(new LogFormatter());
        logger.addHandler(hdlr);
        hdlr = new StreamHandler(System.out, new SimpleFormatter());
        logger.addHandler(hdlr);
        logger = Logger.getLogger("com.sap.inst.jload");
        level = System.getProperty("com.sap.inst.jload.level");
        logger.setLevel((Level)LogLevel.get(level));
    }

    private static void closeLogFile() {
        handler[0].close();
    }

    private static void printSQLException(SQLException e) {
        logger.entering("com.sap.inst.jload.Jload", "printSQLException");
        while (e != null) {
            logger.severe("Message: " + e.getMessage());
            logger.severe("SQLState: " + e.getSQLState());
            logger.severe("ErrorCode: " + e.getErrorCode());
            e = e.getNextException();
        }
        logger.exiting("com.sap.inst.jload.Jload", "printSQLException");
    }

    private static void logStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        logger.severe(sw.toString());
    }

    private static int dbExport(Connection con, JobReader jr) throws SQLException, IOException {
        logger.entering("com.sap.inst.jload.Jload", "dbExport");
        int errorCount = 0;
        ArrayList jobList = jr.getJobList();
        if (jobList.size() == 0) {
            logger.info("empty job list");
            logger.exiting("com.sap.inst.jload.Jload", "dbExport");
            return errorCount;
        }
        DBTable tab = new DBTable(con);
        DataFile df = new DataFile(jr.getDataFileName(), jr.getDataFileSize());
        JobStatus js = new JobStatus(jr.getJobFileName());
        js.readStatus();
        boolean restart = js.isRestart();
        if (restart) {
            df.open("in");
        } else {
            df.open("out");
        }
        Iterator iter = jobList.iterator();
        while (iter.hasNext()) {
            DBJob job = (DBJob)iter.next();
            if (restart) {
                if (js.status(job) == 1) {
                    DataFileEntry dfe = df.findDataEntry(job);
                    df.skipData(dfe);
                    js.writeStatus(job, "OK");
                    continue;
                }
                df.reopen();
                restart = false;
            }
            try {
                switch (job.getAction()) {
                    case 6: {
                        tab.describe(job, df);
                        logger.info(job.getName() + " meta data exported");
                        break;
                    }
                    case 1: {
                        long rowCount = tab.unload(job, df);
                        StringBuffer sb = new StringBuffer(job.getName());
                        if (job.getWhereCond() != null) {
                            sb.append(" [" + job.getWhereCond() + "]");
                        }
                        sb.append(" exported (" + rowCount + " rows)");
                        logger.info(sb.toString());
                    }
                }
                js.writeStatus(job, "OK");
            }
            catch (SQLException e) {
                ++errorCount;
                logger.severe("DB Error during export of " + job.getName());
                Jload.printSQLException(e);
                break;
            }
            catch (Throwable e) {
                ++errorCount;
                logger.severe("Error during export of " + job.getName());
                Jload.logStackTrace(e);
                break;
            }
        }
        js.close();
        df.close();
        logger.exiting("com.sap.inst.jload.Jload", "dbExport");
        return errorCount;
    }

    private static int dbImport(Connection con, JobReader jr) throws Throwable {
        logger.entering("com.sap.inst.jload.Jload", "dbImport");
        int errorCount = 0;
        ArrayList jobList = jr.getJobList();
        if (jobList.size() == 0) {
            logger.info("empty job list");
            logger.exiting("com.sap.inst.jload.Jload", "dbImport");
            return errorCount;
        }
        DBTable tab = new DBTable(con);
        DataFile df = new DataFile(jr.getDataFileName());
        JobStatus js = new JobStatus(jr.getJobFileName());
        js.readStatus();
        df.open("in");
        Iterator iter = jobList.iterator();
        while (iter.hasNext()) {
            DBJob job = (DBJob)iter.next();
            if (js.status(job) == 1) {
                DataFileEntry dfe = df.findDataEntry(job);
                df.skipData(dfe);
                js.writeStatus(job, "OK");
                continue;
            }
            if (js.status(job) == 3) {
                logger.warning(job.getName() + " " + job.getActionName() + " has unknown status");
                continue;
            }
            try {
                StringBuffer sb;
                if (job.getAction() == 4) {
                    switch (job.getType()) {
                        case 'T': {
                            if (js.status(job) == 2) {
                                try {
                                    logger.info("trying to drop table " + job.getName());
                                    tab.drop(job);
                                    logger.info("table dropped");
                                }
                                catch (SQLException e) {
                                    logger.info("failed to drop table " + job.getName());
                                    Jload.printSQLException(e);
                                }
                            }
                            logger.info("trying to create table " + job.getName());
                            tab.create(job, df);
                            logger.info("table " + job.getName() + " created");
                            js.writeStatus(job, "OK");
                            break;
                        }
                        case 'I': 
                        case 'P': 
                        case 'V': {
                            ++errorCount;
                            logger.severe("cannot create object with type " + job.getType());
                            js.writeStatus(job, "ERR");
                        }
                    }
                    continue;
                }
                if (job.getAction() == 5) {
                    switch (job.getType()) {
                        case 'T': {
                            logger.info("trying to drop table " + job.getName());
                            tab.drop(job);
                            logger.info("table dropped");
                            js.writeStatus(job, "OK");
                            break;
                        }
                        case 'I': 
                        case 'P': 
                        case 'V': {
                            ++errorCount;
                            logger.severe("cannot drop object with type " + job.getType());
                            js.writeStatus(job, "ERR");
                        }
                    }
                    continue;
                }
                if (job.getAction() == 2) {
                    if (js.status(job) == 2) {
                        logger.info("trying to delete from table " + job.getName());
                        tab.delete(job);
                        sb = new StringBuffer(job.getName());
                        if (job.getWhereCond() != null) {
                            sb.append(" [" + job.getWhereCond() + "]");
                        }
                        sb.append(" deleted");
                        logger.info(sb.toString());
                    }
                    long rowCount = tab.load(job, df);
                    StringBuffer sb2 = new StringBuffer(job.getName());
                    if (job.getWhereCond() != null) {
                        sb2.append(" [" + job.getWhereCond() + "]");
                    }
                    sb2.append(" loaded (" + rowCount + " rows)");
                    logger.info(sb2.toString());
                    js.writeStatus(job, "OK");
                    continue;
                }
                if (job.getAction() != 3) continue;
                tab.delete(job);
                sb = new StringBuffer(job.getName());
                if (job.getWhereCond() != null) {
                    sb.append(" [" + job.getWhereCond() + "]");
                }
                sb.append(" deleted");
                logger.info(sb.toString());
                js.writeStatus(job, "OK");
            }
            catch (SQLException e) {
                ++errorCount;
                js.writeStatus(job, "ERR");
                logger.severe("DB Error during import of " + job.getName());
                Jload.printSQLException(e);
            }
            catch (NoSuchElementException e) {
                ++errorCount;
                js.writeStatus(job, "ERR");
                Jload.logStackTrace(e);
            }
            catch (Throwable e) {
                ++errorCount;
                js.writeStatus(job, "ERR");
                throw e;
            }
        }
        js.close();
        df.close();
        logger.exiting("com.sap.inst.jload.Jload", "dbImport");
        return errorCount;
    }

    private static int executeJob(Connection con, String jobFileName, String dataDir) throws IOException {
        logger.entering("com.sap.inst.jload.Jload", "executeJob");
        int errorCount = 0;
        try {
            JobReader jr;
            if (jobFileName != null) {
                jr = new JobReader(jobFileName, dataDir);
            } else {
                DDICReader dr = new DDICReader(con);
                jr = new JobReader(dr.getDBObjects(), true, dataDir);
            }
            String jobType = jr.getJobType();
            if (jobType.equals("export")) {
                errorCount = Jload.dbExport(con, jr);
            } else if (jobType.equals("import")) {
                errorCount = Jload.dbImport(con, jr);
            } else {
                ++errorCount;
                logger.severe("invalid job type " + jobType);
            }
        }
        catch (SQLException e) {
            ++errorCount;
            logger.severe("DB Error:");
            Jload.printSQLException(e);
        }
        catch (Throwable e) {
            ++errorCount;
            Jload.logStackTrace(e);
        }
        logger.exiting("com.sap.inst.jload.Jload", "executeJob");
        return errorCount;
    }

    private static void printHelp() {
        System.err.println("java Jload <options>\n\t\t -sec <SID,data source name[,SecureStore property file,SecureStore key file][,SecureStore key phrase]\n\t\t -url <url>\n\t\t -auth <user,passwd>\n\t\t -driver <jdbc driver>\n\t\t -dataDir <directory for job and dump files>\n\t\t -job <job file name[,job file name]*>\n\t\t -log <log file name>");
        System.exit(1);
    }

    private static HashMap evalArguments(String[] args) {
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            argMap.put(args[i], args[i + 1]);
        }
        if (argMap.get("-auth") != null) {
            String[] auth = ((String)argMap.get("-auth")).split(",", 2);
            if (auth.length != 2) {
                Jload.printHelp();
            }
            argMap.put("-user", auth[0]);
            argMap.put("-passwd", auth[1]);
        }
        if (argMap.get("-sec") != null) {
            String[] ss = ((String)argMap.get("-sec")).split(",");
            if (ss.length < 2 || ss.length > 5) {
                Jload.printHelp();
            }
            argMap.put("-sid", ss[0]);
            argMap.put("-dsn", ss[1]);
            if (ss.length == 3 || ss.length == 5) {
                argMap.put("-ssKeyPhrase", ss[ss.length - 1]);
            }
            if (ss.length > 3) {
                argMap.put("-ssProp", ss[2]);
                argMap.put("-ssKey", ss[3]);
            }
        }
        if (argMap.get("-job") != null) {
            String[] jobs = ((String)argMap.get("-job")).split(",");
            argMap.put("-jobFile", jobs);
            if (jobs.length == 1 && argMap.get("-log") == null) {
                String logFile = jobs[0];
                if (logFile.endsWith(".xml") || logFile.endsWith(".XML")) {
                    logFile = logFile.substring(0, logFile.lastIndexOf(46)) + ".log";
                }
                argMap.put("-log", logFile);
            }
        }
        if (argMap.get("-log") == null) {
            argMap.put("-log", "jload.log");
        }
        return argMap;
    }

    public static void main(String[] args) {
        int i;
        if (args.length == 0 || args.length % 2 != 0) {
            Jload.printHelp();
        }
        HashMap arguments = Jload.evalArguments(args);
        String dataDir = (String)arguments.get("-dataDir");
        String[] jobFile = (String[])arguments.get("-jobFile");
        String logFile = (String)arguments.get("-log");
        String user = (String)arguments.get("-user");
        String passwd = (String)arguments.get("-passwd");
        String url = (String)arguments.get("-url");
        String driver = (String)arguments.get("-driver");
        String sid = (String)arguments.get("-sid");
        String dsn = (String)arguments.get("-dsn");
        String ssProp = (String)arguments.get("-ssProp");
        String ssKey = (String)arguments.get("-ssKey");
        String ssKeyPhrase = (String)arguments.get("-ssKeyPhrase");
        DBConnection dbCon = null;
        Connection con = null;
        try {
            Jload.openLogFile(logFile);
            StringBuffer sb = new StringBuffer("Jload");
            for (i = 0; i < args.length; ++i) {
                sb.append(" ").append(args[i]);
            }
            logger.info(sb.toString());
        }
        catch (Exception e) {
            System.err.println("Error: " + e.toString());
            System.exit(1);
        }
        try {
            if (url != null) {
                dbCon = new DBConnection(driver, url, user, passwd);
            } else if (sid != null) {
                dbCon = new DBConnection(sid, dsn, ssProp, ssKey, ssKeyPhrase);
            } else {
                Jload.printHelp();
            }
            con = dbCon.connect();
        }
        catch (Exception e) {
            logger.severe("couldn't connect to DB\n" + e.toString());
            System.exit(1);
        }
        if (jobFile == null) {
            jobFile = new String[]{null};
        }
        int errorCount = 0;
        for (i = 0; i < jobFile.length; ++i) {
            try {
                errorCount += Jload.executeJob(con, jobFile[i], dataDir);
                continue;
            }
            catch (Exception e) {
                ++errorCount;
                Jload.logStackTrace(e);
                continue;
            }
            catch (Error e) {
                ++errorCount;
                Jload.logStackTrace(e);
            }
        }
        try {
            dbCon.disconnect();
        }
        catch (Exception e) {
            ++errorCount;
            logger.severe("disconnect()\n" + e.toString());
        }
        Jload.closeLogFile();
        if (errorCount > 0) {
            System.exit(errorCount);
        }
    }

    static {
        LogLevel = new HashMap();
        LogLevel.put("SEVERE", Level.SEVERE);
        LogLevel.put("WARNING", Level.WARNING);
        LogLevel.put("INFO", Level.INFO);
        LogLevel.put("CONFIG", Level.CONFIG);
        LogLevel.put("FINE", Level.FINE);
        LogLevel.put("FINER", Level.FINER);
        LogLevel.put("FINEST", Level.FINEST);
    }
}

