/*
 * Decompiled with CFR 0.152.
 */
package com.sap.inst.jload;

import java.util.ArrayList;
import java.util.logging.Logger;

public class DBJob {
    private static Logger logger = Logger.getLogger("com.sap.inst.jload");
    private String id = null;
    private String objectName;
    private char objectType = (char)84;
    private int action = 1;
    private ArrayList field = new ArrayList();
    private String where = null;
    static final int INVALID = 0;
    static final int SELECT = 1;
    static final int INSERT = 2;
    static final int DELETE = 3;
    static final int CREATE = 4;
    static final int DROP = 5;
    static final int DESCRIBE = 6;
    static final String[] actions = new String[]{"INVALID", "SELECT", "INSERT", "DELETE", "CREATE", "DROP", "DESCRIBE"};

    public DBJob(String objectName, char objectType, String action, String where) {
        this.objectName = objectName;
        this.objectType = objectType;
        this.action = action == null || action.equals("select") ? 1 : (action.equals("insert") ? 2 : (action.equals("delete") ? 3 : (action.equals("create") ? 4 : (action.equals("drop") ? 5 : (action.equals("describe") ? 6 : 0)))));
        this.where = where;
    }

    public String getId() {
        logger.entering("com.sap.inst.jload.DBJob", "getId");
        this.id = this.action == 1 || this.action == 2 || this.action == 3 ? this.objectType + ":" + this.objectName + ":DATA" : this.objectType + ":" + this.objectName + ":METADATA";
        logger.exiting("com.sap.inst.jload.DBJob", "getId");
        return this.id;
    }

    public String getName() {
        return this.objectName;
    }

    public char getType() {
        return this.objectType;
    }

    public int getAction() {
        return this.action;
    }

    public String getActionName() {
        return actions[this.action];
    }

    public String getWhereCond() {
        return this.where;
    }

    public String getHashCode() {
        if (this.where == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('W').append(this.where.hashCode());
        return sb.toString();
    }

    public int getFieldCount() {
        return this.field.size();
    }

    public void resetFields() {
        this.field.clear();
    }

    public void addField(String name) {
        this.field.add(new jdbcField(name));
    }

    public void addField(String name, int type) {
        this.field.add(new jdbcField(name, type));
    }

    public String getFieldName(int index) throws IndexOutOfBoundsException {
        jdbcField jf = (jdbcField)this.field.get(index - 1);
        return jf.name;
    }

    public int getFieldType(int index) throws IndexOutOfBoundsException {
        jdbcField jf = (jdbcField)this.field.get(index - 1);
        return jf.type;
    }

    private class jdbcField {
        String name;
        int type;

        jdbcField(String name) {
            this.name = name;
            this.type = 0;
        }

        jdbcField(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

