/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizerConstants;

public final class StandardFilter
extends TokenFilter
implements StandardTokenizerConstants {
    private static final String APOSTROPHE_TYPE = StandardTokenizerConstants.tokenImage[2];
    private static final String ACRONYM_TYPE = StandardTokenizerConstants.tokenImage[3];

    public StandardFilter(TokenStream tokenStream) {
        this.input = tokenStream;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        String string = token.termText();
        String string2 = token.type();
        if (string2 == APOSTROPHE_TYPE && (string.endsWith("'s") || string.endsWith("'S"))) {
            return new Token(string.substring(0, string.length() - 2), token.startOffset(), token.endOffset(), string2);
        }
        if (string2 == ACRONYM_TYPE) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c != '.') {
                    stringBuffer.append(c);
                }
                ++n;
            }
            return new Token(stringBuffer.toString(), token.startOffset(), token.endOffset(), string2);
        }
        return token;
    }
}

