/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.ant;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.ITask;

public class AntScript {
    protected PrintWriter output;
    protected final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public AntScript(OutputStream out) throws IOException {
        this.output = new PrintWriter(new OutputStreamWriter(out, "UTF8"));
        this.output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void close() {
        this.output.flush();
        this.output.close();
    }

    public void printAntCallTask(int tab, String target, String inheritAll, Map params) {
        this.printTab(tab);
        this.output.print("<antcall");
        this.printAttribute("target", target, true);
        this.printAttribute("inheritAll", inheritAll, false);
        if (params == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++tab;
            Set entries = params.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.printParam(tab, (String)entry.getKey(), (String)entry.getValue());
            }
            this.printTab(--tab);
            this.output.println("</antcall>");
        }
    }

    public void printJarTask(int tab, String jarFile, String basedir) {
        this.printTab(tab);
        this.output.print("<jar");
        this.printAttribute("jarfile", jarFile, true);
        this.printAttribute("basedir", basedir, false);
        this.output.println("/>");
    }

    public void printAvailableTask(int tab, String property, String file) {
        this.printTab(tab);
        this.output.print("<available");
        this.printAttribute("property", property, true);
        this.printAttribute("file", file, false);
        this.output.println("/>");
    }

    public void printAntTask(int tab, String antfile, String dir, String target, String outputParam, String inheritAll, Map properties) {
        this.printTab(tab);
        this.output.print("<ant");
        this.printAttribute("antfile", antfile, false);
        this.printAttribute("dir", dir, false);
        this.printAttribute("target", target, false);
        this.printAttribute("output", outputParam, false);
        this.printAttribute("inheritAll", inheritAll, false);
        if (properties == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++tab;
            Set entries = properties.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.printProperty(tab, (String)entry.getKey(), (String)entry.getValue());
            }
            this.printTab(--tab);
            this.output.println("</ant>");
        }
    }

    public void printZipTask(int tab, String zipfile, String basedir, boolean filesOnly, String excludes, boolean update, FileSet[] fileSets) {
        this.printTab(tab);
        this.output.print("<zip");
        this.printAttribute("zipfile", zipfile, true);
        this.printAttribute("basedir", basedir, false);
        this.printAttribute("filesonly", filesOnly ? "true" : "false", true);
        this.printAttribute("update", update ? "yes" : "no", true);
        this.printAttribute("excludes", excludes, false);
        if (fileSets == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++tab;
            int i = 0;
            while (i < fileSets.length) {
                fileSets[i].print(this, tab);
                ++i;
            }
            this.printTab(--tab);
            this.output.println("</zip>");
        }
    }

    protected void printArg(int tab, String line) {
        this.printTab(tab);
        this.output.print("<arg");
        this.printAttribute("line", line, false);
        this.output.println("/>");
    }

    public void printString(int tab, String string) {
        this.printTab(tab);
        this.output.println(string);
    }

    public void printComment(int tab, String comment) {
        this.printTab(tab);
        this.output.print("<!-- ");
        this.output.print(comment);
        this.output.println(" -->");
    }

    protected void printAttribute(String name, String value, boolean mandatory) {
        if (mandatory && value == null) {
            value = "";
        }
        if (value != null) {
            this.output.print(" ");
            this.output.print(name);
            this.output.print("=");
            this.printQuotes(value);
        }
    }

    public void printCopyTask(int tab, String file, String todir, FileSet[] fileSets) {
        this.printTab(tab);
        this.output.print("<copy");
        this.printAttribute("file", file, false);
        this.printAttribute("todir", todir, false);
        if (fileSets == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++tab;
            int i = 0;
            while (i < fileSets.length) {
                fileSets[i].print(this, tab);
                ++i;
            }
            this.printTab(--tab);
            this.output.println("</copy>");
        }
    }

    public void printDeleteTask(int tab, String dir, String file, FileSet[] fileSets) {
        this.printTab(tab);
        this.output.print("<delete");
        this.printAttribute("dir", dir, false);
        this.printAttribute("file", file, false);
        if (fileSets == null) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++tab;
            int i = 0;
            while (i < fileSets.length) {
                fileSets[i].print(this, tab);
                ++i;
            }
            this.printTab(--tab);
            this.output.println("</delete>");
        }
    }

    public void printExecTask(int tab, String executable, String dir, List lineArgs) {
        this.printTab(tab);
        this.output.print("<exec");
        this.printAttribute("executable", executable, true);
        this.printAttribute("dir", dir, false);
        if (lineArgs == null || lineArgs.size() == 0) {
            this.output.println("/>");
        } else {
            this.output.println(">");
            ++tab;
            int i = 0;
            while (i < lineArgs.size()) {
                this.printArg(tab, (String)lineArgs.get(i));
                ++i;
            }
            this.printTab(--tab);
            this.output.println("</exec>");
        }
    }

    public void printMkdirTask(int tab, String dir) {
        this.printTab(tab);
        this.output.print("<mkdir");
        this.printAttribute("dir", dir, false);
        this.output.println("/>");
    }

    public void printEchoTask(int tab, String message) {
        this.printTab(tab);
        this.output.print("<echo");
        this.printAttribute("message", message, true);
        this.output.println("/>");
    }

    public void printCVSTask(int tab, String command, String cvsRoot, String dest, String module, String tag, String quiet, String passFile) {
        this.printTab(tab);
        this.output.print("<cvs");
        this.printAttribute("command", command, false);
        this.printAttribute("cvsRoot", cvsRoot, false);
        this.printAttribute("dest", dest, false);
        this.printAttribute("package", module, false);
        this.printAttribute("tag", tag, false);
        this.printAttribute("quiet", quiet, false);
        this.printAttribute("passfile", passFile, false);
        this.output.println("/>");
    }

    public void printCVSPassTask(int tab, String cvsRoot, String password, String passFile) {
        this.printTab(tab);
        this.output.print("<cvspass");
        this.printAttribute("cvsRoot", cvsRoot, true);
        this.printAttribute("password", password, true);
        this.printAttribute("passfile", passFile, false);
        this.output.println("/>");
    }

    protected void printParam(int tab, String name, String value) {
        this.printTab(tab);
        this.output.print("<param");
        this.printAttribute("name", name, true);
        this.printAttribute("value", value, true);
        this.output.println("/>");
    }

    public void printProjectDeclaration(String name, String target, String basedir) {
        this.output.print("<project");
        this.printAttribute("name", name, false);
        this.printAttribute("default", target, true);
        this.printAttribute("basedir", basedir, false);
        this.output.println(">");
    }

    public void printProjectEnd() {
        this.printEndTag(0, "project");
    }

    public void printProperty(int tab, String name, String value) {
        this.printTab(tab);
        this.output.print("<property");
        this.printAttribute("name", name, true);
        this.printAttribute("value", value, true);
        this.output.println("/>");
    }

    protected void printQuotes(String message) {
        this.output.print("\"");
        this.output.print(message);
        this.output.print("\"");
    }

    public void printStartTag(int tab, String tag) {
        this.printTab(tab);
        this.output.print("<");
        this.output.print(tag);
        this.output.println(">");
    }

    public void printEndTag(int tab, String tag) {
        this.printTab(tab);
        this.output.print("</");
        this.output.print(tag);
        this.output.println(">");
    }

    protected void printTab(int indent) {
        int i = 0;
        while (i < indent) {
            this.output.print("\t");
            ++i;
        }
    }

    public void println(String message) {
        this.output.println(message);
    }

    public void print(String message) {
        this.output.print(message);
    }

    public void println() {
        this.output.println();
    }

    public void print(int tab, ITask task) {
        task.print(this, tab);
    }

    public void printTargetDeclaration(int tab, String name, String depends, String ifClause, String unlessClause, String description) {
        this.printTab(tab);
        this.output.print("<target");
        this.printAttribute("name", name, true);
        this.printAttribute("depends", depends, false);
        this.printAttribute("if", ifClause, false);
        this.printAttribute("unless", unlessClause, false);
        this.printAttribute("description", description, false);
        this.output.println(">");
    }

    public void printTargetEnd(int tab) {
        this.printEndTag(tab, "target");
    }

    public void printRefreshLocalTask(int tab, String resource, String depth) {
        this.printTab(tab);
        this.output.print("<eclipse.refreshLocal");
        this.printAttribute("resource", resource, true);
        this.printAttribute("depth", depth, false);
        this.output.println("/>");
    }

    public void printConvertPathTask(int tab, String toConvert, String propertyName, boolean isEclipseResource) {
        this.printTab(tab);
        this.output.print("<eclipse.convertPath");
        if (isEclipseResource) {
            this.printAttribute("resourcePath", toConvert, true);
        } else {
            this.printAttribute("fileSystemPath", toConvert, true);
        }
        this.printAttribute("property", propertyName, true);
        this.output.println("/>");
    }
}

