/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.pde.internal.build.IPDEBuildConstants;

public final class Utils
implements IPDEBuildConstants {
    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getArrayFromString(String list) {
        return Utils.getArrayFromString(list, ",");
    }

    public static boolean contains(IStatus status, int severity) {
        if (status.matches(severity)) {
            return true;
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                if (Utils.contains(children[i], severity)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static URL[] asURL(String[] target) throws CoreException {
        if (target == null) {
            return null;
        }
        try {
            URL[] result = new URL[target.length];
            int i = 0;
            while (i < target.length) {
                result[i] = new URL(target[i]);
                ++i;
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, e.getMessage(), (Throwable)e));
        }
    }

    public static String getStringFromCollection(Collection collection, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (!first) {
                result.append(separator);
            }
            first = false;
            result.append(i.next().toString());
        }
        return result.toString();
    }

    public static String getStringFromArray(String[] values, String separator) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(values[i]);
            ++i;
        }
        return result.toString();
    }

    public static String[] computePrerequisiteOrder(PluginModel[] plugins, PluginModel[] fragments) {
        String[] orderedPlugins = Utils.computePrerequisiteOrderPlugins(plugins);
        if (fragments != null && fragments.length != 0) {
            return Utils.insertFragments(orderedPlugins, fragments);
        }
        return orderedPlugins;
    }

    private static String[] computePrerequisiteOrderPlugins(PluginModel[] plugins) {
        ArrayList<String[]> prereqs = new ArrayList<String[]>(9);
        HashSet<String> pluginList = new HashSet<String>(plugins.length);
        int i = 0;
        while (i < plugins.length) {
            pluginList.add(plugins[i].getId());
            ++i;
        }
        i = 0;
        while (i < plugins.length) {
            boolean boot = false;
            boolean runtime = false;
            boolean found = false;
            PluginPrerequisiteModel[] prereqList = plugins[i].getRequires();
            if (prereqList != null) {
                int j = 0;
                while (j < prereqList.length) {
                    String prereq = prereqList[j].getPlugin();
                    boot = boot || prereq.equals("org.eclipse.core.boot");
                    boolean bl = runtime = runtime || prereq.equals("org.eclipse.core.runtime");
                    if (pluginList.contains(prereq)) {
                        found = true;
                        prereqs.add(new String[]{plugins[i].getId(), prereq});
                    }
                    ++j;
                }
            }
            if (!found) {
                String[] stringArray = new String[2];
                stringArray[0] = plugins[i].getId();
                prereqs.add(stringArray);
            }
            if (!plugins[i].getId().equals("org.apache.xerces")) {
                if (!boot && pluginList.contains("org.eclipse.core.boot") && !plugins[i].getId().equals("org.eclipse.core.boot")) {
                    prereqs.add(new String[]{plugins[i].getId(), "org.eclipse.core.boot"});
                }
                if (!runtime && pluginList.contains("org.eclipse.core.runtime") && !plugins[i].getId().equals("org.eclipse.core.runtime") && !plugins[i].getId().equals("org.eclipse.core.boot")) {
                    prereqs.add(new String[]{plugins[i].getId(), "org.eclipse.core.runtime"});
                }
            }
            ++i;
        }
        String[][] prereqArray = (String[][])prereqs.toArray((T[])new String[prereqs.size()][]);
        return Utils.computeNodeOrder(prereqArray);
    }

    private static String[] insertFragments(String[] orderedPlugins, PluginModel[] fragments) {
        ArrayList<String> sortedPluginList = new ArrayList<String>(Arrays.asList(orderedPlugins));
        int i = 0;
        while (i < fragments.length) {
            int index = sortedPluginList.indexOf(fragments[i].getPluginId());
            if (index == -1) {
                sortedPluginList.add(((PluginFragmentModel)fragments[i]).getId());
            } else {
                sortedPluginList.add(index + 1, ((PluginFragmentModel)fragments[i]).getId());
            }
            ++i;
        }
        return sortedPluginList.toArray(new String[sortedPluginList.size()]);
    }

    protected static String[] computeNodeOrder(String[][] specs) {
        HashMap counts = Utils.computeCounts(specs);
        ArrayList nodes = new ArrayList(counts.size());
        while (!counts.isEmpty()) {
            List roots = Utils.findRootNodes(counts);
            if (roots.isEmpty()) break;
            Iterator i = roots.iterator();
            while (i.hasNext()) {
                counts.remove(i.next());
            }
            nodes.addAll(roots);
            Utils.removeArcs(specs, roots, counts);
        }
        String[] result = new String[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    protected static List findRootNodes(Map counts) {
        ArrayList<String> result = new ArrayList<String>(5);
        Iterator i = counts.keySet().iterator();
        while (i.hasNext()) {
            String node = (String)i.next();
            int count = (Integer)counts.get(node);
            if (count != 0) continue;
            result.add(node);
        }
        return result;
    }

    protected static void removeArcs(String[][] mappings, List roots, Map counts) {
        Iterator j = roots.iterator();
        while (j.hasNext()) {
            String root = (String)j.next();
            int i = 0;
            while (i < mappings.length) {
                String input;
                Integer count;
                if (root.equals(mappings[i][1]) && (count = (Integer)counts.get(input = mappings[i][0])) != null) {
                    counts.put(input, new Integer(count - 1));
                }
                ++i;
            }
        }
    }

    protected static HashMap computeCounts(String[][] mappings) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>(5);
        int i = 0;
        while (i < mappings.length) {
            String from = mappings[i][0];
            Integer fromCount = (Integer)counts.get(from);
            String to = mappings[i][1];
            if (to == null) {
                counts.put(from, new Integer(0));
            } else {
                if ((Integer)counts.get(to) == null) {
                    counts.put(to, new Integer(0));
                }
                fromCount = fromCount == null ? new Integer(1) : new Integer(fromCount + 1);
                counts.put(from, fromCount);
            }
            ++i;
        }
        return counts;
    }

    public static ArrayList getArrayList(Object[] args) {
        ArrayList<Object> result = new ArrayList<Object>(args.length);
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    public static IPath makeRelative(IPath location, IPath base) {
        IPath result = location;
        if (result.getDevice() != null && !result.getDevice().equalsIgnoreCase(base.getDevice())) {
            return location;
        }
        int baseCount = base.segmentCount();
        int count = base.matchingFirstSegments(result);
        String temp = "";
        int j = 0;
        while (j < baseCount - count) {
            temp = String.valueOf(temp) + "../";
            ++j;
        }
        result = new Path(temp).append(result.removeFirstSegments(count));
        return result;
    }

    public static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead != -1) {
                    destination.write(buffer, 0, bytesRead);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var4_6 = null;
        try {
            source.close();
        }
        catch (IOException iOException) {}
        try {
            destination.close();
        }
        catch (IOException iOException) {}
    }
}

